/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.actions.GinyUtils;
import cytoscape.data.GraphObjAttributes;
import cytoscape.view.NetworkView;
import giny.view.EdgeView;
import giny.view.GraphView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GinyEdgeControlDialog
extends JDialog {
    NetworkView networkView;
    GraphView view;
    String[] edgeNames;
    HashMap edgeNamesHash;
    TreePath[] selectedTreePaths;
    GraphObjAttributes edgeAttributes;
    JTree tree;

    public GinyEdgeControlDialog(NetworkView networkView, HashMap edgeNamesHash, String title) {
        super((Frame)networkView.getMainFrame(), false);
        this.networkView = networkView;
        this.edgeNamesHash = edgeNamesHash;
        this.view = networkView.getView();
        this.edgeAttributes = networkView.getNetwork().getEdgeAttributes();
        this.setTitle(title);
        this.setContentPane(this.createTreeViewGui());
    }

    JPanel createTreeViewGui() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.createTreeView(this.edgeNamesHash));
        contentPane.add((Component)scrollPane, "Center");
        JPanel actionButtonPanel = new JPanel();
        actionButtonPanel.setLayout(new GridLayout(4, 2));
        JButton hideButton = new JButton("Hide");
        JButton hideOthersButton = new JButton("Hide Others");
        JButton hideAllButton = new JButton("Hide All");
        JButton showAllButton = new JButton("Show All");
        JButton selectButton = new JButton("Select");
        JButton selectOthersButton = new JButton("Select Others");
        JButton selectAllButton = new JButton("Select All");
        JButton deselectAllButton = new JButton("Deselect All");
        JButton dismissButton = new JButton("Dismiss");
        actionButtonPanel.add(selectButton);
        actionButtonPanel.add(hideButton);
        actionButtonPanel.add(selectOthersButton);
        actionButtonPanel.add(hideOthersButton);
        actionButtonPanel.add(selectAllButton);
        actionButtonPanel.add(hideAllButton);
        actionButtonPanel.add(deselectAllButton);
        actionButtonPanel.add(showAllButton);
        hideButton.addActionListener(new HideAction());
        hideOthersButton.addActionListener(new HideOthersAction());
        hideAllButton.addActionListener(new HideAllAction());
        showAllButton.addActionListener(new ShowAllAction());
        selectButton.addActionListener(new SelectAction());
        selectAllButton.addActionListener(new SelectAllAction());
        deselectAllButton.addActionListener(new DeselectAllAction());
        selectOthersButton.addActionListener(new SelectOthersAction());
        dismissButton.addActionListener(new DismissAction());
        JPanel allButtonsPanel = new JPanel();
        allButtonsPanel.setLayout(new BorderLayout());
        allButtonsPanel.add((Component)actionButtonPanel, "Center");
        allButtonsPanel.add((Component)dismissButton, "South");
        contentPane.add((Component)allButtonsPanel, "South");
        return contentPane;
    }

    protected JTree createTreeView(HashMap edgeNamesHash) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Edge Attributes");
        this.createTreeNodes(root, edgeNamesHash);
        this.tree = new JTree(root);
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        return this.tree;
    }

    protected void createTreeNodes(DefaultMutableTreeNode root, HashMap edgeNamesHash) {
        DefaultMutableTreeNode branch = null;
        Object leaf = null;
        String[] topLevelNames = edgeNamesHash.keySet().toArray(new String[0]);
        Arrays.sort(topLevelNames, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < topLevelNames.length; ++i) {
            branch = new DefaultMutableTreeNode(topLevelNames[i]);
            String[] children = (String[])edgeNamesHash.get(topLevelNames[i]);
            Arrays.sort(children, String.CASE_INSENSITIVE_ORDER);
            for (int j = 0; j < children.length; ++j) {
                branch.add(new DefaultMutableTreeNode(children[j]));
            }
            root.add(branch);
        }
    }

    boolean pathMatchesEdge(String edgeName, TreePath treePath, GraphObjAttributes edgeAttributes) {
        Object[] objPath = treePath.getPath();
        String[] pathNames = new String[objPath.length];
        for (int i = 0; i < pathNames.length; ++i) {
            pathNames[i] = objPath[i].toString();
        }
        int pathLength = pathNames.length;
        if (pathLength < 2) {
            return false;
        }
        if (!edgeAttributes.hasAttribute(pathNames[1], edgeName)) {
            return false;
        }
        if (pathLength == 2) {
            return true;
        }
        if (pathLength == 3) {
            String[] values = edgeAttributes.getStringArrayValues(pathNames[1], edgeName);
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equalsIgnoreCase(pathNames[2])) continue;
                return true;
            }
        }
        return false;
    }

    protected void hideEdgesByName(TreePath treePath) {
        List list = this.view.getEdgeViewsList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            EdgeView ev = (EdgeView)i.next();
            String edgeName = this.edgeAttributes.getCanonicalName(ev.getEdge());
            if (!this.pathMatchesEdge(edgeName, treePath, this.edgeAttributes)) continue;
            this.view.hideGraphObject(ev);
        }
    }

    protected void hideOtherEdges() {
        EdgeView ev;
        Vector<EdgeView> keepVisibleList = new Vector<EdgeView>();
        if (this.selectedTreePaths == null) {
            return;
        }
        List list = this.view.getEdgeViewsList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ev = (EdgeView)i.next();
            String canonicalName = this.edgeAttributes.getCanonicalName(ev.getEdge());
            for (int p = 0; p < this.selectedTreePaths.length; ++p) {
                TreePath treePath = this.selectedTreePaths[p];
                if (!this.pathMatchesEdge(canonicalName, treePath, this.edgeAttributes)) continue;
                keepVisibleList.add(ev);
            }
        }
        list = this.view.getEdgeViewsList();
        i = list.iterator();
        while (i.hasNext()) {
            ev = (EdgeView)i.next();
            if (keepVisibleList.contains(ev)) continue;
            this.view.hideGraphObject(ev);
        }
    }

    protected void inverseHideEdgesByName(TreePath treePath) {
        List list = this.view.getEdgeViewsList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            EdgeView ev = (EdgeView)i.next();
            String edgeName = this.edgeAttributes.getCanonicalName(ev.getEdge());
            if (this.pathMatchesEdge(edgeName, treePath, this.edgeAttributes)) continue;
            this.view.hideGraphObject(ev);
        }
    }

    protected void selectEdgesByName(TreePath treePath) {
        List list = this.view.getEdgeViewsList();
        Vector<EdgeView> vector = new Vector<EdgeView>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            EdgeView ev = (EdgeView)i.next();
            String canonicalName = this.edgeAttributes.getCanonicalName(ev.getEdge());
            if (!this.pathMatchesEdge(canonicalName, treePath, this.edgeAttributes)) continue;
            vector.add(ev);
        }
        Iterator vi = vector.iterator();
        while (vi.hasNext()) {
            EdgeView edge = (EdgeView)vi.next();
            edge.setSelected(true);
        }
    }

    protected void selectAllEdges() {
        GinyUtils.selectAllEdges(this.view);
    }

    protected void invertEdgeSelection() {
        GinyUtils.invertSelectedEdges(this.view);
    }

    protected void selectOtherEdges() {
        Vector<EdgeView> keepUnselectedList = new Vector<EdgeView>();
        List list = this.view.getEdgeViewsList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            EdgeView ev = (EdgeView)i.next();
            String canonicalName = this.edgeAttributes.getCanonicalName(ev.getEdge());
            for (int p = 0; p < this.selectedTreePaths.length; ++p) {
                TreePath treePath = this.selectedTreePaths[p];
                if (!this.pathMatchesEdge(canonicalName, treePath, this.edgeAttributes)) continue;
                keepUnselectedList.add(ev);
            }
        }
        Vector selectList = new Vector();
        list = this.view.getEdgeViewsList();
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            EdgeView ev;
            ev.setSelected(!keepUnselectedList.contains(ev = (EdgeView)i2.next()));
        }
    }

    protected void deselectAllEdges() {
        GinyUtils.deselectAllEdges(this.view);
    }

    private void placeInCenter() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        int screenHeight = (int)gc.getBounds().getHeight();
        int screenWidth = (int)gc.getBounds().getWidth();
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        this.setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2);
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyEdgeControlDialog.this.dispose();
        }
    }

    class ShowAllAction
    extends AbstractAction {
        ShowAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyUtils.unHideAllEdges(GinyEdgeControlDialog.this.view);
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyEdgeControlDialog.this.selectAllEdges();
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class HideAllAction
    extends AbstractAction {
        HideAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyUtils.hideAllEdges(GinyEdgeControlDialog.this.view);
        }
    }

    class HideOthersAction
    extends AbstractAction {
        HideOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyUtils.unHideAllEdges(GinyEdgeControlDialog.this.view);
            GinyEdgeControlDialog.this.hideOtherEdges();
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class DeselectAllAction
    extends AbstractAction {
        DeselectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyEdgeControlDialog.this.deselectAllEdges();
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class SelectOthersAction
    extends AbstractAction {
        SelectOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            GinyEdgeControlDialog.this.selectOtherEdges();
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class HideAction
    extends AbstractAction {
        HideAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            if (GinyEdgeControlDialog.this.selectedTreePaths == null || GinyEdgeControlDialog.this.selectedTreePaths.length == 0) {
                GinyEdgeControlDialog.this.getToolkit().beep();
                return;
            }
            GinyUtils.unHideAllEdges(GinyEdgeControlDialog.this.view);
            String action = e.getActionCommand();
            for (int i = 0; i < GinyEdgeControlDialog.this.selectedTreePaths.length; ++i) {
                GinyEdgeControlDialog.this.hideEdgesByName(GinyEdgeControlDialog.this.selectedTreePaths[i]);
            }
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class SelectAction
    extends AbstractAction {
        SelectAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            if (GinyEdgeControlDialog.this.selectedTreePaths == null || GinyEdgeControlDialog.this.selectedTreePaths.length == 0) {
                GinyEdgeControlDialog.this.getToolkit().beep();
                return;
            }
            GinyUtils.deselectAllEdges(GinyEdgeControlDialog.this.view);
            for (int i = 0; i < GinyEdgeControlDialog.this.selectedTreePaths.length; ++i) {
                GinyEdgeControlDialog.this.selectEdgesByName(GinyEdgeControlDialog.this.selectedTreePaths[i]);
            }
            GinyEdgeControlDialog.this.networkView.redrawGraph(false, true);
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GinyEdgeControlDialog.this.tree.getLastSelectedPathComponent();
            GinyEdgeControlDialog.this.selectedTreePaths = GinyEdgeControlDialog.this.tree.getSelectionPaths();
        }
    }
}

