/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ExpressionDataPopupTable
extends JDialog {
    Frame mainFrame;
    ExpressionDataPopupTable popupTable;
    private JTable table;
    ExpressionData geneExpressionInfo = null;

    public ExpressionDataPopupTable(Frame parentFrame, String[] geneNames, String conditionName, ExpressionData geneExpressionInfo) {
        super(parentFrame, false);
        this.mainFrame = parentFrame;
        this.setTitle(conditionName);
        this.geneExpressionInfo = geneExpressionInfo;
        this.popupTable = this;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.table = new JTable(new MultipleGenesTableModel(geneNames, conditionName));
        this.table.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.table.getDefaultRenderer(JButton.class)));
        this.table.addMouseListener(new MyMouseListener(this.table));
        JScrollPane scrollPane = new JScrollPane(this.table);
        panel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(new DismissAction(this));
        buttonPanel.add((Component)dismissButton, "Center");
        this.pack();
        panel.add((Component)buttonPanel, "South");
        this.setContentPane(panel);
    }

    public ExpressionDataPopupTable(Frame parentFrame, String geneName, String[] conditionNames, ExpressionData geneExpressionInfo) {
        super(parentFrame, false);
        this.setTitle(geneName);
        this.geneExpressionInfo = geneExpressionInfo;
        this.popupTable = this;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.table = new JTable(new MultipleConditionsTableModel(geneName, conditionNames));
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.table.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.table.getDefaultRenderer(JButton.class)));
        this.table.addMouseListener(new MyMouseListener(this.table));
        JScrollPane scrollPane = new JScrollPane(this.table);
        panel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(new DismissAction(this));
        buttonPanel.add((Component)dismissButton, "Center");
        panel.add((Component)buttonPanel, "South");
        this.setContentPane(panel);
    }

    class MyMouseListener
    implements MouseListener {
        private JTable table;

        public MyMouseListener(JTable table) {
            this.table = table;
        }

        private void forwardEventToButton(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this.table.getValueAt(row, column);
            boolean isButton = value instanceof JButton;
            if (!isButton) {
                return;
            }
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, e, button);
            button.doClick();
            this.table.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public ButtonCellRenderer(TableCellRenderer renderer) {
            this.defaultRenderer = renderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Component) {
                return (Component)value;
            }
            return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class MultipleConditionsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[3];
        Object[][] data;

        public MultipleConditionsTableModel(String geneName, String[] conditionNames) {
            this.columnNames[0] = "CONDITION";
            this.columnNames[1] = "RATIO";
            this.columnNames[2] = "LAMBDA";
            int conditionCount = conditionNames.length;
            this.data = new Object[conditionCount][3];
            for (int i = 0; i < conditionNames.length; ++i) {
                mRNAMeasurement measurement = ExpressionDataPopupTable.this.geneExpressionInfo.getMeasurement(geneName, conditionNames[i]);
                String condition = conditionNames[i];
                this.data[i][0] = condition;
                if (measurement == null) {
                    this.data[i][1] = new Double(-999999.99);
                    this.data[i][2] = new Double(-999999.99);
                    continue;
                }
                this.data[i][1] = new Double(measurement.getRatio());
                this.data[i][2] = new Double(measurement.getSignificance());
            }
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }

    class MultipleGenesTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[3];
        Object[][] data;

        public MultipleGenesTableModel(String[] geneNames, String conditionName) {
            this.columnNames[0] = "GENE";
            this.columnNames[1] = "RATIO";
            this.columnNames[2] = "LAMBDA";
            int geneCount = geneNames.length;
            this.data = new Object[geneCount][3];
            for (int i = 0; i < geneNames.length; ++i) {
                mRNAMeasurement measurement = ExpressionDataPopupTable.this.geneExpressionInfo.getMeasurement(geneNames[i], conditionName);
                String condition = conditionName;
                String name = geneNames[i];
                if (measurement != null) {
                    this.data[i][1] = new Double(measurement.getRatio());
                    this.data[i][2] = new Double(measurement.getSignificance());
                }
                JButton button = new JButton(geneNames[i]);
                button.setToolTipText("display expression values for all conditions");
                this.data[i][0] = button;
                ((JButton)this.data[i][0]).addActionListener(new ActionListener(this, name){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ MultipleGenesTableModel this$1;
                    {
                        this.this$1 = this$1;
                        this.val$name = val$name;
                    }

                    public void actionPerformed(ActionEvent e) {
                        String[] conditions = MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).geneExpressionInfo.getConditionNames();
                        ExpressionDataPopupTable crossConditionsTable = new ExpressionDataPopupTable(MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).mainFrame, this.val$name, conditions, MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).geneExpressionInfo);
                        crossConditionsTable.pack();
                        crossConditionsTable.setLocationRelativeTo(MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).mainFrame);
                        crossConditionsTable.setVisible(true);
                    }
                });
            }
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        static /* synthetic */ ExpressionDataPopupTable access$000(MultipleGenesTableModel x0) {
            return x0.ExpressionDataPopupTable.this;
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JDialog dialog;

        DismissAction(JDialog popup) {
            super("");
            this.dialog = popup;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.dispose();
        }
    }
}

