/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.data.GraphObjAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EdgeAttributesPopupDetails
extends JDialog {
    public EdgeAttributesPopupDetails(Frame parentFrame, String name, GraphObjAttributes edgeAttributes) {
        super(parentFrame, "Edge Attributes - " + name, false);
        JScrollPane scrollPanel = new JScrollPane(this.getContentComponent(edgeAttributes, name));
        JPanel buttonPanel = new JPanel();
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(new DismissAction(this));
        buttonPanel.add((Component)dismissButton, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        this.setContentPane(panel);
    }

    protected Component getContentComponent(GraphObjAttributes edgeAttributes, String name) {
        String contents = name;
        if (name.length() == 0) {
            contents = "Unable to locate attributes for selected edge";
        } else {
            String[] attributes = edgeAttributes.getAttributeNames();
            for (int i = 0; i < attributes.length; ++i) {
                Object value = edgeAttributes.getValue(attributes[i], name);
                if (value == null) continue;
                contents = contents + "\n\n" + attributes[i] + ":\n" + value;
            }
        }
        JTextArea textArea = new JTextArea(contents, 8, 40);
        return textArea;
    }

    protected class DismissAction
    extends AbstractAction {
        private JDialog dialog;

        DismissAction(JDialog dialog) {
            super("");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.dispose();
        }
    }
}

