/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.GraphObjAttributes;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GraphObjAttributesTest
extends TestCase {
    public GraphObjAttributesTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
    }

    public void testSet() throws Exception {
        AllTests.standardOut("testSet");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        attributes.set("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        attributes.set("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        attributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
    }

    public void testGetSingleStringValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleStringValueFromVector");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        String firstSynonym = "synonym 1";
        String secondSynonym = "synonym 2";
        attributes.append("synonym", "GAL4", firstSynonym);
        attributes.append("synonym", "GAL4", secondSynonym);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        String synonym = attributes.getStringValue("synonym", "GAL4");
        GraphObjAttributesTest.assertTrue(synonym.equals(firstSynonym));
    }

    public void testGetSingleDoubleValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleDoubleValueFromVector");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        Double d0 = new Double(1.0);
        Double d1 = new Double(2.0);
        attributes.append("score", "GAL4", d0);
        attributes.append("score", "GAL4", d1);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        Double retrievedValue = attributes.getDoubleValue("score", "GAL4");
        GraphObjAttributesTest.assertTrue(retrievedValue.equals(d0));
        Object[] objs = attributes.getArrayValues("score", "GAL4");
        GraphObjAttributesTest.assertTrue(objs.length == 2);
        Double retrieved0 = (Double)objs[0];
        Double retrieved1 = (Double)objs[1];
        GraphObjAttributesTest.assertTrue(retrieved0.equals(d0));
        GraphObjAttributesTest.assertTrue(retrieved1.equals(d1));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        attributes.add("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        attributes.add("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        attributes.add("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
        GraphObjAttributes copy = (GraphObjAttributes)attributes.clone();
        GraphObjAttributesTest.assertTrue(copy.numberOfAttributes() == 2);
        attributes.deleteAttribute("expressionLevel");
        attributes.deleteAttribute("foo");
        GraphObjAttributesTest.assertTrue(copy.numberOfAttributes() == 2);
        GraphObjAttributes v2 = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(v2.numberOfAttributes() == 0);
        v2.add(copy);
        GraphObjAttributesTest.assertTrue(v2.numberOfAttributes() == 2);
        HashMap bundle = v2.getAttributes("GAL4");
        GraphObjAttributesTest.assertTrue(bundle.size() == 2);
        v2.deleteAttribute("expressionLevel");
        v2.deleteAttribute("foo");
        GraphObjAttributesTest.assertTrue(v2.numberOfAttributes() == 0);
        v2.add("GAL4", bundle);
        GraphObjAttributesTest.assertTrue(v2.numberOfAttributes() == 2);
        v2.add("whimsical", "GAL4", 101.101);
        HashMap gal4Bundle = v2.getAttributes("GAL4");
        GraphObjAttributesTest.assertTrue(gal4Bundle.size() == 3);
        Double whimsicalRetrieved = (Double)gal4Bundle.get("whimsical");
        GraphObjAttributesTest.assertTrue(whimsicalRetrieved.equals(new Double(101.101)));
    }

    public void testAddGraphObjAttributes() throws Exception {
        AllTests.standardOut("testAddGraphObjAttributes");
        GraphObjAttributes original = new GraphObjAttributes();
        original.set("expressionLevel", "GAL4", 1.8);
        original.set("expressionLevel", "GAL80", 0.01);
        original.set("foo", "GAL4", 321.23);
        original.set("bar", "GAL4", "The Columbia City Ale House");
        GraphObjAttributesTest.assertTrue(original.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue(original.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue(original.hasAttribute("bar"));
        GraphObjAttributesTest.assertTrue(!original.hasAttribute("BAR"));
        GraphObjAttributesTest.assertTrue(original.getClass("expressionLevel") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(original.getClass("foo") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(original.getClass("bar") == "string".getClass());
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.assertTrue(original.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributes additional = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magic = "abracadabra";
        String nodeName = "GAL4";
        additional.set("homology", nodeName, homology);
        additional.set("count", nodeName, count);
        additional.set("magic", nodeName, magic);
        GraphObjAttributesTest.assertTrue(additional.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(additional.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.assertTrue(additional.getClass("magic") == "string".getClass());
        GraphObjAttributesTest.assertTrue(additional.getDoubleValue("homology", nodeName).equals(homology));
        GraphObjAttributesTest.assertTrue(additional.getIntegerValue("count", nodeName).equals(count));
        GraphObjAttributesTest.assertTrue(additional.getStringValue("magic", nodeName).equals(magic));
        original.add(additional);
        GraphObjAttributesTest.assertTrue(original.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue(original.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue(original.hasAttribute("bar"));
        GraphObjAttributesTest.assertTrue(!original.hasAttribute("BAR"));
        GraphObjAttributesTest.assertTrue(original.getClass("expressionLevel") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(original.getClass("foo") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(original.getClass("bar") == "string".getClass());
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.assertTrue(original.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.assertTrue(original.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributesTest.assertTrue(additional.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(additional.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.assertTrue(additional.getClass("magic") == "string".getClass());
        GraphObjAttributesTest.assertTrue(additional.getDoubleValue("homology", nodeName).equals(homology));
        GraphObjAttributesTest.assertTrue(additional.getIntegerValue("count", nodeName).equals(count));
        GraphObjAttributesTest.assertTrue(additional.getStringValue("magic", nodeName).equals(magic));
    }

    public void testHasAttribute() throws Exception {
        AllTests.standardOut("testHasAttribute");
        GraphObjAttributes attributes = new GraphObjAttributes();
        attributes.set("expressionLevel", "GAL4", 1.8);
        attributes.set("expressionLevel", "GAL80", 0.01);
        attributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("bar"));
        GraphObjAttributesTest.assertTrue(attributes.getObjectCount("expressionLevel") == 2);
        GraphObjAttributesTest.assertTrue(attributes.getObjectCount("foo") == 1);
        GraphObjAttributesTest.assertTrue(attributes.getObjectCount("bar") == 0);
        String[] names = attributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue(names.length == 2);
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("expressionLevel", "GAL4"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("expressionLevel", "GAL80"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("foo", "GAL4"));
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("foo", "GAL4bogus"));
    }

    public void testGetAttributeNames() throws Exception {
        AllTests.standardOut("testGetAttributeNames");
        GraphObjAttributes attributes = new GraphObjAttributes();
        attributes.set("expressionLevel", "GAL4", 1.8);
        attributes.set("expressionLevel", "GAL80", 0.01);
        attributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
        String[] names = attributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue(names.length == 2);
    }

    public void testGetAttributeByName() throws Exception {
        AllTests.standardOut("testGetAttributeByName");
        GraphObjAttributes attributes = new GraphObjAttributes();
        attributes.set("expressionLevel", "GAL4", 1.8);
        attributes.set("expressionLevel", "GAL80", 0.01);
        attributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
        String[] names = attributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue(names.length == 2);
        HashMap expressionLevels = attributes.getAttribute("expressionLevel");
        GraphObjAttributesTest.assertTrue(expressionLevels != null);
        GraphObjAttributesTest.assertTrue(expressionLevels.size() == 2);
        GraphObjAttributesTest.assertTrue(attributes.getClass("expressionLevel") == Class.forName("java.lang.Double"));
        Object obj = expressionLevels.get("GAL4");
        GraphObjAttributesTest.assertTrue(obj.getClass() == Class.forName("java.lang.Double"));
        HashMap foo = attributes.getAttribute("foo");
        GraphObjAttributesTest.assertTrue(foo != null);
        GraphObjAttributesTest.assertTrue(foo.size() == 1);
        HashMap bar = attributes.getAttribute("bar");
        GraphObjAttributesTest.assertTrue(bar == null);
    }

    public void testGetOneGeneAttribute() throws Exception {
        AllTests.standardOut("testGetOneGeneAttribute");
        GraphObjAttributes attributes = new GraphObjAttributes();
        double gal4_exp = 1.8;
        double gal80_exp = 0.01;
        attributes.set("expressionLevel", "GAL4", gal4_exp);
        attributes.set("expressionLevel", "GAL80", gal80_exp);
        Double gal4_foo = new Double(321.23);
        attributes.set("foo", "GAL4", gal4_foo);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
        Double actual = attributes.getDoubleValue("expressionLevel", "GAL4");
        GraphObjAttributesTest.assertTrue(actual.compareTo(new Double(gal4_exp)) == 0);
        actual = attributes.getDoubleValue("expressionLevel", "GAL80");
        GraphObjAttributesTest.assertTrue(actual.compareTo(new Double(gal80_exp)) == 0);
        actual = attributes.getDoubleValue("foo", "GAL4");
        GraphObjAttributesTest.assertTrue(actual.compareTo(gal4_foo) == 0);
        actual = attributes.getDoubleValue("phoo", "GAL4");
        GraphObjAttributesTest.assertTrue(actual == null);
        actual = attributes.getDoubleValue("foo", "GUY4");
        GraphObjAttributesTest.assertTrue(actual == null);
    }

    public void testTextFileReaderOnNodeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnNodeAttributeData");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        String attributeName = "fooB";
        attributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        HashMap fooB = attributes.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue(fooB.size() == 333);
    }

    public void testTextFileReaderOnEdgeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnEdgeAttributeData");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        attributes.readAttributesFromFile(file);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        String[] attributeNames = attributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue(attributeNames.length == 1);
        HashMap edgeAttribute = attributes.getAttribute(attributeNames[0]);
        GraphObjAttributesTest.assertTrue(edgeAttribute.size() == 27);
    }

    public void testAddAttributeHash() throws Exception {
        AllTests.standardOut("testAddAttributeHash");
        GraphObjAttributes firstSet = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(firstSet.numberOfAttributes() == 0);
        String attributeName = "fooB";
        firstSet.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue(firstSet.numberOfAttributes() == 1);
        HashMap fooB = firstSet.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue(fooB.size() == 333);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        GraphObjAttributes secondSet = new GraphObjAttributes();
        secondSet.readAttributesFromFile(file);
        GraphObjAttributesTest.assertTrue(secondSet.numberOfAttributes() == 1);
        String[] attributeNames = secondSet.getAttributeNames();
        HashMap edgeAttribute = secondSet.getAttribute(attributeNames[0]);
        firstSet.set(secondSet);
        GraphObjAttributesTest.assertTrue(firstSet.numberOfAttributes() == 2);
        attributeNames = firstSet.getAttributeNames();
        GraphObjAttributesTest.assertTrue(attributeNames.length == 2);
        fooB = firstSet.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue(fooB.size() == 333);
        HashMap edgeAttribute0 = firstSet.getAttribute("edge_attribute_0");
        GraphObjAttributesTest.assertTrue(edgeAttribute0.size() == 27);
    }

    public void testNodeToNameMapping() throws Exception {
        AllTests.standardOut("testNodeToNameMapping");
        GraphObjAttributes nodeAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(nodeAttributes.numberOfAttributes() == 0);
        String attributeName = "fooB";
        nodeAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue(nodeAttributes.numberOfAttributes() == 1);
        HashMap fooB = nodeAttributes.getAttribute(attributeName);
        GraphObjAttributesTest.assertTrue(fooB.size() == 333);
        Integer obj1 = new Integer(1);
        Integer obj2 = new Integer(2);
        String[] nodeNames = nodeAttributes.getObjectNames(attributeName);
        int index1 = nodeNames.length / 2;
        int index2 = nodeNames.length / 3;
        String name1 = nodeNames[nodeNames.length / 2];
        String name2 = nodeNames[nodeNames.length / 3];
        GraphObjAttributesTest.assertTrue(name1 != null);
        GraphObjAttributesTest.assertTrue(name2 != null);
        GraphObjAttributesTest.assertTrue(name1.length() > 0);
        GraphObjAttributesTest.assertTrue(name2.length() > 0);
        nodeAttributes.addNameMapping(name1, obj1);
        nodeAttributes.addNameMapping(name2, obj2);
        String canonicalName1 = nodeAttributes.getCanonicalName(obj1);
        GraphObjAttributesTest.assertTrue(canonicalName1.equals(name1));
        String canonicalName2 = nodeAttributes.getCanonicalName(obj2);
        GraphObjAttributesTest.assertTrue(canonicalName2.equals(name2));
        String intentionalError = nodeAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue(intentionalError == null);
    }

    public void testGetAttributesBundle() throws Exception {
        AllTests.standardOut("testGetAttributesBundle");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magic = "abracadabra";
        String nodeName = "GAL4";
        attributes.set("homology", nodeName, homology);
        attributes.set("count", nodeName, count);
        attributes.set("magic", nodeName, magic);
        HashMap bundle = attributes.getAttributes(nodeName);
        GraphObjAttributesTest.assertTrue(bundle.size() == 3);
        Double homologyRetrieved = (Double)bundle.get("homology");
        GraphObjAttributesTest.assertTrue(homologyRetrieved.equals(homology));
        Integer countRetrieved = (Integer)bundle.get("count");
        GraphObjAttributesTest.assertTrue(countRetrieved.equals(count));
        String magicRetrieved = (String)bundle.get("magic");
        GraphObjAttributesTest.assertTrue(magicRetrieved.equals(magic));
    }

    public void testAddAttributesBundle() throws Exception {
        AllTests.standardOut("testAddAttributesBundle");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magic = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("count", count);
        bundle.put("magic", magic);
        attributes.set(nodeName, bundle);
        HashMap bundleRetrieved = attributes.getAttributes(nodeName);
        GraphObjAttributesTest.assertTrue(bundleRetrieved.size() == 3);
        Double homologyRetrieved = (Double)bundleRetrieved.get("homology");
        GraphObjAttributesTest.assertTrue(homologyRetrieved.equals(homology));
        Integer countRetrieved = (Integer)bundleRetrieved.get("count");
        GraphObjAttributesTest.assertTrue(countRetrieved.equals(count));
        String magicRetrieved = (String)bundleRetrieved.get("magic");
        GraphObjAttributesTest.assertTrue(magicRetrieved.equals(magic));
    }

    public void testCountDuplicateNamesForAttribute() throws Exception {
        AllTests.standardOut("testCountDuplicateNamesForAttribute");
        GraphObjAttributes attributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(attributes.countIdentical("A") == 0);
        GraphObjAttributesTest.assertTrue(attributes.countIdentical("B") == 0);
        GraphObjAttributesTest.assertTrue(attributes.countIdentical("A") == 1);
        GraphObjAttributesTest.assertTrue(attributes.countIdentical("A") == 2);
        GraphObjAttributesTest.assertTrue(attributes.countIdentical("B") == 1);
    }

    public void testGetAndAddNameMapping() throws Exception {
        AllTests.standardOut("testGetAndAddNameMapping");
        GraphObjAttributes nodeAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue(nodeAttributes.numberOfAttributes() == 0);
        String attributeName = "fooB";
        nodeAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue(nodeAttributes.numberOfAttributes() == 1);
        HashMap fooB = nodeAttributes.getAttribute(attributeName);
        GraphObjAttributesTest.assertTrue(fooB.size() == 333);
        Integer obj1 = new Integer(1);
        Integer obj2 = new Integer(2);
        String[] nodeNames = nodeAttributes.getObjectNames(attributeName);
        int index1 = nodeNames.length / 2;
        int index2 = nodeNames.length / 3;
        String name1 = nodeNames[index1];
        String name2 = nodeNames[index2];
        GraphObjAttributesTest.assertTrue(name1 != null);
        GraphObjAttributesTest.assertTrue(name2 != null);
        GraphObjAttributesTest.assertTrue(name1.length() > 0);
        GraphObjAttributesTest.assertTrue(name2.length() > 0);
        nodeAttributes.addNameMapping(name1, obj1);
        nodeAttributes.addNameMapping(name2, obj2);
        String canonicalName1 = nodeAttributes.getCanonicalName(obj1);
        GraphObjAttributesTest.assertTrue(canonicalName1.equals(name1));
        String canonicalName2 = nodeAttributes.getCanonicalName(obj2);
        GraphObjAttributesTest.assertTrue(canonicalName2.equals(name2));
        String intentionalError = nodeAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue(intentionalError == null);
        HashMap nameMap = nodeAttributes.getNameMap();
        GraphObjAttributesTest.assertTrue(nameMap.size() == 2);
        nodeAttributes.addNameMap(nameMap);
        GraphObjAttributesTest.assertTrue(nameMap.size() == 2);
        HashMap<Integer, String> newMap = new HashMap<Integer, String>();
        Integer obj3 = new Integer(3);
        Integer obj4 = new Integer(4);
        int index3 = nodeNames.length / 4;
        int index4 = nodeNames.length / 5;
        String name3 = nodeNames[index3];
        String name4 = nodeNames[index4];
        newMap.put(obj3, name3);
        newMap.put(obj4, name4);
        nodeAttributes.addNameMap(newMap);
        GraphObjAttributesTest.assertTrue(nameMap.size() == 4);
        String canonicalName3 = nodeAttributes.getCanonicalName(obj3);
        GraphObjAttributesTest.assertTrue(canonicalName3.equals(name3));
        String canonicalName4 = nodeAttributes.getCanonicalName(obj4);
        GraphObjAttributesTest.assertTrue(canonicalName4.equals(name4));
        intentionalError = nodeAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue(intentionalError == null);
    }

    public void testGetAttributeClass() throws Exception {
        AllTests.standardOut("testGetAttributeClass");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magic = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("count", count);
        bundle.put("magic", magic);
        attributes.set(nodeName, bundle);
        attributes.setClass("homology", homology.getClass());
        attributes.setClass("count", count.getClass());
        attributes.setClass("magic", magic.getClass());
        GraphObjAttributesTest.assertTrue(attributes.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.assertTrue(attributes.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.assertTrue(attributes.getClass("magic") == "string".getClass());
    }

    public void testCloning() throws Exception {
        AllTests.standardOut("testCloning");
        GraphObjAttributes original = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String originalMagicWord = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("count", count);
        bundle.put("magic", originalMagicWord);
        original.set(nodeName, bundle);
        GraphObjAttributes clone = (GraphObjAttributes)original.clone();
        GraphObjAttributesTest.assertTrue(original != clone);
        String magicWordRetrievedFromOriginal = (String)original.getValue("magic", "GAL4");
        String magicWordRetrievedFromClone = (String)clone.getValue("magic", "GAL4");
        GraphObjAttributesTest.assertTrue(magicWordRetrievedFromOriginal.equals(originalMagicWord));
        GraphObjAttributesTest.assertTrue(magicWordRetrievedFromClone.equals(originalMagicWord));
        String newMagicWord = "shazam!";
        clone.set("magic", "GAL4", newMagicWord);
        String magicWordFromClone = (String)clone.get("magic", "GAL4");
        GraphObjAttributesTest.assertTrue(magicWordFromClone.equals(newMagicWord));
        String magicWordFromOriginal = (String)original.get("magic", "GAL4");
        GraphObjAttributesTest.assertTrue(magicWordFromOriginal.equals(originalMagicWord));
    }

    public void testDeleteAttribute() throws Exception {
        AllTests.standardOut("testDeleteAttribute");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magicWord = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("count", count);
        bundle.put("magic", magicWord);
        attributes.set(nodeName, bundle);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 3);
        attributes.deleteAttribute("homology");
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 2);
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("homology"));
        attributes.deleteAttribute("count");
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("count"));
        attributes.deleteAttribute("magic");
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 0);
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("magic"));
    }

    public void testDeleteAttributeForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeForOneGraphObject");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        Integer count = new Integer(33);
        String magicWord = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("count", count);
        bundle.put("magic", magicWord);
        attributes.set(nodeName, bundle);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 3);
        attributes.append("homology", "GAL80", new Double(888.88));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("homology", "GAL4"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("count", "GAL4"));
        attributes.deleteAttribute("homology", "GAL4");
        GraphObjAttributesTest.assertTrue(!attributes.hasAttribute("homology", "GAL4"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.assertTrue(attributes.hasAttribute("count", "GAL4"));
    }

    public void testDeleteAttributeValueForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeValueForOneGraphObject");
        GraphObjAttributes attributes = new GraphObjAttributes();
        attributes.append("homolog", "GAL4", "h0");
        attributes.append("homolog", "GAL4", "h1");
        attributes.append("homolog", "GAL4", "h2");
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 1);
        String[] homologNames = attributes.getStringArrayValues("homolog", "GAL4");
        GraphObjAttributesTest.assertTrue(homologNames.length == 3);
        attributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 2);
        attributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 2);
        attributes.deleteAttributeValue("homolog", "GAL4", "hohoho");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 2);
        attributes.deleteAttributeValue("homolog", "GAL4", "hobo");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 2);
        attributes.deleteAttributeValue("homolog", "GAL5", "hobo");
        attributes.deleteAttributeValue("homologue", "GAL4", "hobo");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 2);
        attributes.deleteAttributeValue("homolog", "GAL4", "h1");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 1);
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4")[0].equals("h2"));
        attributes.deleteAttributeValue("homolog", "GAL4", "h2");
        GraphObjAttributesTest.assertTrue(attributes.getStringArrayValues("homolog", "GAL4").length == 0);
    }

    public void testAttributeCategories() throws Exception {
        AllTests.standardOut("testAttributeCategories");
        GraphObjAttributes attributes = new GraphObjAttributes();
        Double homology = new Double(99.32);
        String biologicalProcess = "amino acid synthesis";
        String magicWord = "abracadabra";
        String nodeName = "GAL4";
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.put("homology", homology);
        bundle.put("biological process", biologicalProcess);
        bundle.put("magic", magicWord);
        attributes.set(nodeName, bundle);
        GraphObjAttributesTest.assertTrue(attributes.numberOfAttributes() == 3);
        attributes.setCategory("homology", "numerical");
        attributes.setCategory("biological process", "annotation");
        GraphObjAttributesTest.assertTrue(attributes.getCategory("homology").equals("numerical"));
        GraphObjAttributesTest.assertTrue(attributes.getCategory("magic") == null);
        GraphObjAttributesTest.assertTrue(attributes.getCategory("biological process").equals("annotation"));
        GraphObjAttributesTest.assertTrue(attributes.getCategory("nonexistent") == null);
    }

    public void testProcessFileHeader() throws Exception {
        AllTests.standardOut("testProcessFileHeader");
        String s0 = "SNP Count";
        String s1 = "SNP Count (category=data)";
        String s2 = "SNP Count (class=java.lang.Integer)";
        String s3 = "SNP Count (category=data) (class=java.lang.Integer)";
        GraphObjAttributes a = new GraphObjAttributes();
        a.processFileHeader(s0);
        a.processFileHeader(s1);
        a.processFileHeader(s2);
        a.processFileHeader(s3);
    }

    public void testClassDeduction() throws Exception {
        AllTests.standardOut("testClassDeduction");
        String integerString = "32";
        String doubleString = "32.23";
        String urlString = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        String string = "a very fine day in Havanna";
        Class deducedClass = GraphObjAttributes.deduceClass(doubleString);
        GraphObjAttributesTest.assertTrue(deducedClass == Class.forName("java.lang.Double"));
        deducedClass = GraphObjAttributes.deduceClass(urlString);
        GraphObjAttributesTest.assertTrue(deducedClass == Class.forName("java.net.URL"));
        deducedClass = GraphObjAttributes.deduceClass(string);
        GraphObjAttributesTest.assertTrue(deducedClass == Class.forName("java.lang.String"));
    }

    public void testObjectCreation() throws Exception {
        AllTests.standardOut("testObjectCreation");
        Class<?> integerClass = Class.forName("java.lang.Integer");
        Class<?> stringClass = Class.forName("java.lang.String");
        Class<?> doubleClass = Class.forName("java.lang.Double");
        Class<?> urlClass = Class.forName("java.net.URL");
        String integerString = "32";
        String urlString = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        Object o = GraphObjAttributes.createInstanceFromString(integerClass, integerString);
        GraphObjAttributesTest.assertTrue(o.getClass() == integerClass);
        o = GraphObjAttributes.createInstanceFromString(stringClass, integerString);
        GraphObjAttributesTest.assertTrue(o.getClass() == stringClass);
        o = GraphObjAttributes.createInstanceFromString(doubleClass, integerString);
        GraphObjAttributesTest.assertTrue(o.getClass() == doubleClass);
        o = GraphObjAttributes.createInstanceFromString(urlClass, urlString);
        GraphObjAttributesTest.assertTrue(o.getClass() == urlClass);
        try {
            o = GraphObjAttributes.createInstanceFromString(urlClass, integerString);
            GraphObjAttributesTest.assertTrue(o.getClass() == urlClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o = GraphObjAttributes.createInstanceFromString(doubleClass, urlString);
            GraphObjAttributesTest.assertTrue(o.getClass() == stringClass);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testAttributeCategoryAndClassDetection() throws Exception {
        AllTests.standardOut("testAttributeCategoryAndClassDetection");
        GraphObjAttributes a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/implicitStringNoCategory.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.assertTrue(a.getCategory("sample zero").equals("unknown"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/explicitStringNoCategory.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.assertTrue(a.getCategory("sample zero").equals("unknown"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/implicitStringWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.assertTrue(a.getCategory("sample zero").equals("annotation"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/explicitStringWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.assertTrue(a.getCategory("sample zero").equals("annotation"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/explicitUrlWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("locusLink") == Class.forName("java.net.URL"));
        GraphObjAttributesTest.assertTrue(a.getCategory("locusLink").equals("annotation"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/implicitDouble.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("Score") == Class.forName("java.lang.Double"));
        GraphObjAttributesTest.assertTrue(a.getCategory("Score").equals("unknown"));
        a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/implicitUrl.attribute"));
        GraphObjAttributesTest.assertTrue(a.getClass("Locus Link") == Class.forName("java.net.URL"));
        GraphObjAttributesTest.assertTrue(a.getCategory("Locus Link").equals("unknown"));
    }

    public void testReadArrayAttributes() throws Exception {
        AllTests.standardOut("testReadArrayAttributes");
        String name = "GO molecular function, level 4";
        GraphObjAttributes a = new GraphObjAttributes();
        a.readAttributesFromFile(new File("testData/implicitStringArray.attribute"));
        String geneName = "HSD17B2";
        String[] geneFunctions = a.getStringArrayValues(name, geneName);
        GraphObjAttributesTest.assertTrue(geneFunctions.length == 2);
        GraphObjAttributesTest.assertTrue(geneFunctions[0].equals("membrane"));
        GraphObjAttributesTest.assertTrue(geneFunctions[1].equals("intracellular"));
        geneName = "CDH3";
        geneFunctions = a.getStringArrayValues(name, geneName);
        GraphObjAttributesTest.assertTrue(geneFunctions.length == 1);
        GraphObjAttributesTest.assertTrue(geneFunctions[0].equals("cell adhesion molecule"));
        geneName = "AP1G1";
        geneFunctions = a.getStringArrayValues(name, geneName);
        GraphObjAttributesTest.assertTrue(geneFunctions.length == 3);
        GraphObjAttributesTest.assertTrue(geneFunctions[0].equals("intracellular"));
        GraphObjAttributesTest.assertTrue(geneFunctions[1].equals("clathrin adaptor"));
        GraphObjAttributesTest.assertTrue(geneFunctions[2].equals("intracellular transporter"));
        geneName = "E2F4";
        geneFunctions = a.getStringArrayValues(name, geneName);
        GraphObjAttributesTest.assertTrue(geneFunctions.length == 1);
        GraphObjAttributesTest.assertTrue(geneFunctions[0].equals("DNA binding"));
    }

    public void testGetUniqueValues() throws Exception {
        AllTests.standardOut("testGetUniqueValues");
        String attributeName = "KEGG-2";
        GraphObjAttributes a = new GraphObjAttributes();
        a.append("KEGG", "GAL4", "xxx");
        a.append("KEGG", "GAL4", "yyy");
        a.append("KEGG", "GAL4", "zzz");
        a.append("KEGG", "GAL3", "xxx");
        a.append("KEGG", "GAL3", "yyy");
        a.append("KEGG", "GAL3", "QQQ");
        Object[] uniqueValues = a.getUniqueValues("KEGG");
        GraphObjAttributesTest.assertTrue(uniqueValues.length == 4);
        String[] uniqueStrings = a.getUniqueStringValues("KEGG");
        GraphObjAttributesTest.assertTrue(uniqueStrings.length == 4);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(GraphObjAttributesTest.class));
    }
}

