/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import cytoscape.util.GinyFactory;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FlagFilterTest
extends TestCase {
    FlagFilter filter;
    Node node1;
    Node node2;
    Node otherNode;
    Edge edge1;
    Edge edge2;
    Edge otherEdge;
    GraphPerspective gp;
    ListenerTest listener;
    FlagEvent savedEvent;

    public FlagFilterTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        RootGraph rootGraph = GinyFactory.createRootGraph();
        this.node1 = rootGraph.getNode(rootGraph.createNode());
        this.node2 = rootGraph.getNode(rootGraph.createNode());
        this.edge1 = rootGraph.getEdge(rootGraph.createEdge(this.node1, this.node2));
        this.edge2 = rootGraph.getEdge(rootGraph.createEdge(this.node2, this.node1));
        Node[] nodeArray = new Node[]{this.node1, this.node2};
        Edge[] edgeArray = new Edge[]{this.edge1, this.edge2};
        this.gp = rootGraph.createGraphPerspective(nodeArray, edgeArray);
        this.otherNode = rootGraph.getNode(rootGraph.createNode());
        this.otherEdge = rootGraph.getEdge(rootGraph.createEdge(this.node1, this.otherNode));
        this.filter = new FlagFilter(this.gp);
        this.listener = new ListenerTest();
        this.filter.addFlagEventListener(this.listener);
    }

    public void tearDown() throws Exception {
    }

    public void checkState(boolean n1, boolean n2, boolean e1, boolean e2) {
        FlagFilterTest.assertTrue(this.filter.isFlagged(this.node1) == n1);
        FlagFilterTest.assertTrue(this.filter.isFlagged(this.node2) == n2);
        FlagFilterTest.assertTrue(this.filter.isFlagged(this.edge1) == e1);
        FlagFilterTest.assertTrue(this.filter.isFlagged(this.edge2) == e2);
        FlagFilterTest.assertTrue(this.filter.passesFilter(this.node1) == n1);
        FlagFilterTest.assertTrue(this.filter.passesFilter(this.node2) == n2);
        FlagFilterTest.assertTrue(this.filter.passesFilter(this.edge1) == e1);
        FlagFilterTest.assertTrue(this.filter.passesFilter(this.edge2) == e2);
        if (n1) {
            FlagFilterTest.assertTrue(this.filter.getFlaggedNodes().contains(this.node1));
        }
        if (n2) {
            FlagFilterTest.assertTrue(this.filter.getFlaggedNodes().contains(this.node2));
        }
        if (e1) {
            FlagFilterTest.assertTrue(this.filter.getFlaggedEdges().contains(this.edge1));
        }
        if (e2) {
            FlagFilterTest.assertTrue(this.filter.getFlaggedEdges().contains(this.edge2));
        }
        int nodeCount = 0;
        if (n1) {
            ++nodeCount;
        }
        if (n2) {
            ++nodeCount;
        }
        FlagFilterTest.assertTrue(this.filter.getFlaggedNodes().size() == nodeCount);
        int edgeCount = 0;
        if (e1) {
            ++edgeCount;
        }
        if (e2) {
            ++edgeCount;
        }
        FlagFilterTest.assertTrue(this.filter.getFlaggedEdges().size() == edgeCount);
    }

    public void checkEvent(Object target, int targetType, boolean flagOn) {
        FlagEvent event = this.listener.getEvent();
        FlagFilterTest.assertTrue(event.getSource() == this.filter);
        FlagFilterTest.assertTrue(event.getTarget() == target);
        FlagFilterTest.assertTrue(event.getTargetType() == targetType);
        FlagFilterTest.assertTrue(event.getEventType() == flagOn);
    }

    public void testSingleFlags() throws Exception {
        this.checkState(false, false, false, false);
        this.filter.setFlagged(this.node1, true);
        this.checkState(true, false, false, false);
        this.checkEvent(this.node1, 0, true);
        this.filter.setFlagged(this.edge1, true);
        this.checkState(true, false, true, false);
        this.checkEvent(this.edge1, 1, true);
        this.filter.setFlagged(this.node2, true);
        this.checkState(true, true, true, false);
        this.checkEvent(this.node2, 0, true);
        this.filter.setFlagged(this.edge2, true);
        this.checkState(true, true, true, true);
        this.checkEvent(this.edge2, 1, true);
        this.filter.setFlagged(this.edge1, false);
        this.checkState(true, true, false, true);
        this.checkEvent(this.edge1, 1, false);
        this.filter.setFlagged(this.node1, false);
        this.checkState(false, true, false, true);
        this.checkEvent(this.node1, 0, false);
        this.savedEvent = this.listener.getEvent();
        this.filter.setFlagged(this.edge2, true);
        this.checkState(false, true, false, true);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setFlagged(this.node2, true);
        this.checkState(false, true, false, true);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setFlagged(this.edge2, false);
        this.checkState(false, true, false, false);
        this.checkEvent(this.edge2, 1, false);
        this.filter.setFlagged(this.node2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(this.node2, 0, false);
        this.savedEvent = this.listener.getEvent();
        this.filter.setFlagged(this.node1, false);
        this.checkState(false, false, false, false);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setFlagged(this.edge1, false);
        this.checkState(false, false, false, false);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
    }

    public void testGroupFlags() {
        Set testSet = null;
        this.checkState(false, false, false, false);
        HashSet<Node> nodeSet1 = new HashSet<Node>();
        nodeSet1.add(this.node1);
        testSet = this.filter.setFlaggedNodes(nodeSet1, true);
        this.checkState(true, false, false, false);
        this.checkEvent(testSet, 2, true);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.node1));
        HashSet<Edge> edgeSet1 = new HashSet<Edge>();
        edgeSet1.add(this.edge2);
        testSet = this.filter.setFlaggedEdges(edgeSet1, true);
        this.checkState(true, false, false, true);
        this.checkEvent(testSet, 3, true);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.edge2));
        HashSet<Node> nodeSet2 = new HashSet<Node>();
        nodeSet2.add(this.node1);
        nodeSet2.add(this.node2);
        testSet = this.filter.setFlaggedNodes(nodeSet2, true);
        this.checkState(true, true, false, true);
        this.checkEvent(testSet, 2, true);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.node2));
        HashSet<Edge> edgeSet2 = new HashSet<Edge>();
        edgeSet2.add(this.edge1);
        edgeSet2.add(this.edge2);
        testSet = this.filter.setFlaggedEdges(edgeSet2, true);
        this.checkState(true, true, true, true);
        this.checkEvent(testSet, 3, true);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.edge1));
        testSet = this.filter.setFlaggedNodes(nodeSet1, false);
        this.checkState(false, true, true, true);
        this.checkEvent(testSet, 2, false);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.node1));
        testSet = this.filter.setFlaggedEdges(edgeSet1, false);
        this.checkState(false, true, true, false);
        this.checkEvent(testSet, 3, false);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.edge2));
        testSet = this.filter.setFlaggedNodes(nodeSet2, false);
        this.checkState(false, false, true, false);
        this.checkEvent(testSet, 2, false);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setFlaggedEdges(edgeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 3, false);
        FlagFilterTest.assertTrue(testSet.size() == 1);
        FlagFilterTest.assertTrue(testSet.contains(this.edge1));
        testSet = this.filter.setFlaggedNodes(nodeSet2, true);
        this.checkState(true, true, false, false);
        this.checkEvent(testSet, 2, true);
        FlagFilterTest.assertTrue(testSet.size() == 2);
        FlagFilterTest.assertTrue(testSet.contains(this.node1));
        FlagFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setFlaggedNodes(nodeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 2, false);
        FlagFilterTest.assertTrue(testSet.size() == 2);
        FlagFilterTest.assertTrue(testSet.contains(this.node1));
        FlagFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setFlaggedEdges(edgeSet2, true);
        this.checkState(false, false, true, true);
        this.checkEvent(testSet, 3, true);
        FlagFilterTest.assertTrue(testSet.size() == 2);
        FlagFilterTest.assertTrue(testSet.contains(this.edge1));
        FlagFilterTest.assertTrue(testSet.contains(this.edge2));
        testSet = this.filter.setFlaggedEdges(edgeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 3, false);
        FlagFilterTest.assertTrue(testSet.size() == 2);
        FlagFilterTest.assertTrue(testSet.contains(this.edge1));
        FlagFilterTest.assertTrue(testSet.contains(this.edge2));
    }

    public void testFlagAll() {
        this.checkState(false, false, false, false);
        this.filter.flagAllNodes();
        this.checkState(true, true, false, false);
        this.checkFlagAllEvent(2, 2, true);
        this.filter.unflagAllNodes();
        this.checkState(false, false, false, false);
        this.checkFlagAllEvent(2, 2, false);
        this.filter.flagAllEdges();
        this.checkState(false, false, true, true);
        this.checkFlagAllEvent(2, 3, true);
        this.filter.unflagAllEdges();
        this.checkState(false, false, false, false);
        this.checkFlagAllEvent(2, 3, false);
        this.filter.setFlagged(this.node1, true);
        this.checkState(true, false, false, false);
        this.filter.flagAllNodes();
        this.checkState(true, true, false, false);
        this.checkFlagAllEvent(1, 2, true);
        this.filter.setFlagged(this.node1, false);
        this.checkState(false, true, false, false);
        this.filter.unflagAllNodes();
        this.checkState(false, false, false, false);
        this.checkFlagAllEvent(1, 2, false);
        this.filter.setFlagged(this.edge1, true);
        this.checkState(false, false, true, false);
        this.filter.flagAllEdges();
        this.checkState(false, false, true, true);
        this.checkFlagAllEvent(1, 3, true);
        this.filter.setFlagged(this.edge1, false);
        this.checkState(false, false, false, true);
        this.filter.unflagAllEdges();
        this.checkState(false, false, false, false);
        this.checkFlagAllEvent(1, 3, false);
    }

    public void checkFlagAllEvent(int setSize, int targetType, boolean flagOn) {
        FlagEvent event = this.listener.getEvent();
        FlagFilterTest.assertTrue(event.getSource() == this.filter);
        FlagFilterTest.assertTrue(event.getTarget() instanceof Set);
        Set targetSet = (Set)event.getTarget();
        FlagFilterTest.assertTrue(targetSet.size() == setSize);
        FlagFilterTest.assertTrue(event.getTargetType() == targetType);
        FlagFilterTest.assertTrue(event.getEventType() == flagOn);
    }

    public void testListeners() {
        this.checkState(false, false, false, false);
        this.filter.setFlagged(this.node1, true);
        this.checkEvent(this.node1, 0, true);
        this.savedEvent = this.listener.getEvent();
        this.filter.removeFlagEventListener(this.listener);
        this.filter.setFlagged(this.node1, false);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.checkEvent(this.node1, 0, true);
        this.filter.setFlagged(this.edge1, true);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.checkEvent(this.node1, 0, true);
        this.filter.addFlagEventListener(this.listener);
        this.filter.setFlagged(this.edge1, false);
        FlagFilterTest.assertTrue(this.listener.getEvent() != this.savedEvent);
        this.checkEvent(this.edge1, 1, false);
        this.checkState(false, false, false, false);
        this.filter.flagAllNodes();
        this.filter.flagAllEdges();
        this.checkState(true, true, true, true);
        this.gp.hideEdge(this.edge1);
        this.checkState(true, true, false, true);
        this.checkFlagAllEvent(1, 3, false);
        this.savedEvent = this.listener.getEvent();
        this.gp.restoreEdge(this.edge1);
        this.checkState(true, true, false, true);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.unflagAllNodes();
        this.filter.unflagAllEdges();
        this.checkState(false, false, false, false);
        this.filter.flagAllNodes();
        this.filter.flagAllEdges();
        this.checkState(true, true, true, true);
        this.gp.hideNode(this.node1);
        this.checkState(false, true, false, false);
        this.checkFlagAllEvent(2, 3, false);
        this.savedEvent = this.listener.getEvent();
        this.gp.restoreNode(this.node1);
        this.checkState(false, true, false, false);
        FlagFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.unflagAllNodes();
        this.filter.unflagAllEdges();
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(FlagFilterTest.class));
    }

    private class ListenerTest
    implements FlagEventListener {
        private FlagEvent event;

        private ListenerTest() {
        }

        public void onFlagEvent(FlagEvent newEvent) {
            this.event = newEvent;
        }

        public FlagEvent getEvent() {
            return this.event;
        }
    }
}

