/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.Vector;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExpressionDataTest
extends TestCase {
    private static String testDataDir = "testData";
    private static String testDataFilename = "/gal1.22x5.mRNA";

    public ExpressionDataTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        ExpressionData data = new ExpressionData(testDataDir + testDataFilename);
        Vector measurements = data.getAllMeasurements();
        ExpressionDataTest.assertTrue(data.getNumberOfGenes() == measurements.size());
        if (data.getNumberOfGenes() > 0) {
            String gene = data.getGeneNames()[0];
            Vector geneInfo = (Vector)measurements.get(0);
            if (data.getNumberOfConditions() > 0) {
                String condition = data.getConditionNames()[0];
                mRNAMeasurement measurement = (mRNAMeasurement)geneInfo.get(0);
                ExpressionDataTest.assertTrue(measurement.getRatio() >= -200.0);
                ExpressionDataTest.assertTrue(measurement.getSignificance() >= 0.0);
            }
        }
    }

    public void testGetConditionNames() throws Exception {
        AllTests.standardOut("testGetConditionNames");
        ExpressionData data = new ExpressionData(testDataDir + testDataFilename);
        String[] conditionNames = data.getConditionNames();
        ExpressionDataTest.assertTrue(conditionNames.length == data.getNumberOfConditions());
    }

    public void testGetGeneNames() throws Exception {
        AllTests.standardOut("testGetGeneNames");
        ExpressionData data = new ExpressionData(testDataDir + testDataFilename);
        String[] geneNames = data.getGeneNames();
        ExpressionDataTest.assertTrue(geneNames.length == data.getNumberOfGenes());
    }

    public void testGetGeneDescriptors() throws Exception {
        AllTests.standardOut("testGetGeneDescriptors");
        ExpressionData data = new ExpressionData(testDataDir + testDataFilename);
        String[] geneDescriptors = data.getGeneDescriptors();
        ExpressionDataTest.assertTrue(geneDescriptors.length == data.getNumberOfGenes());
    }

    public void testGetMeasurement() throws Exception {
        AllTests.standardOut("testGetMeasurement");
        ExpressionData data = new ExpressionData(testDataDir + testDataFilename);
        if (data.getNumberOfGenes() > 0 && data.getNumberOfConditions() > 0) {
            String gene = data.getGeneNames()[0];
            String condition = data.getConditionNames()[0];
            mRNAMeasurement measurement = data.getMeasurement(gene, condition);
            double ratio = measurement.getRatio();
            double sig = measurement.getSignificance();
            ExpressionDataTest.assertTrue(ratio > -100.0);
            ExpressionDataTest.assertTrue(ratio < 1000.0);
            ExpressionDataTest.assertTrue(sig >= 0.0);
            ExpressionDataTest.assertTrue(sig < 10000.0);
        }
    }

    public static void main(String[] args) {
        File tester;
        if (args.length == 1) {
            testDataDir = args[0];
        }
        if (!(tester = new File(testDataDir)).canRead() || !tester.isDirectory()) {
            System.err.println("error! ExpressionDataTest cannot read relative directory '" + testDataDir + "'");
            System.exit(1);
        }
        TestRunner.run(new TestSuite(ExpressionDataTest.class));
    }
}

