/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.CyNetwork;
import cytoscape.CyProject;
import cytoscape.Cytoscape;
import giny.model.Edge;
import giny.model.Node;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CyNetworkFactoryTest
extends TestCase {
    public CyNetworkFactoryTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCreateEmptyNetwork() throws Exception {
        CyNetwork network = Cytoscape.createNetwork(null);
        CyNetworkFactoryTest.assertTrue(network != null);
        CyNetworkFactoryTest.assertTrue(network.getNodeCount() == 0);
        CyNetworkFactoryTest.assertTrue(network.getEdgeCount() == 0);
        CyNetworkFactoryTest.assertTrue(network.getExpressionData() == null);
    }

    public void testCreateNetworkFromInteractionsFile() throws Exception {
        Cytoscape.clearCytoscape();
        String filename = "testData/galFiltered.sif";
        CyNetwork network = Cytoscape.createNetwork(filename);
        this.verifyNetworkBasics(network);
        this.verifyInteractionAttribute(network);
    }

    public void testCreateNetworkFromInteractionsFile2() throws Exception {
        Cytoscape.clearCytoscape();
        String filename = "testData/galFiltered.sif";
        CyNetwork network = Cytoscape.createNetwork(filename, Cytoscape.FILE_SIF, false, null, null);
        this.verifyNetworkBasics(network);
        this.verifyInteractionAttribute(network);
    }

    public void testCreateNetworkFromGMLFile() throws Exception {
        Cytoscape.clearCytoscape();
        String filename = "testData/galFiltered.gml";
        CyNetwork network = Cytoscape.createNetwork(filename);
        this.verifyNetworkBasics(network);
    }

    public void testLoadAttributes() throws Exception {
        Cytoscape.clearCytoscape();
        String filename = "testData/galFiltered.gml";
        CyNetwork network = Cytoscape.createNetwork(filename);
        this.verifyNetworkBasics(network);
        String[] nodeAttrLocations = new String[]{"testData/galFiltered.nodeAttrs1", "testData/galFiltered.nodeAttrs2"};
        String[] edgeAttrLocations = new String[]{"testData/galFiltered.edgeAttrs1", "testData/galFiltered.edgeAttrs2"};
        Cytoscape.loadAttributes(nodeAttrLocations, edgeAttrLocations);
        this.verifyAttributes(network);
    }

    public void testLoadAttributes2() throws Exception {
        Cytoscape.clearCytoscape();
        String filename = "testData/galFiltered.gml";
        CyNetwork network = Cytoscape.createNetwork(filename);
        this.verifyNetworkBasics(network);
        String[] nodeAttrLocations = new String[]{"testData/galFiltered.nodeAttrs1", "testData/galFiltered.nodeAttrs2"};
        String[] edgeAttrLocations = new String[]{"testData/galFiltered.edgeAttrs1", "testData/galFiltered.edgeAttrs2"};
        Cytoscape.loadAttributes(nodeAttrLocations, edgeAttrLocations, false, null, null);
        this.verifyAttributes(network);
    }

    public void testCreateNetworkFromProject() throws Exception {
        Cytoscape.clearCytoscape();
        CyProject project = new CyProject("testData/networkProject.pro");
        CyNetwork network = Cytoscape.createNetworkFromProject(project, null);
        this.verifyNetworkBasics(network);
        this.verifyAttributes(network);
        CyNetworkFactoryTest.assertTrue(network.getExpressionData() != null);
        CyNetworkFactoryTest.assertTrue(network.getExpressionData().getNumberOfGenes() == 274);
    }

    private void verifyNetworkBasics(CyNetwork network) {
        CyNetworkFactoryTest.assertTrue(network != null);
        CyNetworkFactoryTest.assertTrue(network.getNodeCount() == 331);
        CyNetworkFactoryTest.assertTrue(network.getEdgeCount() == 362);
        Iterator i = network.nodesIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData().getCanonicalName(node) != null);
        }
        i = network.edgesList().iterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().getCanonicalName(edge) != null);
        }
    }

    private void verifyInteractionAttribute(CyNetwork network) {
        CyNetworkFactoryTest.assertTrue(network != null);
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().hasAttribute("interaction"));
        Iterator i = network.edgesList().iterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            String canonicalName = Cytoscape.getEdgeNetworkData().getCanonicalName(edge);
            String type = Cytoscape.getEdgeNetworkData().getStringValue("interaction", canonicalName);
            CyNetworkFactoryTest.assertTrue(type != null);
        }
        String oneEdge = "YBL026W (pp) YOR167C";
        String oneType = Cytoscape.getEdgeNetworkData().getStringValue("interaction", oneEdge);
        CyNetworkFactoryTest.assertTrue(oneType != null);
        CyNetworkFactoryTest.assertTrue(oneType.equals("pp"));
    }

    private void verifyAttributes(CyNetwork network) {
        CyNetworkFactoryTest.assertTrue(network != null);
        CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData() != null);
        CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData().hasAttribute("TestNodeAttribute1"));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData().getValue("TestNodeAttribute1", "YBR043C").equals(new Integer(3)));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData().hasAttribute("TestNodeAttribute2"));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getNodeNetworkData().getValue("TestNodeAttribute2", "YBR043C").equals(new Integer(6)));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData() != null);
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().hasAttribute("TestEdgeAttributes1"));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().getValue("TestEdgeAttributes1", "YBL026W (pp) YOR167C").equals(new Integer(1)));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().hasAttribute("TestEdgeAttributes2"));
        CyNetworkFactoryTest.assertTrue(Cytoscape.getEdgeNetworkData().getValue("TestEdgeAttributes2", "YBL026W (pp) YOR127C").equals(new Integer(3)));
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(CyNetworkFactoryTest.class));
    }
}

