/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.unitTests;

import cytoscape.data.synonyms.Thesaurus;
import cytoscape.unitTests.AllTests;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThesaurusTest
extends TestCase {
    public ThesaurusTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String species = "fugu";
        Thesaurus thesaurus = new Thesaurus(species);
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 0);
        ThesaurusTest.assertTrue(thesaurus.getSpecies().equals(species));
    }

    public void testAddSimplePairs() throws Exception {
        int i;
        AllTests.standardOut("testAddSimplePairs");
        String[] canonical = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] common = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue(canonical.length == common.length);
        String species = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(species);
        ThesaurusTest.assertTrue(thesaurus.getSpecies().equals(species));
        for (i = 0; i < canonical.length; ++i) {
            thesaurus.add(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 4);
        for (i = 0; i < canonical.length; ++i) {
            ThesaurusTest.assertTrue(thesaurus.getCommonName(canonical[i]).equals(common[i]));
            ThesaurusTest.assertTrue(thesaurus.getCanonicalName(common[i]).equals(canonical[i]));
            String[] allCommonNames = thesaurus.getAllCommonNames(canonical[i]);
            ThesaurusTest.assertTrue(allCommonNames.length == 1);
            ThesaurusTest.assertTrue(allCommonNames[0].equals(common[i]));
        }
    }

    public void testAddDuplicatePairs() throws Exception {
        AllTests.standardOut("testAddDuplicatePairs");
        String[] canonical = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] common = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue(canonical.length == common.length);
        String species = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(species);
        for (int i = 0; i < canonical.length; ++i) {
            thesaurus.add(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 4);
        try {
            thesaurus.add(canonical[canonical.length - 1], common[canonical.length - 1]);
            ThesaurusTest.assertTrue(true);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            thesaurus.add(canonical[canonical.length - 1], "yojo");
            ThesaurusTest.assertTrue(true);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            thesaurus.add("yojoYama", common[canonical.length - 1]);
            ThesaurusTest.assertTrue(true);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testAddRemoveAddAgain() throws Exception {
        int i;
        AllTests.standardOut("testAddRemoveAddAgain");
        String[] canonical = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] common = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue(canonical.length == common.length);
        String species = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(species);
        for (i = 0; i < canonical.length; ++i) {
            thesaurus.add(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 4);
        for (i = 0; i < canonical.length; ++i) {
            thesaurus.remove(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 0);
        for (i = 0; i < canonical.length; ++i) {
            thesaurus.add(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 4);
        for (i = 0; i < canonical.length; ++i) {
            ThesaurusTest.assertTrue(thesaurus.getCommonName(canonical[i]).equals(common[i]));
            ThesaurusTest.assertTrue(thesaurus.getCanonicalName(common[i]).equals(canonical[i]));
            String[] allCommonNames = thesaurus.getAllCommonNames(canonical[i]);
            ThesaurusTest.assertTrue(allCommonNames.length == 1);
            ThesaurusTest.assertTrue(allCommonNames[0].equals(common[i]));
        }
    }

    public void testAddAlternateCommonNames() throws Exception {
        int i;
        AllTests.standardOut("testAddAlternateCommonNames");
        String[] canonical = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] common = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        String[][] alternates = new String[][]{{"alt00", "alt01", "alt02"}, {"alt10", "alt11", "alt12"}, {"alt20", "alt21", "alt22"}, {"alt30", "alt31", "alt32"}};
        ThesaurusTest.assertTrue(canonical.length == common.length);
        String species = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(species);
        for (i = 0; i < canonical.length; ++i) {
            thesaurus.add(canonical[i], common[i]);
        }
        ThesaurusTest.assertTrue(thesaurus.canonicalNameCount() == 4);
        for (i = 0; i < canonical.length; ++i) {
            for (int j = 0; j < alternates[i].length; ++j) {
                thesaurus.addAlternateCommonName(canonical[i], alternates[i][j]);
            }
        }
        for (i = 0; i < canonical.length; ++i) {
            String[] allCommonNames = thesaurus.getAllCommonNames(canonical[i]);
            ThesaurusTest.assertTrue(allCommonNames.length == 4);
            ThesaurusTest.assertTrue(allCommonNames[0].equals(common[i]));
            for (int j = 0; j < alternates[i].length; ++j) {
                String alternate = alternates[i][j];
                ThesaurusTest.assertTrue(allCommonNames[j + 1].equals(alternates[i][j]));
            }
        }
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(ThesaurusTest.class));
    }
}

