/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.readers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.synonyms.Thesaurus;

public class ThesaurusFlatFileReader {
    Thesaurus thesaurus;
    String fullText;

    public ThesaurusFlatFileReader(String filename) throws Exception {
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading ontology flat file " + filename);
            System.err.println(e0.getMessage());
            return;
        }
        this.read();
    }

    private void read() throws Exception {
        String[] lines = this.fullText.split("\n");
        String species = lines[0].trim();
        this.thesaurus = new Thesaurus(species);
        for (int i = 1; i < lines.length; ++i) {
            String[] tokens;
            String line = lines[i].trim();
            if (line.startsWith("#") || line.length() < 3 || (tokens = lines[i].split("\\s+", 0)).length < 2) continue;
            String canonicalName = tokens[0].trim();
            String commonName = tokens[1].trim();
            if (canonicalName.length() == 0 || commonName.length() == 0) continue;
            this.thesaurus.add(canonicalName, commonName);
            for (int t = 2; t < tokens.length; ++t) {
                this.thesaurus.addAlternateCommonName(canonicalName, tokens[t].trim());
            }
        }
    }

    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }
}

