/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Thesaurus
implements Serializable {
    String species;
    HashMap canonicalToCommon;
    HashMap commonToCanonical;
    HashMap alternatesToCanonical;
    HashMap canonicalToAll;

    public Thesaurus(String species) {
        this.species = species;
        this.canonicalToCommon = new HashMap();
        this.commonToCanonical = new HashMap();
        this.alternatesToCanonical = new HashMap();
        this.canonicalToAll = new HashMap();
    }

    public String getSpecies() {
        return this.species;
    }

    public int canonicalNameCount() {
        return this.canonicalToAll.size();
    }

    public void add(String canonicalName, String commonName) {
        if (this.canonicalToCommon.containsKey(canonicalName)) {
            this.addAlternateCommonName(canonicalName, commonName);
        }
        if (!this.commonToCanonical.containsKey(commonName)) {
            this.canonicalToCommon.put(canonicalName, commonName);
        }
        this.commonToCanonical.put(commonName, canonicalName);
        this.storeAmongAllCommonNames(commonName, canonicalName);
    }

    public void remove(String canonicalName, String commonName) {
        this.canonicalToCommon.remove(canonicalName);
        this.commonToCanonical.remove(commonName);
        this.canonicalToAll.remove(canonicalName);
    }

    public void addAlternateCommonName(String canonicalName, String alternateCommonName) {
        this.alternatesToCanonical.put(alternateCommonName, canonicalName);
        this.storeAmongAllCommonNames(alternateCommonName, canonicalName);
    }

    protected void storeAmongAllCommonNames(String commonName, String canonicalName) {
        Vector allCommonNames = this.canonicalToAll.containsKey(canonicalName) ? (Vector)this.canonicalToAll.get(canonicalName) : new Vector();
        allCommonNames.add(commonName);
        this.canonicalToAll.put(canonicalName, allCommonNames);
    }

    public String getCommonName(String canonicalName) {
        return (String)this.canonicalToCommon.get(canonicalName);
    }

    public String getCanonicalName(String commonName) {
        if (this.commonToCanonical.containsKey(commonName)) {
            return (String)this.commonToCanonical.get(commonName);
        }
        if (this.alternatesToCanonical.containsKey(commonName)) {
            return (String)this.alternatesToCanonical.get(commonName);
        }
        return null;
    }

    public String[] getAllCommonNames(String canonicalName) {
        if (this.canonicalToAll.containsKey(canonicalName)) {
            Vector vector = (Vector)this.canonicalToAll.get(canonicalName);
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] getAlternateCommonNames(String canonicalName) {
        if (this.canonicalToAll.containsKey(canonicalName)) {
            Vector vector = (Vector)this.canonicalToAll.get(canonicalName);
            vector.remove(this.getCommonName(canonicalName));
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String toString() {
        int length = 0;
        if (this.canonicalToCommon != null) {
            length = this.canonicalToCommon.size();
        }
        return this.species + ": " + length;
    }
}

