/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.unitTests;

import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServer;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BioDataServerTest
extends TestCase {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BioDataServerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void notestThesaurusFromFlatFile() throws Exception {
        System.out.println("testThesaurusFromFlatFile");
        BioDataServer server = new BioDataServer();
        String[] thesaurusFiles = new String[]{"yeastThesaurusSmall.txt"};
        server.loadThesaurusFiles(thesaurusFiles);
        String species = "Saccharomyces cerevisiae";
        String canonicalName = "YOL165C";
        String commonName = "AAD15";
        BioDataServerTest.assertTrue(server.getCommonName(species, canonicalName).equals(commonName));
        canonicalName = "YPR060C";
        commonName = "ARO7";
        BioDataServerTest.assertTrue(server.getCommonName(species, canonicalName).equals(commonName));
        BioDataServerTest.assertTrue(server.getCommonName(species, commonName).equals(commonName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, commonName).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, canonicalName).equals(canonicalName));
        String[] allCommonNames = server.getAllCommonNames(species, canonicalName);
        BioDataServerTest.assertTrue(allCommonNames.length == 4);
    }

    public void notestThesaurusWithAbsentEntries() throws Exception {
        System.out.println("testThesaurusWithAbsentEntries");
        BioDataServer server = new BioDataServer();
        String[] thesaurusFiles = new String[]{"yeastThesaurusSmall.txt"};
        server.loadThesaurusFiles(thesaurusFiles);
        String species = "duck";
        String canonicalName = "duck37";
        String commonName = "duck37";
        BioDataServerTest.assertTrue(server.getCommonName("duck", "mallardase").equals("mallardase"));
        BioDataServerTest.assertTrue(server.getCanonicalName("duck", "mallardase").equals("mallardase"));
        String[] allCommonNames = server.getAllCommonNames("duck", "grebase");
        BioDataServerTest.assertTrue(allCommonNames.length == 1);
    }

    public void notestReadGoYeastAnnotation() throws Exception {
        System.out.println("testReadGoYeastAnnotation");
        String manifest = "annotations/goYeast/manifest";
        BioDataServer server = new BioDataServer(manifest);
        AnnotationDescription[] aDescs = server.getAnnotationDescriptions();
        BioDataServerTest.assertTrue(aDescs.length == 3);
        String species = "Saccharomyces cerevisiae";
        String curator = "GO";
        String orf = "YER033C";
        int[] ids = server.getClassifications(species, curator, "Molecular Function", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 5554);
        ids = server.getClassifications(species, curator, "Cellular Component", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 8372);
        ids = server.getClassifications(species, curator, "Biological Process", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 4);
        orf = "YNR016C";
        ids = server.getClassifications(species, curator, "Molecular Function", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected0 = new int[]{3989, 4075};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected0));
        ids = server.getClassifications(species, curator, "Cellular Component", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected1 = new int[]{5829, 5789};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected1));
        ids = server.getClassifications(species, curator, "Biological Process", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected2 = new int[]{6633, 6998};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected2));
    }

    public void notestReadViaHTTP() throws Exception {
        System.out.println("testReadViaHTTP");
        String manifest = "http://db.systemsbiology.net:8080/cytoscape/annotation/testDoNotDelete/manifest";
        BioDataServer server = new BioDataServer(manifest);
        AnnotationDescription[] aDescs = server.getAnnotationDescriptions();
        BioDataServerTest.assertTrue(aDescs.length == 4);
        String species = "Saccharomyces cerevisiae";
        String curator = "GO";
        String orf = "YER033C";
        int[] ids = server.getClassifications(species, curator, "Molecular Function", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 5554);
        ids = server.getClassifications(species, curator, "Cellular Component", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 8372);
        ids = server.getClassifications(species, curator, "Biological Process", orf);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 4);
        orf = "YNR016C";
        ids = server.getClassifications(species, curator, "Molecular Function", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected0 = new int[]{3989, 4075};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected0));
        ids = server.getClassifications(species, curator, "Cellular Component", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected1 = new int[]{5829, 5789};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected1));
        ids = server.getClassifications(species, curator, "Biological Process", orf);
        BioDataServerTest.assertTrue(ids.length == 2);
        int[] expected2 = new int[]{6633, 6998};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected2));
        curator = "KEGG";
        ids = server.getClassifications(species, curator, "Metabolic Pathways", orf);
        BioDataServerTest.assertTrue(ids.length == 4);
        int[] expected3 = new int[]{61, 620, 640, 253};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected3));
        String canonicalName = "YAL001C";
        String commonName = "TFC3";
        String synonym2 = "TSV115";
        String synonym3 = "FUN24";
        BioDataServerTest.assertTrue(server.getCommonName(species, canonicalName).equals(commonName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, commonName).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, synonym2).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, synonym3).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, canonicalName).equals(canonicalName));
    }

    public void notestReadKeggHaloAnnotation() throws Exception {
        System.out.println("testReadKeggHaloAnnotation");
        String manifest = "annotations/keggHalo/manifest";
        BioDataServer server = new BioDataServer(manifest);
        AnnotationDescription[] aDescs = server.getAnnotationDescriptions();
        BioDataServerTest.assertTrue(aDescs.length == 1);
        String species = "Halobacterium sp.";
        String curator = "KEGG";
        String orf = "VNG1873G";
        String annotationType = "Metabolic Pathways";
        int[] ids = server.getClassifications(species, curator, annotationType, orf);
        BioDataServerTest.assertTrue(ids.length == 3);
        int[] expected = new int[]{20, 720, 480};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected));
    }

    public void testReadAnnotationsWithTwoOntologies() throws Exception {
        System.out.println("testReadAnnotationsWithTwoOntologies");
        String manifest = "annotations/humanKeggAndGO/manifest.both";
        BioDataServer server = new BioDataServer(manifest);
        String species = "Homo sapiens";
        String curator = "KEGG";
        String canonicalName = "NP_647593";
        String commonName = "qqq";
        String synonym2 = "QQQ";
        BioDataServerTest.assertTrue(server.getCommonName(species, canonicalName).equals(commonName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, commonName).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, synonym2).equals(canonicalName));
        BioDataServerTest.assertTrue(server.getCanonicalName(species, canonicalName).equals(canonicalName));
        String annotationType = "Metabolic Pathways";
        int[] ids = server.getClassifications(species, curator, annotationType, canonicalName);
        BioDataServerTest.assertTrue(ids.length == 6);
        int[] expected0 = new int[]{120, 350, 561, 260, 300, 40};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected0));
        AnnotationDescription[] aDescs = server.getAnnotationDescriptions();
        BioDataServerTest.assertTrue(aDescs.length == 4);
        curator = "GO";
        String annotationType1 = "Molecular Function";
        String annotationType2 = "Cellular Component";
        String annotationType3 = "Biological Process";
        ids = server.getClassifications(species, curator, annotationType1, canonicalName);
        BioDataServerTest.assertTrue(ids.length == 1);
        BioDataServerTest.assertTrue(ids[0] == 8181);
        ids = server.getClassifications(species, curator, annotationType2, canonicalName);
        if (!$assertionsDisabled && ids.length != 2) {
            throw new AssertionError();
        }
        int[] expected2 = new int[]{5871, 15629};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected2));
        ids = server.getClassifications(species, curator, annotationType3, canonicalName);
        BioDataServerTest.assertTrue(ids.length == 6);
        int[] expected3 = new int[]{6899, 7268, 8099, 8283, 30154, 45786};
        BioDataServerTest.assertTrue(this.containedIn(ids, expected3));
    }

    private boolean containedIn(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            boolean foundA = false;
            for (int j = 0; j < b.length; ++j) {
                if (b[j] != a[i]) continue;
                foundA = true;
                break;
            }
            if (foundA) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(BioDataServerTest.class));
        System.exit(0);
    }

    static {
        $assertionsDisabled = !BioDataServerTest.class.desiredAssertionStatus();
    }
}

