/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.synonyms.Thesaurus;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.HashMap;

public class BioDataServerRmi
extends UnicastRemoteObject
implements BioDataServerInterface,
Serializable {
    protected HashMap annotations = new HashMap();
    protected HashMap thesauri = new HashMap();
    protected Date startTime = new Date();
    protected Date lastAccessTime = new Date();

    public void addAnnotation(Annotation newAnnotation) {
        this.lastAccessTime = new Date();
        AnnotationDescription key = new AnnotationDescription(newAnnotation.getSpecies(), newAnnotation.getCurator(), newAnnotation.getType());
        if (this.annotations.containsKey(key)) {
            Annotation oldAnnotation = (Annotation)this.annotations.get(key);
            String[] newNames = newAnnotation.getNames();
            for (int i = 0; i < newNames.length; ++i) {
                int[] classificationIDs = newAnnotation.getClassifications(newNames[i]);
                for (int c = 0; c < classificationIDs.length; ++c) {
                    oldAnnotation.add(newNames[i], classificationIDs[c]);
                }
            }
        } else {
            this.annotations.put(key, newAnnotation);
        }
    }

    public void clear() {
        this.annotations = new HashMap();
        this.lastAccessTime = new Date();
    }

    public int getAnnotationCount() {
        this.lastAccessTime = new Date();
        return this.annotations.size();
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        this.lastAccessTime = new Date();
        AnnotationDescription[] result = this.annotations.keySet().toArray(new AnnotationDescription[0]);
        return result;
    }

    public Annotation getAnnotation(String species, String curator, String type) {
        this.lastAccessTime = new Date();
        AnnotationDescription description = new AnnotationDescription(species, curator, type);
        return this.getAnnotation(description);
    }

    public Annotation getAnnotation(AnnotationDescription description) {
        this.lastAccessTime = new Date();
        return (Annotation)this.annotations.get(description);
    }

    public int[] getClassifications(String species, String curator, String type, String entity) {
        this.lastAccessTime = new Date();
        AnnotationDescription description = new AnnotationDescription(species, curator, type);
        return this.getClassifications(description, entity);
    }

    public int[] getClassifications(AnnotationDescription description, String entity) {
        this.lastAccessTime = new Date();
        Annotation annotation = (Annotation)this.annotations.get(description);
        return annotation.getClassifications(entity);
    }

    public String[][] getAllAnnotations(AnnotationDescription description, String entity) {
        this.lastAccessTime = new Date();
        Annotation annotation = (Annotation)this.annotations.get(description);
        return annotation.getAllHierarchyPathsAsNames(entity);
    }

    public String describe() {
        StringBuffer sb = new StringBuffer();
        Annotation[] tmp = this.annotations.values().toArray(new Annotation[0]);
        for (int i = 0; i < tmp.length; ++i) {
            sb.append(tmp[i]);
            sb.append("\n");
        }
        Thesaurus[] tmp2 = this.thesauri.values().toArray(new Thesaurus[0]);
        for (int i = 0; i < tmp2.length; ++i) {
            sb.append(tmp2[i]);
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("    started: " + this.startTime);
        sb.append("\n");
        sb.append("last access: " + this.lastAccessTime);
        sb.append("\n");
        return sb.toString();
    }

    public void addThesaurus(String species, Thesaurus thesaurus) {
        this.thesauri.put(species, thesaurus);
    }

    public String getCanonicalName(String species, String commonName) {
        String result;
        Thesaurus t;
        if (this.thesauri.containsKey(species) && (t = (Thesaurus)this.thesauri.get(species)) != null && (result = t.getCanonicalName(commonName)) != null) {
            return result;
        }
        return commonName;
    }

    public String[] getAllCommonNames(String species, String commonName) {
        String[] result;
        Thesaurus t;
        if (this.thesauri.containsKey(species) && (t = (Thesaurus)this.thesauri.get(species)) != null && (result = t.getAllCommonNames(commonName)) != null) {
            return result;
        }
        String[] result2 = new String[]{commonName};
        return result2;
    }

    public String getCommonName(String species, String canonicalName) {
        String result;
        Thesaurus t;
        if (this.thesauri.containsKey(species) && (t = (Thesaurus)this.thesauri.get(species)) != null && (result = t.getCommonName(canonicalName)) != null) {
            return result;
        }
        return canonicalName;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage:  BioDataServerRmi <server name>");
            System.exit(1);
        }
        String name = args[0];
        try {
            BioDataServerRmi rmiServer = new BioDataServerRmi();
            Naming.rebind(name, rmiServer);
            System.out.println("BioDataServer bound as '" + name + "'");
        }
        catch (Exception e) {
            System.err.println("BioDataServer exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

