/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.AnnotationXmlReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.servers.BioDataServerRmi;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import java.io.File;
import java.net.URL;
import java.rmi.Naming;
import java.util.Vector;

public class BioDataServer {
    protected BioDataServerInterface server;

    public BioDataServer(String serverName) throws Exception {
        if (serverName.indexOf("rmi://") >= 0) {
            this.server = (BioDataServerInterface)Naming.lookup(serverName);
        } else {
            this.server = new BioDataServerRmi();
            File fileTester = new File(serverName);
            if (serverName.startsWith("jar://") || serverName.startsWith("http://") || !fileTester.isDirectory() && fileTester.canRead()) {
                String[] ontologyFiles = this.parseLoadFile(serverName, "ontology");
                String[] annotationFilenames = this.parseLoadFile(serverName, "annotation");
                this.loadAnnotationFiles(annotationFilenames, ontologyFiles);
                String[] thesaurusFilenames = this.parseLoadFile(serverName, "synonyms");
                this.loadThesaurusFiles(thesaurusFilenames);
            } else {
                System.err.println("could not read BioDataServer load file '" + serverName + "'");
            }
        }
    }

    protected String[] parseLoadFile(String filename, String key) {
        String rawText;
        File absoluteDirectory = null;
        String httpUrlPrefix = null;
        boolean readingFromFileSystem = false;
        boolean readingFromWeb = false;
        try {
            Object reader;
            if (filename.trim().startsWith("jar://")) {
                reader = new TextJarReader(filename);
                ((TextJarReader)reader).read();
                rawText = ((TextJarReader)reader).getText();
            } else if (filename.trim().startsWith("http://")) {
                reader = new TextHttpReader(filename);
                ((TextHttpReader)reader).read();
                rawText = ((TextHttpReader)reader).getText();
                readingFromWeb = true;
                try {
                    URL url = new URL(filename);
                    String fullUrlString = url.toString();
                    httpUrlPrefix = fullUrlString.substring(0, fullUrlString.lastIndexOf("/"));
                }
                catch (Exception e) {
                    httpUrlPrefix = "url parsing error!";
                }
            } else {
                File file = new File(filename);
                readingFromFileSystem = true;
                absoluteDirectory = file.getAbsoluteFile().getParentFile();
                TextFileReader reader2 = new TextFileReader(filename);
                reader2.read();
                rawText = reader2.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading annotation server load file " + filename);
            System.err.println(e0.getMessage());
            return new String[0];
        }
        String[] lines = rawText.split("\n");
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.trim().startsWith("#") || !line.startsWith(key)) continue;
            String fileToRead = line.substring(line.indexOf("=") + 1);
            if (readingFromFileSystem) {
                fileToRead = new File(absoluteDirectory, fileToRead).getPath();
            } else if (readingFromWeb) {
                fileToRead = httpUrlPrefix + "/" + fileToRead;
            }
            list.add(fileToRead);
        }
        return list.toArray(new String[0]);
    }

    public BioDataServer() throws Exception {
        this.server = new BioDataServerRmi();
    }

    public Ontology[] readOntologyFlatFiles(String[] ontologyFilenames) throws Exception {
        Vector<Ontology> list = new Vector<Ontology>();
        for (int i = 0; i < ontologyFilenames.length; ++i) {
            String filename = ontologyFilenames[i];
            if (filename.endsWith(".xml")) continue;
            OntologyFlatFileReader reader = new OntologyFlatFileReader(filename);
            list.add(reader.getOntology());
        }
        return list.toArray(new Ontology[0]);
    }

    protected Ontology pickOntology(Ontology[] ontologies, Annotation annotation) {
        for (int i = 0; i < ontologies.length; ++i) {
            if (!ontologies[i].getCurator().equalsIgnoreCase(annotation.getCurator())) continue;
            return ontologies[i];
        }
        return null;
    }

    public void loadAnnotationFiles(String[] annotationFilenames, String[] ontologyFilenames) throws Exception {
        Ontology[] ontologies = this.readOntologyFlatFiles(ontologyFilenames);
        for (int i = 0; i < annotationFilenames.length; ++i) {
            Annotation annotation;
            String filename = annotationFilenames[i];
            if (!filename.endsWith(".xml")) {
                AnnotationFlatFileReader reader = new AnnotationFlatFileReader(filename);
                annotation = reader.getAnnotation();
                annotation.setOntology(this.pickOntology(ontologies, annotation));
            } else {
                File xmlFile = new File(annotationFilenames[i]);
                AnnotationXmlReader reader = new AnnotationXmlReader(xmlFile);
                annotation = reader.getAnnotation();
            }
            this.server.addAnnotation(annotation);
        }
    }

    public void loadThesaurusFiles(String[] thesaurusFilenames) throws Exception {
        for (int i = 0; i < thesaurusFilenames.length; ++i) {
            String filename = thesaurusFilenames[i];
            ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(filename);
            Thesaurus thesaurus = reader.getThesaurus();
            this.server.addThesaurus(thesaurus.getSpecies(), thesaurus);
        }
    }

    public void clear() {
        try {
            this.server.clear();
        }
        catch (Exception e) {
            System.err.println("Error!  failed to clear");
            e.printStackTrace();
        }
    }

    public void addAnnotation(Annotation annotation) {
        try {
            this.server.addAnnotation(annotation);
        }
        catch (Exception e) {
            System.err.println("Error!  failed to add annotation " + annotation);
            e.printStackTrace();
        }
    }

    public int getAnnotationCount() {
        try {
            int count = this.server.getAnnotationCount();
            return count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        try {
            return this.server.getAnnotationDescriptions();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(String species, String curator, String type) {
        try {
            return this.server.getAnnotation(species, curator, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(AnnotationDescription description) {
        try {
            return this.server.getAnnotation(description);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(String species, String curator, String type, String entity) {
        try {
            return this.server.getClassifications(species, curator, type, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(AnnotationDescription description, String entity) {
        try {
            return this.server.getClassifications(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[][] getAllAnnotations(AnnotationDescription description, String entity) {
        try {
            return this.server.getAllAnnotations(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String describe() {
        try {
            return this.server.describe();
        }
        catch (Exception e) {
            return "error connecting to data server";
        }
    }

    public void addThesaurus(String species, Thesaurus thesaurus) {
        try {
            this.server.addThesaurus(species, thesaurus);
        }
        catch (Exception e) {
            return;
        }
    }

    public String getCanonicalName(String species, String commonName) {
        try {
            return this.server.getCanonicalName(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getAllCommonNames(String species, String commonName) {
        try {
            return this.server.getAllCommonNames(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCommonName(String species, String canonicalName) {
        try {
            return this.server.getCommonName(species, canonicalName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

