/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers.unitTests;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.unitTests.AllTests;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GMLReaderTest
extends TestCase {
    private static String testDataDir;

    public GMLReaderTest(String name) {
        super(name);
        if (AllTests.runAllTests()) {
            testDataDir = "testData";
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testSmallGraphRead() throws Exception {
        AllTests.standardOut("testSmallGraphRead");
        Cytoscape.clearCytoscape();
        CyNetwork network = Cytoscape.createNetwork(testDataDir + "/gal.gml");
        GMLReaderTest.assertTrue("node count", network.getNodeCount() == 11);
        GMLReaderTest.assertTrue("edge count", network.getEdgeCount() == 10);
    }

    public void testMediumGraphRead() throws Exception {
        AllTests.standardOut("testMediumGraphRead");
        Cytoscape.clearCytoscape();
        CyNetwork network = Cytoscape.createNetwork(testDataDir + "/noLabels.gml");
        GMLReaderTest.assertTrue("node count", network.getNodeCount() == 332);
        GMLReaderTest.assertTrue("edge count", network.getEdgeCount() == 361);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Error!  must supply path to test data directory on command line");
            System.exit(0);
        }
        testDataDir = args[0];
        TestRunner.run(new TestSuite(GMLReaderTest.class));
    }
}

