/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.Interaction;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServer;
import giny.model.RootGraph;
import giny.view.GraphView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class InteractionsReader
implements GraphReader {
    protected String filename;
    protected Vector allInteractions = new Vector();
    BioDataServer dataServer;
    String species;
    String zip_entry;
    boolean is_zip = false;
    IntArrayList node_indices;
    OpenIntIntHashMap edges;

    public InteractionsReader(BioDataServer dataServer, String species, String filename) {
        this.filename = filename;
        this.dataServer = dataServer;
        this.species = species;
    }

    public InteractionsReader(BioDataServer dataServer, String species, String zip_entry, boolean is_zip) {
        this.zip_entry = zip_entry;
        this.dataServer = dataServer;
        this.species = species;
        this.is_zip = is_zip;
    }

    public void layout(GraphView view) {
    }

    public void read(boolean canonicalize) {
        String rawText;
        if (!this.is_zip) {
            try {
                Object reader;
                if (this.filename.trim().startsWith("jar://")) {
                    reader = new TextJarReader(this.filename);
                    ((TextJarReader)reader).read();
                    rawText = ((TextJarReader)reader).getText();
                }
                reader = new TextFileReader(this.filename);
                ((TextFileReader)reader).read();
                rawText = ((TextFileReader)reader).getText();
            }
            catch (Exception e0) {
                System.err.println("-- Exception while reading interaction file " + this.filename);
                System.err.println(e0.getMessage());
                return;
            }
        } else {
            rawText = this.zip_entry;
        }
        String delimiter = " ";
        if (rawText.indexOf("\t") >= 0) {
            delimiter = "\t";
        }
        StringTokenizer strtok = new StringTokenizer(rawText, "\n");
        while (strtok.hasMoreElements()) {
            String newLine = (String)strtok.nextElement();
            Interaction newInteraction = new Interaction(newLine, delimiter);
            this.allInteractions.addElement(newInteraction);
        }
        this.createRootGraphFromInteractionData(canonicalize);
    }

    public void read() {
        this.read(true);
    }

    public int getCount() {
        return this.allInteractions.size();
    }

    public Interaction[] getAllInteractions() {
        Interaction[] result = new Interaction[this.allInteractions.size()];
        for (int i = 0; i < this.allInteractions.size(); ++i) {
            Interaction inter;
            result[i] = inter = (Interaction)this.allInteractions.elementAt(i);
        }
        return result;
    }

    protected String canonicalizeName(String name) {
        String canonicalName = name;
        if (this.dataServer != null && (canonicalName = this.dataServer.getCanonicalName(this.species, name)) == null) {
            canonicalName = name;
        }
        return canonicalName;
    }

    protected void createRootGraphFromInteractionData(boolean canonicalize) {
        Interaction[] interactions = this.getAllInteractions();
        HashSet<String> nodeNameSet = new HashSet<String>();
        int edgeCount = 0;
        for (int i = 0; i < interactions.length; ++i) {
            Interaction interaction = interactions[i];
            String sourceName = interaction.getSource();
            if (canonicalize) {
                sourceName = this.canonicalizeName(sourceName);
            }
            nodeNameSet.add(sourceName);
            String[] targets = interaction.getTargets();
            for (int t = 0; t < targets.length; ++t) {
                String targetNodeName = targets[t];
                if (canonicalize) {
                    targetNodeName = this.canonicalizeName(targetNodeName);
                }
                nodeNameSet.add(targetNodeName);
                ++edgeCount;
            }
        }
        Cytoscape.ensureCapacity(nodeNameSet.size(), edgeCount);
        this.node_indices = new IntArrayList(nodeNameSet.size());
        this.edges = new OpenIntIntHashMap(edgeCount);
        Iterator si = nodeNameSet.iterator();
        while (si.hasNext()) {
            String nodeName = (String)si.next();
            CyNode node = Cytoscape.getCyNode(nodeName, true);
            this.node_indices.add(node.getRootGraphIndex());
        }
        for (int i = 0; i < interactions.length; ++i) {
            Interaction interaction = interactions[i];
            String nodeName = interaction.getSource();
            if (canonicalize) {
                nodeName = this.canonicalizeName(interaction.getSource());
            }
            String interactionType = interaction.getType();
            String[] targets = interaction.getTargets();
            for (int t = 0; t < targets.length; ++t) {
                String targetNodeName = canonicalize ? this.canonicalizeName(targets[t]) : targets[t];
                String edgeName = nodeName + " (" + interactionType + ") " + targetNodeName;
                CyEdge edge = Cytoscape.getCyEdge(nodeName, edgeName, targetNodeName, interactionType);
                this.edges.put(edge.getRootGraphIndex(), 0);
            }
        }
    }

    public RootGraph getRootGraph() {
        return Cytoscape.getRootGraph();
    }

    public GraphObjAttributes getNodeAttributes() {
        return Cytoscape.getNodeNetworkData();
    }

    public GraphObjAttributes getEdgeAttributes() {
        return Cytoscape.getEdgeNetworkData();
    }

    public int[] getNodeIndicesArray() {
        this.node_indices.trimToSize();
        return this.node_indices.elements();
    }

    public int[] getEdgeIndicesArray() {
        IntArrayList edge_indices = new IntArrayList(this.edges.size());
        this.edges.keys(edge_indices);
        edge_indices.trimToSize();
        return edge_indices.elements();
    }
}

