/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.readers.GMLTree;
import cytoscape.data.readers.GraphReader;
import giny.model.Edge;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GMLReader
implements GraphReader {
    private String filename;
    GMLTree gmlTree;
    IntArrayList nodes;
    IntArrayList edges;
    OpenIntIntHashMap edgeMap;

    public GMLReader(String filename) {
        this.filename = filename;
        this.gmlTree = new GMLTree(filename);
    }

    public GMLReader(String zip_entry, boolean is_zip) {
        this.gmlTree = new GMLTree(zip_entry, is_zip);
    }

    public void read(boolean canonicalize) {
        this.read();
    }

    public void read() {
        Vector nodeIds = this.gmlTree.getVector(new String[]{"graph", "node", "id"}, GMLTree.INTEGER);
        Vector nodeLabels = this.gmlTree.getVector(new String[]{"graph", "node", "label"}, GMLTree.STRING);
        Hashtable nodeNameMap = new Hashtable(nodeIds.size());
        for (int i = 0; i < nodeIds.size(); ++i) {
            nodeNameMap.put(nodeIds.get(i), nodeLabels.get(i));
        }
        Vector edgeSources = this.gmlTree.getVector(new String[]{"graph", "edge", "source"}, GMLTree.INTEGER);
        Vector edgeTargets = this.gmlTree.getVector(new String[]{"graph", "edge", "target"}, GMLTree.INTEGER);
        Vector edgeLabels = this.gmlTree.getVector(new String[]{"graph", "edge", "label"}, GMLTree.STRING);
        Cytoscape.ensureCapacity(nodeIds.size(), edgeSources.size());
        this.nodes = new IntArrayList(nodeIds.size());
        this.edgeMap = new OpenIntIntHashMap(edgeSources.size());
        String et = "pp";
        if (edgeLabels.isEmpty()) {
            for (int i = 0; i < edgeSources.size(); ++i) {
                edgeLabels.add(et);
            }
        }
        Hashtable<Integer, Integer> gmlId2GINYId = new Hashtable<Integer, Integer>();
        Iterator idIt = nodeIds.iterator();
        for (int i = 0; i < nodeIds.size(); ++i) {
            Integer gmlId = (Integer)idIt.next();
            String nodeName = (String)nodeNameMap.get(gmlId);
            CyNode node = Cytoscape.getCyNode(nodeName, true);
            this.nodes.add(node.getRootGraphIndex());
            gmlId2GINYId.put(gmlId, new Integer(node.getRootGraphIndex()));
        }
        Iterator sourceIt = edgeSources.iterator();
        Iterator labelIt = edgeLabels.iterator();
        Iterator targetIt = edgeTargets.iterator();
        this.edges = new IntArrayList(edgeSources.size());
        for (int i = 0; i < edgeSources.size(); ++i) {
            String interactionType = (String)labelIt.next();
            String sourceName = (String)nodeNameMap.get(sourceIt.next());
            String targetName = (String)nodeNameMap.get(targetIt.next());
            String edgeName = "" + sourceName + " (" + interactionType + ") " + targetName;
            CyEdge edge = Cytoscape.getCyEdge(sourceName, edgeName, targetName, interactionType);
            this.edges.add(edge.getRootGraphIndex());
            this.edgeMap.put(edge.getRootGraphIndex(), 0);
        }
    }

    public RootGraph getRootGraph() {
        return Cytoscape.getRootGraph();
    }

    public GraphObjAttributes getNodeAttributes() {
        return Cytoscape.getNodeNetworkData();
    }

    public GraphObjAttributes getEdgeAttributes() {
        return Cytoscape.getEdgeNetworkData();
    }

    public void layout(GraphView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        if (this.gmlTree == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        Vector nodeLabels = this.gmlTree.getVector(new String[]{"graph", "node", "label"}, GMLTree.STRING);
        Vector nodeX = this.gmlTree.getVector(new String[]{"graph", "node", "graphics", "x"}, GMLTree.DOUBLE);
        Vector nodeY = this.gmlTree.getVector(new String[]{"graph", "node", "graphics", "y"}, GMLTree.DOUBLE);
        Vector nodeHeight = this.gmlTree.getVector(new String[]{"graph", "node", "graphics", "h"}, GMLTree.DOUBLE);
        Vector nodeWidth = this.gmlTree.getVector(new String[]{"graph", "node", "graphics", "w"}, GMLTree.DOUBLE);
        Vector nodeType = this.gmlTree.getVector(new String[]{"graph", "node", "graphics", "type"}, GMLTree.STRING);
        String ELLIPSE = "ellipse";
        String RECTANGLE = "rectangle";
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node current = Cytoscape.getRootGraph().getNode(this.nodes.get(i));
            String nodeName = (String)nodeLabels.get(i);
            Number X = (Number)nodeX.get(i);
            Number Y = (Number)nodeY.get(i);
            NodeView currentView = myView.getNodeView(current);
            currentView.setXPosition(X.doubleValue());
            currentView.setYPosition(Y.doubleValue());
            if (nodeHeight.size() == nodeLabels.size()) {
                currentView.setHeight((Double)nodeHeight.get(i));
            }
            if (nodeWidth.size() == nodeLabels.size()) {
                currentView.setWidth((Double)nodeWidth.get(i));
            }
            if (nodeType.size() != nodeLabels.size()) continue;
            String nType = (String)nodeType.get(i);
            if (nType.equals(ELLIPSE)) {
                currentView.setShape(2);
                continue;
            }
            if (!nType.equals(RECTANGLE)) continue;
            currentView.setShape(6);
        }
        Vector edgeGML = this.gmlTree.getVector(new String[]{"graph", "edge"}, GMLTree.GMLTREE);
        String[] xKeys = new String[]{"point", "x"};
        String[] yKeys = new String[]{"point", "y"};
        String[] lineKeys = new String[]{"graphics", "Line"};
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge current = Cytoscape.getRootGraph().getEdge(this.edges.get(i));
            GMLTree tmpGML = (GMLTree)edgeGML.get(i);
            Vector tmpLine = tmpGML.getVector(lineKeys, GMLTree.GMLTREE);
            if (tmpLine.size() != 1) continue;
            GMLTree Line = (GMLTree)tmpLine.get(0);
            EdgeView currentView = myView.getEdgeView(current);
            currentView.getBend().removeAllHandles();
            Vector tmpXs = Line.getVector(xKeys, GMLTree.DOUBLE);
            Vector tmpYs = Line.getVector(yKeys, GMLTree.DOUBLE);
            for (int j = tmpXs.size() - 2; j > 0; --j) {
                Point2D.Double pt = new Point2D.Double((Double)tmpXs.get(j), (Double)tmpYs.get(j));
                currentView.getBend().addHandle(pt);
            }
        }
    }

    public int[] getNodeIndicesArray() {
        this.nodes.trimToSize();
        return this.nodes.elements();
    }

    public int[] getEdgeIndicesArray() {
        IntArrayList edge_indices = new IntArrayList(this.edgeMap.size());
        this.edgeMap.keys(edge_indices);
        edge_indices.trimToSize();
        return edge_indices.elements();
    }
}

