/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class GMLNode
implements Comparator {
    public boolean terminal;
    private boolean quotes = false;
    private String string_value;
    private static String TAB = "\t";
    private HashMap key2GMLNodeVec;
    private HashMap key2Order;
    private int order;

    public GMLNode(String string_value) {
        if (string_value.startsWith("\"") && string_value.endsWith("\"")) {
            this.quotes = true;
            string_value = string_value.substring(1, string_value.length() - 1);
        }
        this.string_value = string_value;
        this.terminal = true;
    }

    public GMLNode() {
        this.terminal = false;
        this.order = 1;
        this.key2Order = new HashMap();
        this.key2GMLNodeVec = new HashMap();
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        String lineSep = System.getProperty("line.separator");
        String result = "";
        if (this.terminal) {
            if (!this.quotes) {
                return TAB + this.string_value;
            }
            return TAB + "\"" + this.string_value + "\"";
        }
        result = result + lineSep + indent + "[" + lineSep;
        Vector sortedKeys = new Vector(this.key2GMLNodeVec.keySet());
        Collections.sort(sortedKeys, this);
        Iterator it = sortedKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Iterator mapIt = ((Vector)this.key2GMLNodeVec.get(key)).iterator();
            while (mapIt.hasNext()) {
                GMLNode next = (GMLNode)mapIt.next();
                result = result + indent + key + next.toString(indent + TAB) + lineSep;
            }
        }
        result = result + indent + "]";
        return result;
    }

    public int compare(Object o1, Object o2) {
        Integer int1 = (Integer)this.key2Order.get(o1);
        Integer int2 = (Integer)this.key2Order.get(o2);
        if (int1 == null || int2 == null) {
            throw new RuntimeException("Forgot to add an order mapping for one of the keys");
        }
        return int1.compareTo(int2);
    }

    public Double doubleValue() {
        return new Double(this.string_value);
    }

    public Integer integerValue() {
        return new Integer(this.string_value);
    }

    public String stringValue() {
        return this.string_value;
    }

    public void addMapping(String key, GMLNode node) {
        Vector<GMLNode> values = (Vector<GMLNode>)this.key2GMLNodeVec.get(key);
        if (values == null) {
            values = new Vector<GMLNode>();
            this.key2GMLNodeVec.put(key, values);
            this.key2Order.put(key, new Integer(this.order++));
        }
        values.add(node);
    }

    public Vector getMapping(String key) {
        return (Vector)this.key2GMLNodeVec.get(key);
    }
}

