/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyDescription;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.annotation.unitTests.Utils;
import cytoscape.unitTests.AllTests;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OntologyTest
extends TestCase {
    public OntologyTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String expectedCurator = "KEGG";
        String expectedOntologyType = "Metabolic Pathways";
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        OntologyTest.assertTrue(ontology.getCurator().equals(expectedCurator));
        OntologyTest.assertTrue(ontology.getType().equals(expectedOntologyType));
        OntologyDescription description = ontology.getDescription();
        OntologyTest.assertTrue(description.getCurator().equals(expectedCurator));
        OntologyTest.assertTrue(description.getType().equals(expectedOntologyType));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        String curator = "KEGG";
        String ontologyType = "Metabolic Pathways";
        Ontology ontology = new Ontology(curator, ontologyType);
        OntologyTerm metabolism = new OntologyTerm("Metabolism", 90001);
        OntologyTerm carbohydrateMetabolism = new OntologyTerm("Carbohydrate Metabolism", 80001);
        carbohydrateMetabolism.addParent(metabolism.getId());
        ontology.add(metabolism);
        ontology.add(carbohydrateMetabolism);
        OntologyTest.assertTrue(ontology.size() == 2);
        OntologyTest.assertTrue(ontology.containsTerm(metabolism.getId()));
        OntologyTest.assertTrue(ontology.containsTerm(carbohydrateMetabolism.getId()));
        OntologyTerm retrievedTerm0 = ontology.getTerm(metabolism.getId());
        OntologyTerm retrievedTerm1 = ontology.getTerm(carbohydrateMetabolism.getId());
        OntologyTest.assertTrue(retrievedTerm0.getName().equals("Metabolism"));
        OntologyTest.assertTrue(retrievedTerm1.getName().equals("Carbohydrate Metabolism"));
        OntologyTest.assertTrue(ontology.getTerms().size() == 2);
    }

    public void testGetHierarchyInts() throws Exception {
        AllTests.standardOut("testGetHierarchyInts");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        int[][] h = ontology.getAllHierarchyPaths(80001);
        OntologyTest.assertTrue(h.length == 1);
        OntologyTest.assertTrue(h[0].length == 2);
        OntologyTest.assertTrue(h[0][0] == 90001);
        OntologyTest.assertTrue(h[0][1] == 80001);
        h = ontology.getAllHierarchyPaths(40);
        OntologyTest.assertTrue(h.length == 1);
        OntologyTest.assertTrue(h[0].length == 3);
        OntologyTest.assertTrue(h[0][0] == 90001);
        OntologyTest.assertTrue(h[0][1] == 80001);
        OntologyTest.assertTrue(h[0][2] == 40);
        h = ontology.getAllHierarchyPaths(666);
        OntologyTest.assertTrue(h.length == 2);
        OntologyTest.assertTrue(h[0].length == 4);
        OntologyTest.assertTrue(h[0][0] == 90001);
        OntologyTest.assertTrue(h[0][1] == 80007);
        OntologyTest.assertTrue(h[0][2] == 500);
        OntologyTest.assertTrue(h[0][3] == 666);
        OntologyTest.assertTrue(h[1].length == 4);
        OntologyTest.assertTrue(h[1][0] == 90001);
        OntologyTest.assertTrue(h[1][1] == 80007);
        OntologyTest.assertTrue(h[1][2] == 530);
        OntologyTest.assertTrue(h[1][3] == 666);
    }

    public void testGetHierarchyNames() throws Exception {
        AllTests.standardOut("testGetHierarchyNames");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        String[][] h = ontology.getAllHierarchyPathsAsNames(80001);
        this.printHierarchy(h);
        OntologyTest.assertTrue(h.length == 1);
        OntologyTest.assertTrue(h[0].length == 2);
        OntologyTest.assertTrue(h[0][0].equals("Metabolism"));
        OntologyTest.assertTrue(h[0][1].equals("Carbohydrate Metabolism"));
        h = ontology.getAllHierarchyPathsAsNames(40);
        OntologyTest.assertTrue(h.length == 1);
        OntologyTest.assertTrue(h[0].length == 3);
        OntologyTest.assertTrue(h[0][0].equals("Metabolism"));
        OntologyTest.assertTrue(h[0][1].equals("Carbohydrate Metabolism"));
        OntologyTest.assertTrue(h[0][2].equals("Nucleotide Metabolism"));
        h = ontology.getAllHierarchyPathsAsNames(666);
        this.printHierarchy(h);
        OntologyTest.assertTrue(h.length == 2);
        OntologyTest.assertTrue(h[0].length == 4);
        OntologyTest.assertTrue(h[0][0].equals("Metabolism"));
        OntologyTest.assertTrue(h[0][1].equals("Glutamate metabolism"));
        OntologyTest.assertTrue(h[0][2].equals("Biosynthesis of Secondary Metabolites"));
        OntologyTest.assertTrue(h[0][3].equals("Two Parents"));
        OntologyTest.assertTrue(h[1].length == 4);
        OntologyTest.assertTrue(h[1][0].equals("Metabolism"));
        OntologyTest.assertTrue(h[1][1].equals("Glutamate metabolism"));
        OntologyTest.assertTrue(h[1][2].equals("Starch and sucrose metabolism"));
        OntologyTest.assertTrue(h[1][3].equals("Two Parents"));
    }

    private void printHierarchy(int[][] hierarchy) {
        for (int i = 0; i < hierarchy.length; ++i) {
            int[] path = hierarchy[i];
            for (int j = 0; j < path.length; ++j) {
                AllTests.standardOut(path[j] + " ");
            }
            AllTests.standardOut("\n");
        }
    }

    private void printHierarchy(String[][] hierarchy) {
        for (int i = 0; i < hierarchy.length; ++i) {
            String[] path = hierarchy[i];
            for (int j = 0; j < path.length; ++j) {
                AllTests.standardOut(path[j]);
                if (j >= path.length - 1) continue;
                AllTests.standardOut(", ");
            }
            AllTests.standardOut("\n");
        }
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(OntologyTest.class));
    }
}

