/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.unitTests.Utils;
import cytoscape.unitTests.AllTests;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AnnotationTest
extends TestCase {
    public AnnotationTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        String species = "Saccharomyces cerevisiae";
        String type = "pathways";
        Annotation annotation = new Annotation(species, type, ontology);
        AnnotationTest.assertTrue(annotation.size() == 0);
        AnnotationTest.assertTrue(annotation.count() == 0);
        AnnotationTest.assertTrue(annotation.getCurator().equals(ontology.getCurator()));
        AnnotationTest.assertTrue(annotation.getType().equals(type));
        AnnotationTest.assertTrue(annotation.getOntologyType().equals(ontology.getType()));
        AnnotationTest.assertTrue(annotation.getSpecies().equals(species));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        AnnotationTest.assertTrue(annotation.size() == 0);
        annotation.add("VNG0006G", 251);
        annotation.add("VNG0006G", 530);
        annotation.add("VNG0008G", 520);
        annotation.add("VNG0008G", 522);
        annotation.add("VNG0009G", 520);
        annotation.add("VNG0009G", 522);
        annotation.add("VNG0046G", 40);
        annotation.add("VNG0046G", 500);
        annotation.add("VNG0046G", 520);
        AnnotationTest.assertTrue(annotation.size() == 9);
        AnnotationTest.assertTrue(annotation.count() == 4);
    }

    public void testGet() throws Exception {
        AllTests.standardOut("testGet");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        annotation.add("VNG0006G", 251);
        annotation.add("VNG0006G", 530);
        annotation.add("VNG0008G", 520);
        annotation.add("VNG0008G", 522);
        annotation.add("VNG0009G", 520);
        annotation.add("VNG0046G", 40);
        annotation.add("VNG0046G", 500);
        annotation.add("VNG0046G", 520);
        String[] names = annotation.getNames();
        AnnotationTest.assertTrue(names.length == 4);
        int[] classifications = annotation.getClassifications("VNG0006G");
        AnnotationTest.assertTrue(classifications.length == 2);
        AnnotationTest.assertTrue(classifications[0] == 251);
        AnnotationTest.assertTrue(classifications[1] == 530);
        classifications = annotation.getClassifications("VNG0008G");
        AnnotationTest.assertTrue(classifications.length == 2);
        AnnotationTest.assertTrue(classifications[0] == 520);
        AnnotationTest.assertTrue(classifications[1] == 522);
        classifications = annotation.getClassifications("VNG0009G");
        AnnotationTest.assertTrue(classifications.length == 1);
        AnnotationTest.assertTrue(classifications[0] == 520);
        classifications = annotation.getClassifications("VNG0046G");
        AnnotationTest.assertTrue(classifications.length == 3);
        AnnotationTest.assertTrue(classifications[0] == 40);
        AnnotationTest.assertTrue(classifications[1] == 500);
        AnnotationTest.assertTrue(classifications[2] == 520);
    }

    public void testMaxDepth() throws Exception {
        AllTests.standardOut("testMaxDepth");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        annotation.add("VNG0009G", 520);
        AnnotationTest.assertTrue(annotation.maxDepth() == 3);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(AnnotationTest.class));
    }
}

