/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;

public class OntologyFlatFileReader {
    Ontology ontology;
    String curator = "unknown";
    String ontologyType = "unknown";
    String filename;
    String fullText;
    String[] lines;

    public OntologyFlatFileReader(File file) throws Exception {
        this(file.getPath());
    }

    public OntologyFlatFileReader(String filename) throws Exception {
        this.filename = filename;
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading ontology flat file " + filename);
            System.err.println(e0.getMessage());
            return;
        }
        this.lines = this.fullText.split("\n");
        this.parseHeader();
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void parseHeader() throws Exception {
        String firstLine = this.lines[0].trim();
        String[] tokens = firstLine.split("\\)");
        String errorMsg = "error in OntologyFlatFileReader.parseHeader ().\n";
        errorMsg = errorMsg + "First line of " + this.filename + " must have form:\n";
        errorMsg = errorMsg + "   (curator=GO) (type=all) \n";
        errorMsg = errorMsg + "instead found:\n";
        errorMsg = errorMsg + "   " + firstLine + "\n";
        if (tokens.length != 2) {
            throw new IllegalArgumentException(errorMsg);
        }
        String[] curatorRaw = tokens[0].split("=");
        if (curatorRaw.length != 2) {
            throw new IllegalArgumentException(errorMsg);
        }
        this.curator = curatorRaw[1].trim();
        String[] typeRaw = tokens[1].split("=");
        if (typeRaw.length != 2) {
            throw new IllegalArgumentException(errorMsg);
        }
        this.ontologyType = typeRaw[1].trim();
    }

    private void parse() throws Exception {
        this.ontology = new Ontology(this.curator, this.ontologyType);
        for (int i = 1; i < this.lines.length; ++i) {
            int partofStart;
            String line = this.lines[i];
            int equals = line.indexOf("=");
            String idString = line.substring(0, equals).trim();
            int id = this.stringToInt(idString);
            String value = line.substring(equals + 1);
            int firstLeftBracket = value.indexOf("[");
            if (firstLeftBracket < 0) continue;
            String name = value.substring(0, firstLeftBracket).trim();
            OntologyTerm term = new OntologyTerm(name, id);
            int isaStart = value.indexOf("[isa: ");
            if (isaStart >= 0) {
                int isaEnd = value.indexOf("]", isaStart);
                String rawIsa = value.substring(isaStart + 6, isaEnd).trim();
                String[] allIsas = rawIsa.split(" ");
                for (int j = 0; j < allIsas.length; ++j) {
                    term.addParent(this.stringToInt(allIsas[j]));
                }
            }
            if ((partofStart = value.indexOf("[partof: ")) >= 0) {
                int partofEnd = value.indexOf("]", partofStart);
                String rawPartof = value.substring(partofStart + 9, partofEnd).trim();
                String[] allPartofs = rawPartof.split(" ");
                for (int j = 0; j < allPartofs.length; ++j) {
                    term.addContainer(this.stringToInt(allPartofs[j]));
                }
            }
            this.ontology.add(term);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }
}

