/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.FlattenIntVectors;
import cytoscape.data.annotation.OntologyDescription;
import cytoscape.data.annotation.OntologyTerm;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Ontology
implements Serializable {
    protected String curator;
    protected String ontologyType;
    protected HashMap termHash;

    public Ontology(String curator, String ontologyType) {
        this.curator = curator;
        this.ontologyType = ontologyType;
        this.termHash = new HashMap();
    }

    public String getCurator() {
        return this.curator;
    }

    public String getType() {
        return this.ontologyType;
    }

    public void add(OntologyTerm newTerm) {
        this.termHash.put(new Integer(newTerm.getId()), newTerm);
    }

    public int size() {
        return this.termHash.size();
    }

    public HashMap getTerms() {
        return this.termHash;
    }

    public boolean containsTerm(int id) {
        return this.termHash.containsKey(new Integer(id));
    }

    public OntologyTerm getTerm(int id) {
        return (OntologyTerm)this.termHash.get(new Integer(id));
    }

    public int[][] getAllHierarchyPaths(int termID) {
        Vector flattenedList = this.getAllHierarchyPathsAsVector(termID);
        int size = flattenedList.size();
        int[][] result = new int[size][];
        for (int i = 0; i < size; ++i) {
            Vector integerList = (Vector)flattenedList.get(i);
            int max = integerList.size();
            result[i] = new int[max];
            for (int j = 0; j < max; ++j) {
                int indexForReversingOrder = max - j - 1;
                result[i][j] = (Integer)integerList.get(indexForReversingOrder);
            }
        }
        return result;
    }

    public String[][] getAllHierarchyPathsAsNames(int termID) {
        int[][] hierarchy = this.getAllHierarchyPaths(termID);
        String[][] result = new String[hierarchy.length][];
        for (int i = 0; i < hierarchy.length; ++i) {
            int[] path = hierarchy[i];
            int max = path.length;
            result[i] = new String[max];
            for (int j = 0; j < path.length; ++j) {
                result[i][j] = this.getTerm(path[j]).getName();
            }
        }
        return result;
    }

    protected Vector getAllHierarchyPathsAsVector(int termID) {
        Vector nestedLists = this.recursiveGetPath(termID, new Vector());
        if (nestedLists.size() == 0) {
            return nestedLists;
        }
        FlattenIntVectors flattener = new FlattenIntVectors(nestedLists);
        Vector flattenedList = flattener.getResult();
        return flattenedList;
    }

    protected Vector recursiveGetPath(int termID, Vector path) {
        Integer ID2 = new Integer(termID);
        if (this.termHash != null && this.termHash.containsKey(ID2)) {
            OntologyTerm term = (OntologyTerm)this.termHash.get(ID2);
            int parentCount = term.numberOfParentsAndContainers();
            path.addElement(ID2);
            if (parentCount == 0) {
                return path;
            }
            if (parentCount == 1) {
                int parentID = term.getParentsAndContainers()[0];
                return this.recursiveGetPath(parentID, path);
            }
            Vector<Vector> newPath = new Vector<Vector>();
            for (int p = 0; p < parentCount; ++p) {
                Vector subPath = (Vector)path.clone();
                int parent = term.getParentsAndContainers()[p];
                newPath.addElement(this.recursiveGetPath(parent, subPath));
            }
            return newPath;
        }
        return path;
    }

    protected Vector oldRecursiveGetPath(int termID, Vector path) {
        Integer ID2 = new Integer(termID);
        if (this.termHash != null && this.termHash.containsKey(ID2)) {
            OntologyTerm term = (OntologyTerm)this.termHash.get(ID2);
            int parentCount = term.numberOfParentsAndContainers();
            if (parentCount == 0) {
                path.addElement(ID2);
                return path;
            }
            if (parentCount == 1) {
                path.addElement(ID2);
                int parentID = term.getParentsAndContainers()[0];
                return this.recursiveGetPath(parentID, path);
            }
            path.addElement(ID2);
            Vector<Vector> newPath = new Vector<Vector>();
            Vector path1 = (Vector)path.clone();
            Vector path2 = (Vector)path.clone();
            int parent1 = term.getParentsAndContainers()[0];
            int parent2 = term.getParentsAndContainers()[1];
            newPath.addElement(this.recursiveGetPath(parent1, path1));
            newPath.addElement(this.recursiveGetPath(parent2, path2));
            return newPath;
        }
        return path;
    }

    public OntologyDescription getDescription() {
        return new OntologyDescription(this.curator, this.ontologyType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ontology: " + this.ontologyType + "\n");
        sb.append("curator:  " + this.curator + "\n");
        return sb.toString();
    }
}

