/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeObj;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.servers.BioDataServer;
import giny.model.Edge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Semantics {
    public static final String IDENTIFIER = "identifier";
    public static final String CANONICAL_NAME = "canonicalName";
    public static final String COMMON_NAME = "commonName";
    public static final String SPECIES = "species";
    public static final String INTERACTION = "interaction";
    public static final String MOLECULE_TYPE = "molecule_type";
    public static final String PROTEIN = "protein";
    public static final String DNA = "DNA";
    public static final String RNA = "RNA";

    public static void applyNamingServices(CyNetwork network, CytoscapeObj cytoscapeObj) {
        Semantics.assignCommonNames(network, cytoscapeObj.getBioDataServer());
    }

    public static void assignSpecies(CyNetwork network, CytoscapeObj cytoscapeObj) {
        if (network == null || cytoscapeObj == null) {
            return;
        }
        String defaultSpecies = Semantics.getDefaultSpecies(network, cytoscapeObj);
        if (defaultSpecies == null) {
            return;
        }
        String callerID = "Semantics.assignSpecies";
        GraphObjAttributes nodeAttributes = Cytoscape.getNodeNetworkData();
        String[] canonicalNames = nodeAttributes.getObjectNames(CANONICAL_NAME);
        for (int i = 0; i < canonicalNames.length; ++i) {
            String canonicalName = canonicalNames[i];
            String species = nodeAttributes.getStringValue(SPECIES, canonicalName);
            if (species != null) continue;
            nodeAttributes.set(SPECIES, canonicalName, defaultSpecies);
        }
    }

    public static String getDefaultSpecies(CyNetwork network, CytoscapeObj cytoscapeObj) {
        String defaultSpecies = cytoscapeObj.getConfiguration().getDefaultSpeciesName();
        if (defaultSpecies == null) {
            defaultSpecies = cytoscapeObj.getConfiguration().getProperties().getProperty(SPECIES);
        }
        return defaultSpecies;
    }

    public static Set getSpeciesInNetwork(CyNetwork network) {
        HashSet returnSet = new HashSet();
        if (network == null) {
            return returnSet;
        }
        GraphObjAttributes nodeAttributes = Cytoscape.getNodeNetworkData();
        if (nodeAttributes == null) {
            return returnSet;
        }
        HashMap speciesAttribute = nodeAttributes.getAttribute(SPECIES);
        if (speciesAttribute == null) {
            return returnSet;
        }
        returnSet.addAll(speciesAttribute.values());
        return returnSet;
    }

    public static void assignNodeAliases(CyNode node, String species, BioDataServer bds) {
        String cname;
        if (node == null) {
            return;
        }
        if (species == null) {
            species = Cytoscape.getNodeAttributeValue(node, SPECIES) != null ? (String)Cytoscape.getNodeAttributeValue(node, SPECIES) : Cytoscape.getCytoscapeObj().getConfiguration().getDefaultSpeciesName();
        }
        Cytoscape.setNodeAttributeValue(node, SPECIES, species);
        if (bds == null) {
            bds = Cytoscape.getCytoscapeObj().getBioDataServer();
        }
        if (bds == null) {
            return;
        }
        String name = node.getIdentifier().toUpperCase();
        if (name != (cname = bds.getCanonicalName(species, name))) {
            node.setIdentifier(cname);
        }
        Cytoscape.setNodeAttributeValue(node, CANONICAL_NAME, cname);
        String[] synonyms = bds.getAllCommonNames(species, cname);
        StringBuffer concat = new StringBuffer();
        String common_name = null;
        for (int j = 0; j < synonyms.length; ++j) {
            concat.append(synonyms[j] + " ");
            if (common_name != null) continue;
            common_name = synonyms[j];
        }
        if (common_name == null) {
            common_name = cname;
        }
        Cytoscape.setNodeAttributeValue(node, "ALIASES", concat.toString());
        Cytoscape.setNodeAttributeValue(node, COMMON_NAME, common_name);
    }

    public static void assignCommonNames(CyNetwork network, BioDataServer bioDataServer) {
        if (network == null || bioDataServer == null) {
            return;
        }
        List nodes = network.nodesList();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            CyNode node = (CyNode)i.next();
            Semantics.assignNodeAliases(node, null, bioDataServer);
        }
    }

    public static boolean getCanonicalize(CytoscapeObj cytoscapeObj) {
        return cytoscapeObj.getConfiguration().getCanonicalize();
    }

    public static String[] getInteractionTypes(CyNetwork network) {
        if (network == null) {
            return new String[0];
        }
        return Cytoscape.getEdgeNetworkData().getUniqueStringValues(INTERACTION);
    }

    public static String getInteractionType(CyNetwork network, Edge e) {
        if (network == null || e == null) {
            return null;
        }
        String canonicalName = Cytoscape.getEdgeNetworkData().getCanonicalName(e);
        return Cytoscape.getEdgeNetworkData().getStringValue(INTERACTION, canonicalName);
    }

    public static boolean areSynonyms(String firstName, String secondName, CyNetwork network, CytoscapeObj cytoscapeObj) {
        if (firstName == null || secondName == null) {
            return firstName == null && secondName == null;
        }
        if (firstName.equalsIgnoreCase(secondName)) {
            return true;
        }
        List firstSynonyms = Semantics.getAllSynonyms(firstName, network, cytoscapeObj);
        List secondSynonyms = Semantics.getAllSynonyms(secondName, network, cytoscapeObj);
        Iterator firstI = firstSynonyms.iterator();
        while (firstI.hasNext()) {
            String firstSyn = (String)firstI.next();
            Iterator secondI = secondSynonyms.iterator();
            while (secondI.hasNext()) {
                String secondSyn = (String)secondI.next();
                if (!firstSyn.equalsIgnoreCase(secondSyn)) continue;
                return true;
            }
        }
        return false;
    }

    public static List getAllSynonyms(String name, CyNetwork network, CytoscapeObj cytoscapeObj) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (name == null) {
            return returnList;
        }
        returnList.add(name);
        String species = null;
        if (network != null) {
            String callerID = "Semantics.getAllSynonyms";
            String commonName = Cytoscape.getNodeNetworkData().getStringValue(COMMON_NAME, name);
            if (commonName != null) {
                returnList.add(commonName);
            }
            species = Cytoscape.getNodeNetworkData().getStringValue(SPECIES, name);
        }
        if (cytoscapeObj != null && cytoscapeObj.getBioDataServer() != null) {
            BioDataServer bioDataServer = cytoscapeObj.getBioDataServer();
            if (species == null) {
                species = Semantics.getDefaultSpecies(network, cytoscapeObj);
            }
            if (species != null) {
                String[] synonyms = bioDataServer.getAllCommonNames(species, name);
                returnList.addAll(Arrays.asList(synonyms));
            }
        }
        return returnList;
    }
}

