/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.util.Misc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphObjAttributes
implements Cloneable,
Serializable {
    HashMap map = new HashMap();
    transient HashMap nameFinder = new HashMap();
    transient HashMap canonicalToGraphObject = new HashMap();
    transient HashMap countIdMap = new HashMap();
    HashMap categoryMap = new HashMap();
    HashMap classMap = new HashMap();
    public static final String DEFAULT_CATEGORY = "unknown";

    public Object clone() {
        GraphObjAttributes attributesClone = null;
        try {
            attributesClone = (GraphObjAttributes)super.clone();
            attributesClone.map = (HashMap)this.map.clone();
            String[] keys = this.map.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                HashMap singleAttributeHash = (HashMap)this.map.get(keys[i]);
                HashMap singleAttributeHashClone = (HashMap)singleAttributeHash.clone();
                attributesClone.map.put(keys[i], singleAttributeHashClone);
                String[] graphObjectNames = singleAttributeHash.keySet().toArray(new String[0]);
                for (int j = 0; j < graphObjectNames.length; ++j) {
                    Object obj = singleAttributeHash.get(graphObjectNames[j]);
                    if (obj.getClass() != Class.forName("java.util.Vector")) continue;
                    Vector list = (Vector)obj;
                    Vector clonedList = (Vector)list.clone();
                    singleAttributeHashClone.put(graphObjectNames[j], clonedList);
                }
            }
            attributesClone.nameFinder = (HashMap)this.nameFinder.clone();
            attributesClone.canonicalToGraphObject = (HashMap)this.canonicalToGraphObject.clone();
            attributesClone.countIdMap = (HashMap)this.countIdMap.clone();
            attributesClone.categoryMap = (HashMap)this.categoryMap.clone();
            attributesClone.classMap = (HashMap)this.classMap.clone();
        }
        catch (Exception e) {
            System.err.println(" --- error in GraphObjAttributes.clone");
            e.printStackTrace();
        }
        return attributesClone;
    }

    public void inputAll(GraphObjAttributes newAttributes) {
        if (newAttributes == null) {
            return;
        }
        this.addNameMap(newAttributes.getNameMap());
        this.addObjectMap(newAttributes.getObjectMap());
        this.addClassMap(newAttributes.getClassMap());
        this.set(newAttributes);
    }

    public void addNameMapping(String canonicalName, Object graphObject) {
        this.nameFinder.put(graphObject, canonicalName);
        this.canonicalToGraphObject.put(canonicalName, graphObject);
        this.set("canonicalName", canonicalName, canonicalName);
    }

    public void removeNameMapping(String canonicalName) {
        Integer numIdentical;
        Object graphObject = this.canonicalToGraphObject.remove(canonicalName);
        this.nameFinder.remove(graphObject);
        if (this.countIdMap != null && (numIdentical = (Integer)this.countIdMap.get(canonicalName)) != null && numIdentical > 0) {
            this.countIdMap.put(canonicalName, new Integer(numIdentical - 1));
        }
    }

    public void removeObjectMapping(Object graphObj) {
        String canonical = (String)this.nameFinder.remove(graphObj);
        this.canonicalToGraphObject.remove(canonical);
    }

    public void clearNameMap() {
        this.nameFinder = new HashMap();
        this.clearObjectMap();
    }

    public void clearObjectMap() {
        this.canonicalToGraphObject = new HashMap();
    }

    public HashMap getNameMap() {
        return this.nameFinder;
    }

    public HashMap getClassMap() {
        return this.classMap;
    }

    public void addClassMap(HashMap newClassMap) {
        this.classMap.putAll(newClassMap);
    }

    public HashMap getObjectMap() {
        return this.canonicalToGraphObject;
    }

    public void addNameMap(HashMap nameMapping) {
        this.nameFinder.putAll(nameMapping);
        Set keySet = nameMapping.keySet();
        Iterator it = keySet.iterator();
        HashMap objectMap = new HashMap();
        while (it.hasNext()) {
            Object graphObj = it.next();
            String canonical = (String)this.nameFinder.get(graphObj);
            objectMap.put(canonical, graphObj);
        }
        this.addObjectMap(objectMap);
    }

    public void addObjectMap(HashMap objectMapping) {
        this.canonicalToGraphObject.putAll(objectMapping);
    }

    public String getCanonicalName(Object graphObject) {
        if (this.nameFinder == null) {
            System.out.println("oh oh, nameFinder is NULL !!!!!!!!!!!!!!");
        }
        return (String)this.nameFinder.get(graphObject);
    }

    public Object getGraphObject(String canonicalName) {
        return this.canonicalToGraphObject.get(canonicalName);
    }

    public void set(GraphObjAttributes attributes) {
        String[] newAttributeNames = attributes.getAttributeNames();
        for (int i = 0; i < newAttributeNames.length; ++i) {
            String name = newAttributeNames[i];
            HashMap hash = attributes.getAttribute(newAttributeNames[i]);
            this.map.put(name, hash);
        }
    }

    protected void initializeAttributeAsRequired(String attributeName, String graphObjectName, Object obj) {
        if (!this.map.containsKey(attributeName)) {
            this.map.put(attributeName, new HashMap());
            if (this.getClass(attributeName) == null) {
                Class<?> deducedClass = obj.getClass();
                if (obj.getClass().isArray()) {
                    deducedClass = ((Object[])obj)[0].getClass();
                }
                this.setClass(attributeName, deducedClass);
            }
        }
        Class expectedClass = this.getClass(attributeName);
        Class<?> actualClass = obj.getClass();
        if (obj.getClass().isArray()) {
            Object[] objAsArray = (Object[])obj;
            Object first = objAsArray[0];
            actualClass = first.getClass();
        }
        if (actualClass != expectedClass) {
            throw new IllegalArgumentException("class mismatch during set for attribute " + attributeName + ",\n object: " + graphObjectName + "\n expected " + expectedClass + "\n got " + actualClass);
        }
    }

    public boolean set(String attributeName, String graphObjectName, Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.implementsSerializable(obj.getClass())) {
            throw new IllegalArgumentException("The class " + obj.getClass().getName() + " of the object that represents the value for the attribute \"" + attributeName + "\" must implement java.io.Serializable.");
        }
        this.initializeAttributeAsRequired(attributeName, graphObjectName, obj);
        HashMap attributeMap = (HashMap)this.map.get(attributeName);
        attributeMap.put(graphObjectName, obj);
        return true;
    }

    public boolean append(String attributeName, String graphObjectName, Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.implementsSerializable(obj.getClass())) {
            throw new IllegalArgumentException("The class " + obj.getClass().getName() + " of the object that represents the value for the attribute \"" + attributeName + "\" must implement java.io.Serializable.");
        }
        this.initializeAttributeAsRequired(attributeName, graphObjectName, obj);
        HashMap attributeMap = (HashMap)this.map.get(attributeName);
        Vector list = null;
        list = attributeMap.containsKey(graphObjectName) ? (Vector)attributeMap.get(graphObjectName) : new Vector();
        if (obj.getClass().isArray()) {
            Object[] objAsArray = (Object[])obj;
            for (int i = 0; i < objAsArray.length; ++i) {
                list.add(objAsArray[i]);
            }
        } else {
            list.add(obj);
        }
        attributeMap.put(graphObjectName, list);
        return true;
    }

    public boolean set(String attributeName, String graphObjectName, double value) {
        return this.set(attributeName, graphObjectName, new Double(value));
    }

    public boolean set(String graphObjectName, HashMap bundle) {
        String[] keys = bundle.keySet().toArray(new String[0]);
        boolean success = true;
        for (int i = 0; i < keys.length; ++i) {
            String attributeName = keys[i];
            Object value = bundle.get(attributeName);
            if (this.set(attributeName, graphObjectName, value)) continue;
            success = false;
        }
        return success;
    }

    public void add(GraphObjAttributes attributes) {
        this.set(attributes);
    }

    public boolean add(String attributeName, String graphObjectName, Object obj) {
        return this.set(attributeName, graphObjectName, obj);
    }

    public boolean add(String attributeName, String graphObjectName, double value) {
        return this.set(attributeName, graphObjectName, value);
    }

    public boolean add(String graphObjectName, HashMap bundle) {
        return this.set(graphObjectName, bundle);
    }

    public int size() {
        return this.numberOfAttributes();
    }

    public int numberOfAttributes() {
        return this.map.size();
    }

    public String[] getAttributeNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    public String[] getObjectNames(String attributeName) {
        HashMap attributeMap = this.getAttribute(attributeName);
        if (attributeMap == null) {
            return new String[0];
        }
        return attributeMap.keySet().toArray(new String[0]);
    }

    public Object[] getUniqueValues(String attributeName) {
        HashMap hash = this.getAttribute(attributeName);
        if (hash == null) {
            return null;
        }
        Object[] allValues = hash.values().toArray(new Object[0]);
        Vector<Object> nonredundantList = new Vector<Object>();
        for (int i = 0; i < allValues.length; ++i) {
            int j;
            Object[] allValuesI;
            if (allValues[i].getClass() == nonredundantList.getClass()) {
                allValuesI = ((Vector)allValues[i]).toArray(new Object[0]);
                for (j = 0; j < allValuesI.length; ++j) {
                    if (nonredundantList.contains(allValuesI[j])) continue;
                    nonredundantList.add(allValuesI[j]);
                }
                continue;
            }
            if (allValues[i].getClass().isArray()) {
                allValuesI = (Object[])allValues[i];
                for (j = 0; j < allValuesI.length; ++j) {
                    if (nonredundantList.contains(allValuesI[j])) continue;
                    nonredundantList.add(allValuesI[j]);
                }
                continue;
            }
            if (nonredundantList.contains(allValues[i])) continue;
            nonredundantList.add(allValues[i]);
        }
        return nonredundantList.toArray(new Object[0]);
    }

    public String[] getUniqueStringValues(String attributeName) {
        Object[] objs = this.getUniqueValues(attributeName);
        if (objs == null) {
            return new String[0];
        }
        String[] result = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = (String)objs[i];
        }
        return result;
    }

    public int getObjectCount(String attributeName) {
        HashMap attributeMap = this.getAttribute(attributeName);
        if (attributeMap == null) {
            return 0;
        }
        return attributeMap.size();
    }

    public void setCategory(String attributeName, String newValue) {
        this.categoryMap.put(attributeName, newValue);
    }

    public String getCategory(String attributeName) {
        return (String)this.categoryMap.get(attributeName);
    }

    public boolean hasAttribute(String attributeName) {
        return this.map.containsKey(attributeName);
    }

    public boolean hasAttribute(String attributeName, String graphObjName) {
        HashMap attributeMap = (HashMap)this.map.get(attributeName);
        if (attributeMap == null) {
            return false;
        }
        return attributeMap.containsKey(graphObjName);
    }

    public HashMap getAttribute(String attributeName) {
        return (HashMap)this.map.get(attributeName);
    }

    public void deleteAttribute(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            this.map.remove(attributeName);
        }
    }

    public void deleteAttribute(String attributeName, String graphObjectName) {
        if (!this.hasAttribute(attributeName)) {
            return;
        }
        HashMap oneAttributeMap = this.getAttribute(attributeName);
        oneAttributeMap.remove(graphObjectName);
    }

    public void deleteAttributeValue(String attributeName, String graphObjectName, Object value) {
        if (!this.hasAttribute(attributeName)) {
            return;
        }
        Vector list = this.getList(attributeName, graphObjectName);
        if (list.contains(value)) {
            list.remove(value);
        }
    }

    public boolean setClass(String attributeName, Class attributeClass) {
        if (this.implementsSerializable(attributeClass) || attributeClass == null) {
            this.classMap.put(attributeName, attributeClass);
            return true;
        }
        throw new IllegalArgumentException("Attribute class " + attributeClass.toString() + " must implement java.io.Serializable");
    }

    public Class getClass(String attributeName) {
        return (Class)this.classMap.get(attributeName);
    }

    public Vector getList(String attributeName, String graphObjectName) {
        HashMap attributeMap = (HashMap)this.map.get(attributeName);
        if (attributeMap == null) {
            return new Vector();
        }
        if (!attributeMap.containsKey(graphObjectName)) {
            return new Vector();
        }
        Object obj = attributeMap.get(graphObjectName);
        Vector tmp = new Vector();
        if (obj.getClass() != tmp.getClass()) {
            tmp.add(obj);
            return tmp;
        }
        return (Vector)attributeMap.get(graphObjectName);
    }

    public Object getValue(String attributeName, String graphObjectName) {
        return this.get(attributeName, graphObjectName);
    }

    public Object get(String attributeName, String graphObjectName) {
        HashMap attributeMap = (HashMap)this.map.get(attributeName);
        if (attributeMap == null) {
            return null;
        }
        if (!attributeMap.containsKey(graphObjectName)) {
            return null;
        }
        return attributeMap.get(graphObjectName);
    }

    public Object[] getArrayValues(String attributeName, String graphObjectName) {
        Vector list = this.getList(attributeName, graphObjectName);
        if (list == null) {
            return new Object[0];
        }
        Object[] result = list.toArray(new Object[0]);
        return result;
    }

    public String[] getStringArrayValues(String attributeName, String graphObjectName) {
        Vector list = this.getList(attributeName, graphObjectName);
        if (list == null) {
            return new String[0];
        }
        String[] result = list.toArray(new String[0]);
        return result;
    }

    public Double getDoubleValue(String attributeName, String graphObjectName) {
        Object object = this.getValue(attributeName, graphObjectName);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector tmp = (Vector)object;
                object = tmp.size() < 1 ? null : tmp.get(0);
            }
        }
        catch (ClassNotFoundException shouldNeverOccur) {
            // empty catch block
        }
        return (Double)object;
    }

    public Integer getIntegerValue(String attributeName, String graphObjectName) {
        Object object = this.getValue(attributeName, graphObjectName);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector tmp = (Vector)object;
                object = tmp.size() < 1 ? null : tmp.get(0);
            }
        }
        catch (ClassNotFoundException shouldNeverOccur) {
            // empty catch block
        }
        return (Integer)object;
    }

    public String getStringValue(String attributeName, String graphObjectName) {
        Object object = this.getValue(attributeName, graphObjectName);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector tmp = (Vector)object;
                object = tmp.size() < 1 ? null : tmp.get(0);
            }
        }
        catch (ClassNotFoundException shouldNeverOccur) {
            // empty catch block
        }
        return object.toString();
    }

    public String processFileHeader(String text) {
        String attributeName = "";
        String attributeCategory = DEFAULT_CATEGORY;
        Class<?> attributeClass = null;
        if (text.indexOf("(") < 0) {
            attributeName = text.trim();
        } else {
            StringTokenizer strtok = new StringTokenizer(text, "(");
            attributeName = strtok.nextToken().trim();
            while (strtok.hasMoreElements()) {
                String valuePair;
                int locationOfEqualSign;
                String rawValuePair = strtok.nextToken().trim();
                if (!rawValuePair.endsWith(")") || (locationOfEqualSign = (valuePair = rawValuePair.substring(0, rawValuePair.length() - 1)).indexOf("=")) < 0 || valuePair.endsWith("=")) continue;
                StringTokenizer strtok2 = new StringTokenizer(valuePair, "=");
                String name = strtok2.nextToken();
                String value = strtok2.nextToken();
                if (name.equals("category")) {
                    attributeCategory = value;
                }
                if (!name.equals("class")) continue;
                try {
                    attributeClass = Class.forName(value);
                }
                catch (ClassNotFoundException ignore) {}
            }
        }
        this.setCategory(attributeName, attributeCategory);
        this.setClass(attributeName, attributeClass);
        return attributeName;
    }

    public void readAttributesFromFile(String filename) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        this.readAttributesFromFile(null, DEFAULT_CATEGORY, filename, true);
    }

    public void readAttributesFromFile(File file) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        this.readAttributesFromFile(null, DEFAULT_CATEGORY, file.getPath(), true);
    }

    public static Class deduceClass(String string) {
        String[] classNames = new String[]{"java.net.URL", "java.lang.Integer", "java.lang.Double", "java.lang.String"};
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Object obj = GraphObjAttributes.createInstanceFromString(Class.forName(classNames[i]), string);
                return obj.getClass();
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Object createInstanceFromString(Class requestedClass, String ctorArg) throws Exception {
        Class[] ctorArgsClasses = new Class[]{Class.forName("java.lang.String")};
        Object[] ctorArgs = new Object[]{new String(ctorArg)};
        Constructor ctor = requestedClass.getConstructor(ctorArgsClasses);
        return ctor.newInstance(ctorArgs);
    }

    public void readAttributesFromFile(BioDataServer dataServer, String species, String filename, boolean canonicalize) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        String rawText;
        try {
            Object reader;
            if (filename.trim().startsWith("jar://")) {
                reader = new TextJarReader(filename);
                ((TextJarReader)reader).read();
                rawText = ((TextJarReader)reader).getText();
            } else {
                reader = new TextFileReader(filename);
                ((TextFileReader)reader).read();
                rawText = ((TextFileReader)reader).getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading attributes file " + filename);
            System.err.println(e0.getMessage());
            e0.printStackTrace();
            return;
        }
        StringTokenizer lineTokenizer = new StringTokenizer(rawText, "\n");
        int lineNumber = 0;
        if (lineTokenizer.countTokens() < 2) {
            throw new IllegalArgumentException(filename + " must have at least 2 lines");
        }
        String attributeName = this.processFileHeader(lineTokenizer.nextToken().trim());
        boolean extractingFirstValue = true;
        boolean attributeHasStringValue = true;
        while (lineTokenizer.hasMoreElements()) {
            int i;
            String[] rawList;
            String newLine = (String)lineTokenizer.nextElement();
            if (newLine.trim().startsWith("#")) continue;
            ++lineNumber;
            StringTokenizer strtok2 = new StringTokenizer(newLine, "=");
            if (strtok2.countTokens() < 2) {
                throw new IllegalArgumentException("cannot parse line number " + lineNumber + ":\n\t" + newLine);
            }
            String graphObjectName = strtok2.nextToken().trim();
            if (canonicalize && dataServer != null) {
                graphObjectName = dataServer.getCanonicalName(species, graphObjectName);
            }
            String rawString = newLine.substring(newLine.indexOf("=") + 1).trim();
            boolean isList = false;
            if (Misc.isList(rawString, "(", ")", "::")) {
                rawList = Misc.parseList(rawString, "(", ")", "::");
                isList = true;
            } else {
                rawList = new String[]{rawString};
            }
            if (extractingFirstValue && this.getClass(attributeName) == null) {
                extractingFirstValue = false;
                Class deducedClass = GraphObjAttributes.deduceClass(rawList[0]);
                this.setClass(attributeName, deducedClass);
            }
            Object[] objs = new Object[rawList.length];
            Class<?> stringClass = new String().getClass();
            if (this.getClass(attributeName).equals(stringClass)) {
                for (i = 0; i < rawList.length; ++i) {
                    rawList[i] = rawList[i].replaceAll("\\\\n", "\n");
                }
            }
            for (i = 0; i < rawList.length; ++i) {
                try {
                    objs[i] = GraphObjAttributes.createInstanceFromString(this.getClass(attributeName), rawList[i]);
                    if (isList) {
                        this.append(attributeName, graphObjectName, objs[i]);
                        continue;
                    }
                    this.set(attributeName, graphObjectName, objs[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("\tcould not create an instance of\n" + this.getClass(attributeName) + " from\n" + rawList[i]);
                }
            }
        }
    }

    public HashMap getSummary() {
        HashMap result = new HashMap();
        String[] attributeNames = this.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            String firstObjectName = this.getObjectNames(attributeName)[0];
            Object firstValue = this.getValue(attributeName, firstObjectName);
            result.put(attributeName, firstValue.getClass());
        }
        return result;
    }

    public HashMap getAttributes(String canonicalName) {
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        String[] allAttributes = this.getAttributeNames();
        for (int i = 0; i < allAttributes.length; ++i) {
            String attributeName = allAttributes[i];
            Object value = this.getValue(attributeName, canonicalName);
            if (value == null) continue;
            bundle.put(attributeName, value);
        }
        return bundle;
    }

    public int countIdentical(String graphObjectName) {
        Integer count;
        if (this.countIdMap == null) {
            this.countIdMap = new HashMap();
        }
        if ((count = (Integer)this.countIdMap.get(graphObjectName)) == null) {
            count = new Integer(0);
        }
        this.countIdMap.put(graphObjectName, new Integer(count + 1));
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n-- canonicalNames: " + this.nameFinder.size());
        String nameFinderString = this.nameFinder.toString();
        StringTokenizer strtok = new StringTokenizer(nameFinderString, ",");
        while (strtok.hasMoreElements()) {
            sb.append("\n");
            sb.append(strtok.nextToken());
        }
        String[] names = this.getAttributeNames();
        sb.append("\n-- attributes: " + names.length + "\n");
        for (int i = 0; i < names.length; ++i) {
            sb.append("attribute " + i + ": " + names[i] + "  ");
            Class attributeClass = this.getClass(names[i]);
            String category = this.getCategory(names[i]);
            sb.append("(class:" + attributeClass + ") ");
            sb.append("(category: " + category + ")");
            sb.append("\n");
            String[] keys = this.getObjectNames(names[i]);
            for (int j = 0; j < keys.length; ++j) {
                Object[] arrayValue = this.getArrayValues(names[i], keys[j]);
                sb.append("   " + keys[j] + " -> (");
                for (int k = 0; k < arrayValue.length; ++k) {
                    sb.append(arrayValue[k]);
                    if (k >= arrayValue.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")\n");
            }
        }
        return sb.toString();
    }

    protected boolean implementsSerializable(Class objClass) {
        if (objClass == null) {
            return false;
        }
        Class<?>[] interfaces = objClass.getInterfaces();
        Class<?> serializable = null;
        try {
            serializable = Class.forName("java.io.Serializable");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!serializable.isAssignableFrom(interfaces[i])) continue;
            return true;
        }
        return this.implementsSerializable(objClass.getSuperclass());
    }

    public static String[] unpackPossiblyCompoundStringAttributeValue(Object value) {
        String[] result = new String[]{};
        try {
            if (value.getClass() == Class.forName("java.lang.String")) {
                result = new String[]{(String)value};
            } else if (value.getClass() == Class.forName("[Ljava.lang.String;")) {
                result = (String[])value;
            } else if (value.getClass() == Class.forName("java.util.Vector")) {
                Vector tmp = (Vector)value;
                result = tmp.toArray(new String[0]);
            } else {
                String msg = "AnnotationGui.unpackPossiblyCompoundAttributeValue, unrecognized class: " + value.getClass();
                System.err.println(msg);
            }
        }
        catch (ClassNotFoundException ignore) {
            ignore.printStackTrace();
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        System.out.println("Writing GraphObjAttributes...");
        System.out.flush();
        out.defaultWriteObject();
        System.out.println("Wrote GraphObjAttributes");
        System.out.flush();
    }
}

