/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FlagFilter
implements Filter,
GraphPerspectiveChangeListener {
    GraphPerspective graph;
    Set flaggedNodes = new HashSet();
    Set flaggedEdges = new HashSet();
    List listeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FlagFilter(GraphPerspective graph) {
        this.graph = graph;
        graph.addGraphPerspectiveChangeListener(this);
    }

    public Set getFlaggedNodes() {
        return this.flaggedNodes;
    }

    public Set getFlaggedEdges() {
        return this.flaggedEdges;
    }

    public boolean isFlagged(Node node) {
        return this.flaggedNodes.contains(node);
    }

    public boolean isFlagged(Edge edge) {
        return this.flaggedEdges.contains(edge);
    }

    public boolean passesFilter(Object o) {
        return this.flaggedNodes.contains(o) || this.flaggedEdges.contains(o);
    }

    public boolean setFlagged(Node node, boolean newState) {
        if (newState) {
            if (!this.graph.containsNode(node)) {
                return false;
            }
            boolean setChanged = this.flaggedNodes.add(node);
            if (setChanged) {
                this.fireEvent(node, true);
            }
            return setChanged;
        }
        boolean setChanged = this.flaggedNodes.remove(node);
        if (setChanged) {
            this.fireEvent(node, false);
        }
        return setChanged;
    }

    public boolean setFlagged(Edge edge, boolean newState) {
        if (newState) {
            if (!this.graph.containsEdge(edge)) {
                return false;
            }
            boolean setChanged = this.flaggedEdges.add(edge);
            if (setChanged) {
                this.fireEvent(edge, true);
            }
            return setChanged;
        }
        boolean setChanged = this.flaggedEdges.remove(edge);
        if (setChanged) {
            this.fireEvent(edge, false);
        }
        return setChanged;
    }

    public Set setFlaggedNodes(Collection nodesToSet, boolean newState) {
        HashSet<Node> returnSet = new HashSet<Node>();
        if (nodesToSet == null) {
            return returnSet;
        }
        if (newState) {
            Iterator i = nodesToSet.iterator();
            while (i.hasNext()) {
                boolean setChanged;
                Node node = (Node)i.next();
                if (!this.graph.containsNode(node) || !(setChanged = this.flaggedNodes.add(node))) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, true);
            }
        } else {
            Iterator i = nodesToSet.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                boolean setChanged = this.flaggedNodes.remove(node);
                if (!setChanged) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, false);
            }
        }
        return returnSet;
    }

    public Set setFlaggedEdges(Collection edgesToSet, boolean newState) {
        HashSet<Edge> returnSet = new HashSet<Edge>();
        if (edgesToSet == null) {
            return returnSet;
        }
        if (newState) {
            Iterator i = edgesToSet.iterator();
            while (i.hasNext()) {
                boolean setChanged;
                Edge edge = (Edge)i.next();
                if (!this.graph.containsEdge(edge) || !(setChanged = this.flaggedEdges.add(edge))) continue;
                returnSet.add(edge);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, true);
            }
        } else {
            Iterator i = edgesToSet.iterator();
            while (i.hasNext()) {
                Edge edge = (Edge)i.next();
                boolean setChanged = this.flaggedEdges.remove(edge);
                if (!setChanged) continue;
                returnSet.add(edge);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, false);
            }
        }
        return returnSet;
    }

    public void flagAllNodes() {
        HashSet<Node> changes = new HashSet<Node>();
        Iterator i = this.graph.nodesIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            boolean setChanged = this.flaggedNodes.add(node);
            if (!setChanged) continue;
            changes.add(node);
        }
        if (changes.size() > 0) {
            this.fireEvent(changes, true);
        }
    }

    public void flagAllEdges() {
        HashSet<Edge> changes = new HashSet<Edge>();
        Iterator i = this.graph.edgesIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            boolean setChanged = this.flaggedEdges.add(edge);
            if (!setChanged) continue;
            changes.add(edge);
        }
        if (changes.size() > 0) {
            this.fireEvent(changes, true);
        }
    }

    public void unflagAllNodes() {
        if (this.flaggedNodes.size() == 0) {
            return;
        }
        HashSet changes = new HashSet(this.flaggedNodes);
        this.flaggedNodes.clear();
        this.fireEvent(changes, false);
    }

    public void unflagAllEdges() {
        if (this.flaggedEdges.size() == 0) {
            return;
        }
        HashSet changes = new HashSet(this.flaggedEdges);
        this.flaggedEdges.clear();
        this.fireEvent(changes, false);
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        HashSet<Node> nodeChanges = null;
        if (event.isNodesHiddenType()) {
            Node[] hiddenNodes = event.getHiddenNodes();
            for (int index = 0; index < hiddenNodes.length; ++index) {
                Node node = hiddenNodes[index];
                boolean setChanged = this.flaggedNodes.remove(node);
                if (!setChanged) continue;
                if (nodeChanges == null) {
                    nodeChanges = new HashSet<Node>();
                }
                nodeChanges.add(node);
            }
        }
        if (nodeChanges != null && nodeChanges.size() > 0) {
            this.fireEvent(nodeChanges, false);
        }
        HashSet<Edge> edgeChanges = null;
        if (event.isEdgesHiddenType()) {
            GraphPerspective source = (GraphPerspective)event.getSource();
            int[] indices = event.getHiddenEdgeIndices();
            for (int index = 0; index < indices.length; ++index) {
                Edge edge = source.getRootGraph().getEdge(indices[index]);
                boolean setChanged = this.flaggedEdges.remove(edge);
                if (!setChanged) continue;
                if (edgeChanges == null) {
                    edgeChanges = new HashSet<Edge>();
                }
                edgeChanges.add(edge);
            }
        }
        if (edgeChanges != null && edgeChanges.size() > 0) {
            this.fireEvent(edgeChanges, false);
        }
    }

    public void addFlagEventListener(FlagEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeFlagEventListener(FlagEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(Object target, boolean selectOn) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        FlagEvent event = new FlagEvent(this, target, selectOn);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            FlagEventListener listener = (FlagEventListener)i.next();
            listener.onFlagEvent(event);
        }
    }

    static {
        $assertionsDisabled = !FlagFilter.class.desiredAssertionStatus();
    }
}

