/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.GraphObjAttributes;
import cytoscape.data.mRNAMeasurement;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionData
implements Serializable {
    public static final int MAX_LINE_SIZE = 8192;
    public static final int PVAL = 0;
    public static final int LAMBDA = 1;
    public static final int NONE = 2;
    public static final int UNKNOWN = 3;
    protected int significanceType = 3;
    String filename = null;
    int numGenes = 0;
    int numConds = 0;
    int extraTokens = 0;
    boolean haveSigValues = false;
    Vector geneNames;
    Vector geneDescripts;
    Vector condNames;
    Hashtable geneNameToIndex;
    Hashtable condNameToIndex;
    double minExp;
    double maxExp;
    double minSig;
    double maxSig;
    Vector allMeasurements;
    static /* synthetic */ Class class$java$lang$Double;

    public ExpressionData() {
        this.initDataStructures();
    }

    public ExpressionData(String filename) {
        this.initDataStructures();
        this.loadData(filename);
    }

    public String getFileName() {
        return this.filename;
    }

    public File getFullPath() {
        File file = new File(this.filename);
        return file.getAbsoluteFile();
    }

    private void initDataStructures() {
        int expand = 1000;
        if (this.geneNames != null) {
            this.geneNames.clear();
        }
        this.geneNames = new Vector(0, expand);
        if (this.geneDescripts != null) {
            this.geneDescripts.clear();
        }
        this.geneDescripts = new Vector(0, expand);
        if (this.condNames != null) {
            this.condNames.clear();
        }
        this.condNames = new Vector();
        if (this.geneNameToIndex != null) {
            this.geneNameToIndex.clear();
        }
        this.geneNameToIndex = new Hashtable();
        if (this.condNameToIndex != null) {
            this.condNameToIndex.clear();
        }
        this.condNameToIndex = new Hashtable();
        this.minExp = Double.MAX_VALUE;
        this.maxExp = Double.MIN_VALUE;
        this.minSig = Double.MAX_VALUE;
        this.maxSig = Double.MIN_VALUE;
        if (this.allMeasurements != null) {
            this.allMeasurements.clear();
        }
        this.allMeasurements = new Vector(0, expand);
    }

    public boolean oldLoadData(String filename) {
        int i;
        int numberOfConditions;
        BufferedReader input;
        if (filename == null) {
            return false;
        }
        try {
            input = new BufferedReader(new FileReader(filename), 8192);
        }
        catch (IOException e) {
            System.err.println("Error trying to open data file " + filename);
            return false;
        }
        String headerLine = this.readOneLine(input);
        if (this.isHeaderLineNull(headerLine, input, filename)) {
            return false;
        }
        if (this.isHeaderLineMTXHeader(headerLine)) {
            headerLine = this.readOneLine(input);
        }
        boolean expectPvals = this.doesHeaderLineHaveDuplicates(headerLine);
        StringTokenizer headerTok = new StringTokenizer(headerLine);
        int numTokens = headerTok.countTokens();
        if (numTokens < 3 || numTokens < 4 && expectPvals) {
            System.err.println("Bad header format in data file " + filename);
            System.err.println("Number of tokens parsed: " + numTokens);
            for (int i2 = 0; i2 < numTokens; ++i2) {
                System.err.println("Token " + i2 + ": " + headerTok.nextToken());
            }
            try {
                input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        double tmpF = (double)numTokens / 2.0;
        int tmpI = (int)Math.rint(tmpF);
        int haveExtraTokens = 0;
        if (expectPvals) {
            if ((double)tmpI == tmpF) {
                numberOfConditions = (numTokens - 2) / 2;
                haveExtraTokens = 0;
            } else {
                numberOfConditions = (numTokens - 3) / 2;
                haveExtraTokens = 1;
            }
        } else {
            numberOfConditions = numTokens - 2;
        }
        System.out.println("parsed " + numTokens + " tokens from header line," + " representing " + numberOfConditions + " conditions.");
        headerTok.nextToken();
        headerTok.nextToken();
        Vector<String> cNames = new Vector<String>(numberOfConditions);
        for (i = 0; i < numberOfConditions; ++i) {
            cNames.add(headerTok.nextToken());
        }
        if (expectPvals) {
            for (i = 0; i < numberOfConditions; ++i) {
                String title = headerTok.nextToken();
                if (title.equals(cNames.get(i))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + filename + ": " + cNames.get(i) + " vs. " + title);
                return false;
            }
        }
        this.filename = filename;
        this.numConds = numberOfConditions;
        this.extraTokens = haveExtraTokens;
        this.initDataStructures();
        this.condNames = cNames;
        for (i = 0; i < this.numConds; ++i) {
            this.condNameToIndex.put(this.condNames.get(i), new Integer(i));
        }
        String oneLine = this.readOneLine(input);
        int lineCount = 1;
        while (oneLine != null) {
            this.parseOneLine(oneLine, ++lineCount, expectPvals);
            oneLine = this.readOneLine(input);
        }
        this.numGenes = this.geneNames.size();
        for (int i3 = 0; i3 < this.geneNames.size(); ++i3) {
            this.geneNameToIndex.put(this.geneNames.get(i3), new Integer(i3));
        }
        this.geneNames.trimToSize();
        this.geneDescripts.trimToSize();
        this.allMeasurements.trimToSize();
        try {
            input.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    public boolean loadData(String filename) {
        int i;
        int numberOfConditions;
        StringTokenizer headerTok;
        int numTokens;
        String rawText;
        if (filename == null) {
            return false;
        }
        try {
            Object reader;
            if (filename.trim().startsWith("jar://")) {
                reader = new TextJarReader(filename);
                ((TextJarReader)reader).read();
                rawText = ((TextJarReader)reader).getText();
            } else {
                reader = new TextFileReader(filename);
                ((TextFileReader)reader).read();
                rawText = ((TextFileReader)reader).getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading expression file " + filename);
            System.err.println(e0.getMessage());
            return false;
        }
        String[] lines = rawText.split("\n");
        int lineCount = 0;
        String headerLine = lines[lineCount++];
        if (headerLine == null || headerLine.length() == 0) {
            return false;
        }
        if (this.isHeaderLineMTXHeader(headerLine)) {
            this.significanceType = 1;
            headerLine = lines[lineCount++];
        }
        boolean expectPvals = this.doesHeaderLineHaveDuplicates(headerLine);
        if (this.significanceType != 1 && !expectPvals) {
            this.significanceType = 2;
        }
        if ((numTokens = (headerTok = new StringTokenizer(headerLine)).countTokens()) < 3 || numTokens < 4 && expectPvals) {
            System.err.println("Bad header format in data file " + filename);
            System.err.println("Number of tokens parsed: " + numTokens);
            for (int i2 = 0; i2 < numTokens; ++i2) {
                System.err.println("Token " + i2 + ": " + headerTok.nextToken());
            }
            return false;
        }
        double tmpF = (double)numTokens / 2.0;
        int tmpI = (int)Math.rint(tmpF);
        int haveExtraTokens = 0;
        if (expectPvals) {
            if ((double)tmpI == tmpF) {
                numberOfConditions = (numTokens - 2) / 2;
                haveExtraTokens = 0;
            } else {
                numberOfConditions = (numTokens - 3) / 2;
                haveExtraTokens = 1;
            }
        } else {
            numberOfConditions = numTokens - 2;
        }
        System.out.println("parsed " + numTokens + " tokens from header line," + " representing " + numberOfConditions + " conditions.");
        headerTok.nextToken();
        headerTok.nextToken();
        Vector<String> cNames = new Vector<String>(numberOfConditions);
        for (i = 0; i < numberOfConditions; ++i) {
            cNames.add(headerTok.nextToken());
        }
        if (expectPvals) {
            for (i = 0; i < numberOfConditions; ++i) {
                String title = headerTok.nextToken();
                if (title.equals(cNames.get(i))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + filename + ": " + cNames.get(i) + " vs. " + title);
                return false;
            }
        }
        this.filename = filename;
        this.numConds = numberOfConditions;
        this.extraTokens = haveExtraTokens;
        this.haveSigValues = expectPvals;
        this.initDataStructures();
        this.condNames = cNames;
        for (i = 0; i < this.numConds; ++i) {
            this.condNameToIndex.put(this.condNames.get(i), new Integer(i));
        }
        for (i = lineCount; i < lines.length; ++i) {
            this.parseOneLine(lines[i], lineCount, expectPvals);
        }
        this.numGenes = this.geneNames.size();
        for (i = 0; i < this.geneNames.size(); ++i) {
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
        this.geneNames.trimToSize();
        this.geneDescripts.trimToSize();
        this.allMeasurements.trimToSize();
        return true;
    }

    private boolean doesHeaderLineHaveDuplicates(String hline) {
        boolean retval = false;
        StringTokenizer headerTok = new StringTokenizer(hline);
        int numTokens = headerTok.countTokens();
        if (numTokens < 3) {
            retval = false;
        } else {
            headerTok.nextToken();
            headerTok.nextToken();
            HashMap<String, String> names = new HashMap<String, String>();
            while (!retval && headerTok.hasMoreTokens()) {
                String title = headerTok.nextToken();
                String titleObject = title;
                if (names.get(titleObject) == null) {
                    names.put(titleObject, titleObject);
                    continue;
                }
                retval = true;
            }
        }
        return retval;
    }

    private boolean isHeaderLineNull(String hline, BufferedReader input, String filename) {
        if (hline == null) {
            System.err.println("Could not read header line from data file " + filename);
            try {
                input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean isHeaderLineMTXHeader(String hline) {
        boolean b = false;
        String pattern = "\t+RATIOS\t+LAMBDAS";
        try {
            b = hline.matches(pattern);
        }
        catch (Exception e) {
            System.out.println("EXCEPTION in isHeaderLineMTXHeader: " + e);
            System.out.flush();
        }
        return b;
    }

    private String readOneLine(BufferedReader f) {
        String s = null;
        try {
            s = f.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    private void parseOneLine(String oneLine, int lineCount) {
        this.parseOneLine(oneLine, lineCount, true);
    }

    private void parseOneLine(String oneLine, int lineCount, boolean sig_vals) {
        int i;
        StringTokenizer strtok = new StringTokenizer(oneLine);
        int numTokens = strtok.countTokens();
        if (numTokens == 0) {
            return;
        }
        String gName = strtok.nextToken();
        if (gName.startsWith("NumSigGenes")) {
            return;
        }
        if (sig_vals && numTokens < 2 * this.numConds + 2 || !sig_vals && numTokens < this.numConds + 2) {
            System.out.println("Warning: parse error on line " + lineCount + "  tokens read: " + numTokens);
            return;
        }
        this.geneNames.add(gName);
        this.geneDescripts.add(strtok.nextToken());
        String[] expData = new String[this.numConds];
        for (int i2 = 0; i2 < this.numConds; ++i2) {
            expData[i2] = strtok.nextToken();
        }
        String[] sigData = new String[this.numConds];
        if (sig_vals) {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = strtok.nextToken();
            }
        } else {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = expData[i];
            }
        }
        Vector<mRNAMeasurement> measurements = new Vector<mRNAMeasurement>(this.numConds);
        for (int i3 = 0; i3 < this.numConds; ++i3) {
            mRNAMeasurement m = new mRNAMeasurement(expData[i3], sigData[i3]);
            measurements.add(m);
            double ratio = m.getRatio();
            double signif = m.getSignificance();
            if (ratio < this.minExp) {
                this.minExp = ratio;
            }
            if (ratio > this.maxExp) {
                this.maxExp = ratio;
            }
            if (signif < this.minSig) {
                this.minSig = signif;
            }
            if (!(signif > this.maxSig)) continue;
            this.maxSig = signif;
            if (this.significanceType == 1 || !sig_vals || !(this.maxSig > 1.0)) continue;
            this.significanceType = 1;
        }
        if (this.significanceType != 1 && sig_vals && this.minSig > 0.0) {
            this.significanceType = 0;
        }
        this.allMeasurements.add(measurements);
    }

    public void convertLambdasToPvals() {
        Iterator it = this.allMeasurements.iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            Iterator it2 = v.iterator();
            while (it2.hasNext()) {
                mRNAMeasurement m = (mRNAMeasurement)it2.next();
                double pval = ExpressionData.getPvalueFromLambda(m.getSignificance());
                m.setSignificance(pval);
            }
        }
    }

    public static double getPvalueFromLambda(double lambda) {
        double x = StrictMath.sqrt(lambda) / 2.0;
        double t = 1.0 / (1.0 + 0.3275911 * x);
        double erfc = StrictMath.exp(-(x * x)) * (0.254829592 * t + -0.284496736 * StrictMath.pow(t, 2.0) + 1.421413741 * StrictMath.pow(t, 3.0) + -1.453152027 * StrictMath.pow(t, 4.0) + 1.061405429 * StrictMath.pow(t, 5.0));
        if ((erfc /= 2.0) < 0.0 || erfc > 1.0) {
            throw new IllegalStateException("The calculated pvalue for lambda = " + lambda + " is " + erfc);
        }
        return erfc;
    }

    public int getSignificanceType() {
        return this.significanceType;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("Data read from: " + this.filename + lineSep);
        sb.append(lineSep);
        sb.append("Number of genes = " + this.getNumberOfGenes() + lineSep);
        sb.append("Number of conditions = " + this.getNumberOfConditions() + lineSep);
        sb.append("Significance values: ");
        if (this.haveSigValues) {
            sb.append("yes");
        } else {
            sb.append("no");
        }
        sb.append(lineSep).append(lineSep);
        sb.append("MinExp: " + this.minExp + "    MaxExp: " + this.maxExp + lineSep);
        if (this.haveSigValues) {
            sb.append("MinSig: " + this.minSig + "    MaxSig: " + this.maxSig + lineSep);
            String sigType = null;
            if (this.significanceType == 3) {
                sigType = "unknown";
            } else if (this.significanceType == 1) {
                sigType = "lambda values";
            } else if (this.significanceType == 0) {
                sigType = "p-values";
            } else if (this.significanceType == 2) {
                sigType = "none";
            }
            sb.append("Type of significance: " + sigType + lineSep);
        }
        return sb.toString();
    }

    public int getNumberOfGenes() {
        return this.numGenes;
    }

    public int getNumberOfConditions() {
        return this.numConds;
    }

    public String[] getGeneNames() {
        return this.geneNames.toArray(new String[0]);
    }

    public Vector getGeneNamesVector() {
        return this.geneNames;
    }

    public void setGeneNames(Vector newNames) {
        this.geneNames = newNames;
        this.geneNameToIndex.clear();
        for (int i = 0; i < this.geneNames.size(); ++i) {
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
    }

    public String[] getGeneDescriptors() {
        return this.geneDescripts.toArray(new String[0]);
    }

    public Vector getGeneDescriptorsVector() {
        return this.geneDescripts;
    }

    public void setGeneDescriptors(Vector newDescripts) {
        this.geneDescripts = newDescripts;
    }

    public String[] getConditionNames() {
        return this.condNames.toArray(new String[0]);
    }

    public int getConditionIndex(String condition) {
        return (Integer)this.condNameToIndex.get(condition);
    }

    public double[][] getExtremeValues() {
        double[][] maxVals = new double[2][2];
        maxVals[0][0] = this.minExp;
        maxVals[0][1] = this.maxExp;
        maxVals[1][0] = this.minSig;
        maxVals[0][1] = this.maxSig;
        return maxVals;
    }

    public String getGeneDescriptor(String gene) {
        Integer geneIndex = (Integer)this.geneNameToIndex.get(gene);
        if (geneIndex == null) {
            return null;
        }
        return (String)this.geneDescripts.get(geneIndex);
    }

    public boolean hasSignificanceValues() {
        return this.haveSigValues;
    }

    public Vector getAllMeasurements() {
        return this.allMeasurements;
    }

    public Vector getMeasurements(String gene) {
        Integer geneIndex = (Integer)this.geneNameToIndex.get(gene);
        if (geneIndex == null) {
            return null;
        }
        Vector measurements = (Vector)this.getAllMeasurements().get(geneIndex);
        return measurements;
    }

    public mRNAMeasurement getMeasurement(String gene, String condition) {
        Integer condIndex = (Integer)this.condNameToIndex.get(condition);
        if (condIndex == null) {
            return null;
        }
        Vector measurements = this.getMeasurements(gene);
        if (measurements == null) {
            return null;
        }
        mRNAMeasurement returnVal = (mRNAMeasurement)measurements.get(condIndex);
        return returnVal;
    }

    public void copyToAttribs(GraphObjAttributes nodeAttribs) {
        String[] condNames = this.getConditionNames();
        for (int condNum = 0; condNum < condNames.length; ++condNum) {
            String condName = condNames[condNum];
            String eStr = condName + "exp";
            String sStr = condName + "sig";
            for (int i = 0; i < this.geneNames.size(); ++i) {
                String canName = (String)this.geneNames.get(i);
                mRNAMeasurement mm = this.getMeasurement(canName, condName);
                if (mm == null) continue;
                nodeAttribs.add(eStr, canName, mm.getRatio());
                nodeAttribs.add(sStr, canName, mm.getSignificance());
            }
            nodeAttribs.setClass(eStr, class$java$lang$Double == null ? ExpressionData.class$("java.lang.Double") : class$java$lang$Double);
            nodeAttribs.setClass(sStr, class$java$lang$Double == null ? ExpressionData.class$("java.lang.Double") : class$java$lang$Double);
        }
    }
}

