/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.CytoscapeObj;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.Semantics;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class CyNetworkUtilities {
    public static boolean saveSelectedNodeNames(CyNetworkView networkView, CyNetwork network, String filename) {
        if (networkView == null || network == null || filename == null) {
            return false;
        }
        CyNetworkView graphView = networkView.getView();
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        String lineSep = System.getProperty("line.separator");
        try {
            File file = new File(filename);
            FileWriter fout = new FileWriter(file);
            Iterator i = graphView.getNodeViewsIterator();
            while (i.hasNext()) {
                NodeView nodeView = (NodeView)i.next();
                if (!nodeView.isSelected()) continue;
                Node node = nodeView.getNode();
                String canonicalName = nodeAttributes.getCanonicalName(node);
                fout.write(canonicalName + lineSep);
            }
            fout.close();
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + filename + "\"", 0);
            return false;
        }
    }

    public static boolean saveVisibleNodeNames(CyNetwork network, String filename) {
        if (network == null || filename == null) {
            return false;
        }
        String callerID = "CyNetworkUtilities.saveVisibleNodeNames";
        network.beginActivity(callerID);
        GraphPerspective theGraph = network.getGraphPerspective();
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        String lineSep = System.getProperty("line.separator");
        try {
            File file = new File(filename);
            FileWriter fout = new FileWriter(file);
            Iterator i = theGraph.nodesIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                String canonicalName = nodeAttributes.getCanonicalName(node);
                fout.write(canonicalName + lineSep);
            }
            fout.close();
            network.endActivity(callerID);
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + filename + "\"", 0);
            network.endActivity(callerID);
            return false;
        }
    }

    public static boolean selectNodesStartingWith(CyNetwork network, String key, CytoscapeObj cytoscapeObj, CyNetworkView networkView) {
        if (network == null || key == null || networkView == null) {
            return false;
        }
        key = key.toLowerCase();
        boolean found = false;
        String callerID = "CyNetworkUtilities.selectNodesStartingWith";
        network.beginActivity(callerID);
        GraphPerspective theGraph = network.getGraphPerspective();
        GraphObjAttributes nodeAttributes = network.getNodeAttributes();
        Iterator i = theGraph.nodesIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            String nodeLabel = node.getIdentifier();
            String canonicalName = nodeAttributes.getCanonicalName(node);
            boolean matched = false;
            if (nodeLabel != null && Strings.isLike(nodeLabel, key, 0, true)) {
                matched = true;
                found = true;
            } else {
                List synonyms = Semantics.getAllSynonyms(canonicalName, network, cytoscapeObj);
                Iterator synI = synonyms.iterator();
                while (synI.hasNext()) {
                    String synonym = (String)synI.next();
                    if (!Strings.isLike(synonym, key, 0, true)) continue;
                    matched = true;
                    found = true;
                    break;
                }
            }
            if (!matched) continue;
            networkView.getView().getNodeView(node).setSelected(matched);
        }
        network.endActivity(callerID);
        return found;
    }
}

