/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyNetwork;
import cytoscape.data.AttributeSaverDialog;
import cytoscape.data.GraphObjAttributes;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class AttributeSaverState
implements TableModel {
    public static String newline = System.getProperty("line.separator");
    protected String suffix;
    File saveDirectory;
    int type;
    Vector attributes;
    Vector filenames;
    Vector booleans;
    Vector listeners;
    CyNetwork cyNetwork;
    protected static final int FILE_COLUMN = 2;
    protected static final int ATTRIBUTE_COLUMN = 1;
    protected static final int SAVE_COLUMN = 0;

    public AttributeSaverState(String[] nodeAttributes, String suffix, int type, CyNetwork cyNetwork) {
        this.type = type;
        this.cyNetwork = cyNetwork;
        this.listeners = new Vector();
        this.attributes = new Vector();
        this.filenames = new Vector();
        this.booleans = new Vector();
        for (int idx = 0; idx < nodeAttributes.length; ++idx) {
            this.attributes.add(nodeAttributes[idx]);
        }
        Collections.sort(this.attributes);
        Iterator stringIt = this.attributes.iterator();
        while (stringIt.hasNext()) {
            String attribute = (String)stringIt.next();
            this.filenames.add(attribute + suffix);
            this.booleans.add(new Boolean(false));
        }
    }

    public void setSaveDirectory(File saveDirectory) {
        this.saveDirectory = saveDirectory;
    }

    public int writeState(int[] selectedRows) {
        List graphObjects = null;
        GraphObjAttributes graphObjAttributes = null;
        if (this.type == AttributeSaverDialog.NODES) {
            graphObjAttributes = this.cyNetwork.getNodeAttributes();
            graphObjects = this.cyNetwork.nodesList();
        } else {
            graphObjAttributes = this.cyNetwork.getEdgeAttributes();
            graphObjects = this.cyNetwork.edgesList();
        }
        Vector<String> canonicalNames = new Vector<String>();
        Iterator objIt = graphObjects.iterator();
        while (objIt.hasNext()) {
            String canonicalName = graphObjAttributes.getCanonicalName(objIt.next());
            if (canonicalName != null) {
                canonicalNames.add(canonicalName);
                continue;
            }
            System.err.println("Canonical name not found");
        }
        int count = 0;
        for (int idx = 0; idx < this.attributes.size(); ++idx) {
            if (!((Boolean)this.booleans.get(idx)).booleanValue()) continue;
            try {
                String attribute = (String)this.attributes.get(idx);
                File attributeFile = new File(this.saveDirectory, (String)this.filenames.get(idx));
                FileWriter fileWriter = new FileWriter(attributeFile);
                fileWriter.write(attribute + newline);
                HashMap attributeMap = graphObjAttributes.getAttribute(attribute);
                if (attributeMap != null) {
                    Iterator canonicalIt = canonicalNames.iterator();
                    while (canonicalIt.hasNext()) {
                        String name = (String)canonicalIt.next();
                        Object value = attributeMap.get(name);
                        if (value == null) continue;
                        if (value instanceof Collection) {
                            String result = name + " = ";
                            Collection collection = (Collection)value;
                            if (collection.size() <= 0) continue;
                            Iterator objIt2 = collection.iterator();
                            result = result + "(" + objIt2.next();
                            while (objIt2.hasNext()) {
                                result = result + "::" + objIt2.next();
                            }
                            result = result + ")" + newline;
                            fileWriter.write(result);
                            continue;
                        }
                        fileWriter.write(name + " = " + value + newline);
                    }
                }
                fileWriter.close();
                ++count;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void addTableModelListener(TableModelListener tml) {
        this.listeners.add(tml);
    }

    public void removeTableModelListener(TableModelListener tml) {
        this.listeners.remove(tml);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.attributes.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.booleans.get(rowIndex);
            }
            case 1: {
                return this.attributes.get(rowIndex);
            }
            case 2: {
                return this.filenames.get(rowIndex);
            }
        }
        throw new IllegalArgumentException();
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Save";
            }
            case 1: {
                return "Attribute";
            }
            case 2: {
                return "Filename";
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 1;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                throw new RuntimeException("Cell is not editable");
            }
            case 0: {
                this.booleans.set(rowIndex, aValue);
                break;
            }
            case 2: {
                this.filenames.set(rowIndex, aValue);
                break;
            }
        }
    }
}

