/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.AttributeSaverState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AttributeSaverDialog
extends JDialog {
    protected static String NODE_SUFFIX = ".NA";
    protected static String EDGE_SUFFIX = ".EA";
    protected static int MAX_PREFERRED_SIZE = 100;
    protected static int NODES = 0;
    protected static int EDGES = 1;
    AttributeSaverState state;
    JTable attributeTable;

    protected static void showDialog(int type) {
        AttributeSaverDialog dialog = new AttributeSaverDialog(type);
        dialog.setVisible(true);
    }

    public static void showEdgeDialog() {
        AttributeSaverDialog.showDialog(EDGES);
    }

    public static void showNodeDialog() {
        AttributeSaverDialog.showDialog(NODES);
    }

    public AttributeSaverDialog(int type) {
        super(Cytoscape.getDesktop(), "Save Attributes", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        String[] edgeAttributes = currentNetwork.getEdgeAttributesList();
        String[] nodeAttributes = currentNetwork.getNodeAttributesList();
        String suffix = null;
        String[] attributes = null;
        if (type == NODES) {
            suffix = NODE_SUFFIX;
            attributes = currentNetwork.getNodeAttributesList();
        } else {
            suffix = EDGE_SUFFIX;
            attributes = currentNetwork.getEdgeAttributesList();
        }
        this.state = new AttributeSaverState(attributes, suffix, type, Cytoscape.getCurrentNetwork());
        String toolTipText = "Select multiple attributes to save. Modify \"Filename\" field to specify filename";
        this.attributeTable = new JTable(this.state);
        this.attributeTable.setToolTipText(toolTipText);
        this.attributeTable.setCellSelectionEnabled(false);
        JButton saveButton = new JButton("Choose Directory and Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser myChooser = new JFileChooser(Cytoscape.getCytoscapeObj().getCurrentDirectory());
                myChooser.setFileSelectionMode(1);
                if (myChooser.showOpenDialog(Cytoscape.getDesktop()) == 0) {
                    AttributeSaverDialog.this.state.setSaveDirectory(myChooser.getSelectedFile());
                    Cytoscape.getCytoscapeObj().setCurrentDirectory(myChooser.getSelectedFile());
                    int count = AttributeSaverDialog.this.state.writeState(AttributeSaverDialog.this.attributeTable.getSelectedRows());
                    JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Successfully saved " + count + " files");
                    AttributeSaverDialog.this.dispose();
                }
            }
        });
        JPanel centerPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.attributeTable);
        scrollPane.setPreferredSize(new Dimension(MAX_PREFERRED_SIZE, MAX_PREFERRED_SIZE));
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(new JLabel("Select multiple attributes to save. Edit table to change filenames"));
        centerPanel.add(scrollPane);
        JPanel southPanel = new JPanel();
        southPanel.add(saveButton);
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)southPanel, "South");
        this.pack();
    }
}

