/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.browsers;

import cytoscape.browsers.BrowserTableModel;
import cytoscape.data.GraphObjAttributes;
import cytoscape.util.Exec;
import cytoscape.util.OpenBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class TabbedBrowser
extends JFrame
implements ClipboardOwner {
    protected Object[] graphObjects;
    protected GraphObjAttributes attributes;
    protected Vector attributeCategoriesToIgnore;
    protected int preferredTableWidth = 600;
    protected int preferredTableHeight = 100;
    protected String webBrowserScript;
    protected JTabbedPane tabbedPane;
    protected Vector customAttributesList;
    protected JTextField customTabNameTextField;
    protected File currentDirectory;
    protected JButton saveButton;
    protected JButton dismissButton;
    protected JPanel customizeTab;
    static HashMap customNodeAttributes = new HashMap();
    static HashMap customEdgeAttributes = new HashMap();
    HashMap customAttributes;
    int browseObjectClass;
    public static final int BROWSING_UNRECOGNIZED_OBJECTS = 0;
    public static final int BROWSING_NODES = 1;
    public static final int BROWSING_EDGES = 2;

    public TabbedBrowser(Object[] graphObjects, GraphObjAttributes attributes, Vector attributeCategoriesToIgnore, String webBrowserScript, int browseObjectClass) {
        this.graphObjects = graphObjects;
        this.attributes = attributes;
        this.attributeCategoriesToIgnore = attributeCategoriesToIgnore;
        this.webBrowserScript = webBrowserScript;
        this.browseObjectClass = browseObjectClass;
        if (browseObjectClass == 1) {
            this.customAttributes = customNodeAttributes;
            this.setTitle("Node Browser");
        } else if (browseObjectClass == 2) {
            this.setTitle("Edge Browser");
            this.customAttributes = customEdgeAttributes;
        } else {
            this.setTitle("Browser of unrecognized objects");
            this.customAttributes = new HashMap();
        }
        String[] attributeNames = attributes.getAttributeNames();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtons(), "South");
        this.getContentPane().add((Component)this.createGui(attributes), "Center");
        this.pack();
        this.placeInCenter();
        this.setVisible(true);
    }

    JTabbedPane createGui(GraphObjAttributes attributes) {
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.addChangeListener(new TabbedPaneListener());
        String[] attributeNames = attributes.getAttributeNames();
        this.customizeTab = this.createCustomizerTab(attributeNames);
        this.tabbedPane.add("Customize", this.customizeTab);
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeCategory;
            String attributeName = attributeNames[i];
            if (attributeName.equalsIgnoreCase("commonName") || this.attributeCategoriesToIgnore.contains(attributeCategory = attributes.getCategory(attributeName))) continue;
            String[] requestedAttibuteNames = new String[]{attributeName};
            BrowserTableModel model = new BrowserTableModel(this.graphObjects, attributes, requestedAttibuteNames);
            JTable table = new JTable(model);
            this.setPreferredColumnWidths(table);
            table.setCellSelectionEnabled(true);
            table.addMouseListener(new MyMouseListener(table));
            table.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
            JScrollPane scrollPane = new JScrollPane(table);
            this.tabbedPane.add(attributeNames[i], scrollPane);
        }
        String[] customTabNames = this.customAttributes.keySet().toArray(new String[0]);
        for (int i = 0; i < customTabNames.length; ++i) {
            String tabName = customTabNames[i];
            Vector attributesInThisTab = (Vector)this.customAttributes.get(tabName);
            this.createNewPanel(attributesInThisTab, tabName);
        }
        return this.tabbedPane;
    }

    protected JPanel createCustomizerTab(String[] attributeNames) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select attributes for custom view"), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        JPanel centerPanel = new JPanel();
        JPanel checkBoxButtonPanel = new JPanel();
        JPanel actionButtonPanel = new JPanel();
        panel.setLayout(new BorderLayout());
        centerPanel.setLayout(new BorderLayout());
        JButton createNewPanelButton = new JButton("Create");
        actionButtonPanel.add(createNewPanelButton);
        createNewPanelButton.addActionListener(new CreateNewPanelAction());
        int count = attributeNames.length;
        int columnCount = 1;
        if (count > 8) {
            columnCount = 2;
        }
        checkBoxButtonPanel.setLayout(new GridLayout(0, columnCount));
        this.customAttributesList = new Vector();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName;
            String attributeCategory;
            if (attributeNames[i].equals("commonName") || this.attributeCategoriesToIgnore.contains(attributeCategory = this.attributes.getCategory(attributeName = attributeNames[i]))) continue;
            JCheckBox button = new JCheckBox(attributeNames[i]);
            checkBoxButtonPanel.add(button);
            button.addItemListener(new CheckBoxListener(attributeNames[i]));
        }
        JCheckBox button = new JCheckBox("canonicalName");
        checkBoxButtonPanel.add(button);
        button.addItemListener(new CheckBoxListener("canonicalName"));
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.add(new JLabel("Name for new tab: "));
        this.customTabNameTextField = new JTextField(10);
        textFieldPanel.add((Component)this.customTabNameTextField, "South");
        centerPanel.add((Component)textFieldPanel, "South");
        centerPanel.add((Component)checkBoxButtonPanel, "Center");
        panel.add((Component)centerPanel, "Center");
        panel.add((Component)actionButtonPanel, "South");
        return panel;
    }

    JPanel createButtons() {
        JPanel panel = new JPanel();
        this.saveButton = new JButton("Save Table");
        this.saveButton.setEnabled(false);
        this.dismissButton = new JButton("Dismiss");
        this.saveButton.addActionListener(new SaveTableAction(this));
        this.dismissButton.addActionListener(new DismissAction(this));
        panel.add((Component)this.saveButton, "Center");
        panel.add((Component)this.dismissButton, "Center");
        return panel;
    }

    private void createNewPanel(Vector customAttributesList, String title) {
        String[] requestedAttributeNames = customAttributesList.toArray(new String[0]);
        BrowserTableModel model = new BrowserTableModel(this.graphObjects, this.attributes, requestedAttributeNames);
        JTable table = new JTable(model);
        this.setPreferredColumnWidths(table);
        table.setCellSelectionEnabled(true);
        table.addMouseListener(new MyMouseListener(table));
        table.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
        JScrollPane scrollPane = new JScrollPane(table);
        this.tabbedPane.add(title, scrollPane);
        this.tabbedPane.setSelectedComponent(scrollPane);
    }

    private void setPreferredColumnWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int numberOfColumns = table.getModel().getColumnCount();
        columnModel.getColumn(0).setPreferredWidth(80);
    }

    private void placeInCenter() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        int screenHeight = (int)gc.getBounds().getHeight();
        int screenWidth = (int)gc.getBounds().getWidth();
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        this.setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2);
    }

    protected void addCellSelection(JTable table) {
        table.setSelectionMode(0);
        table.setCellSelectionEnabled(true);
        ListSelectionModel rowSM = table.getSelectionModel();
        RowListener cellListener = new RowListener(table);
        rowSM.addListSelectionListener(cellListener);
        ListSelectionModel colSM = table.getColumnModel().getSelectionModel();
        colSM.addListSelectionListener(cellListener);
    }

    protected void displayWebPage(URL url) {
        OpenBrowser.openURL(url.toString());
    }

    protected void oldDisplayWebPage(URL url) {
        String[] cmd = new String[]{this.webBrowserScript, url.toString()};
        Exec exec = new Exec(cmd);
        exec.run();
        Vector stdout = exec.getStdout();
        Vector stderr = exec.getStderr();
        for (int i = 0; i < stderr.size(); ++i) {
            System.out.println(stderr.elementAt(i));
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    class MyMouseListener
    implements MouseListener {
        private JTable table;

        public MyMouseListener(JTable table) {
            this.table = table;
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            Object cellValue = this.table.getValueAt(row, column);
            try {
                if (cellValue != null && cellValue.getClass() == Class.forName("java.net.URL")) {
                    URL url = (URL)cellValue;
                    TabbedBrowser.this.displayWebPage(url);
                }
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (TabbedBrowser.this.tabbedPane.getSelectedIndex() == 0) {
                return;
            }
            JScrollPane scrollPane = (JScrollPane)TabbedBrowser.this.tabbedPane.getSelectedComponent();
            JTable table = (JTable)scrollPane.getViewport().getView();
            String clipboardData = new String();
            StringWriter stringWriter = new StringWriter();
            int[] selectedRows = table.getSelectedRows();
            int[] selectedCols = table.getSelectedColumns();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                for (int j = 0; j < selectedCols.length; ++j) {
                    int col = selectedCols[j];
                    Class<?> classType = table.getColumnClass(col);
                    Object data = table.getValueAt(row, col);
                    stringWriter.write(data + "\t");
                }
                stringWriter.write("\n");
            }
            Clipboard clipboard = TabbedBrowser.this.getToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(stringWriter.toString());
            clipboard.setContents(stringSelection, TabbedBrowser.this);
        }
    }

    class RowListener
    implements ListSelectionListener {
        JTable table;
        int selectedRow;
        int selectedColumn;

        RowListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                this.selectedRow = lsm.getMinSelectionIndex();
                Object object = this.table.getModel().getValueAt(this.selectedRow, 0);
            }
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JFrame frame;

        DismissAction(JFrame frame) {
            super("");
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.frame.dispose();
        }
    }

    public class SaveTableAction
    extends AbstractAction {
        private JFrame frame;

        SaveTableAction(JFrame frame) {
            super("");
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (TabbedBrowser.this.tabbedPane.getSelectedIndex() == 0) {
                return;
            }
            JScrollPane scrollPane = (JScrollPane)TabbedBrowser.this.tabbedPane.getSelectedComponent();
            JTable table = (JTable)scrollPane.getViewport().getView();
            int rowCount = table.getRowCount();
            int columnCount = table.getColumnCount();
            JFileChooser chooser = new JFileChooser(TabbedBrowser.this.currentDirectory);
            if (chooser.showSaveDialog(TabbedBrowser.this) == 0) {
                String name = chooser.getSelectedFile().toString();
                TabbedBrowser.this.currentDirectory = chooser.getCurrentDirectory();
                File file = new File(name);
                try {
                    FileWriter fout = new FileWriter(file);
                    for (int row = 0; row < rowCount; ++row) {
                        for (int col = 0; col < columnCount; ++col) {
                            Class<?> classType = table.getColumnClass(col);
                            Object data = table.getValueAt(row, col);
                            fout.write(data + "\t");
                        }
                        fout.write("\n");
                    }
                    fout.close();
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(null, exc.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
                }
            }
        }
    }

    public class CreateNewPanelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (TabbedBrowser.this.customAttributesList == null || TabbedBrowser.this.customAttributesList.size() == 0) {
                return;
            }
            String title = TabbedBrowser.this.customTabNameTextField.getText();
            if (title == null) {
                title = "";
            }
            TabbedBrowser.this.customAttributes.put(title, new Vector(TabbedBrowser.this.customAttributesList));
            TabbedBrowser.this.createNewPanel(TabbedBrowser.this.customAttributesList, title);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        String attributeName;

        CheckBoxListener(String attributeName) {
            this.attributeName = attributeName;
        }

        public void itemStateChanged(ItemEvent e) {
            int state = e.getStateChange();
            if (state == 1) {
                if (!TabbedBrowser.this.customAttributesList.contains(this.attributeName)) {
                    TabbedBrowser.this.customAttributesList.add(this.attributeName);
                }
            } else if (state == 2 && TabbedBrowser.this.customAttributesList.contains(this.attributeName)) {
                TabbedBrowser.this.customAttributesList.remove(this.attributeName);
            }
        }
    }

    class TabbedPaneListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            if (TabbedBrowser.this.customizeTab.equals(TabbedBrowser.this.tabbedPane.getSelectedComponent())) {
                TabbedBrowser.this.saveButton.setEnabled(false);
            } else {
                TabbedBrowser.this.saveButton.setEnabled(true);
            }
        }
    }
}

