/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.browsers;

import cytoscape.data.GraphObjAttributes;
import java.lang.reflect.Array;
import javax.swing.table.AbstractTableModel;

public class BrowserTableModel
extends AbstractTableModel {
    String[] columnNames;
    Object[][] data;
    int[] columnWidths = new int[]{40};
    protected final int defaultColumnWidth = 100;
    protected int preferredTableWidth = 100;

    public BrowserTableModel(Object[] graphObjects, GraphObjAttributes objAttributes, String[] attributeNames) {
        int graphObjectCount = graphObjects.length;
        this.columnNames = new String[attributeNames.length + 1];
        this.columnNames[0] = "Name";
        for (int i = 0; i < attributeNames.length; ++i) {
            this.columnNames[i + 1] = attributeNames[i];
        }
        int numberOfColumns = this.columnNames.length;
        int numberOfRows = this.calculateMaxRowsNeeded(graphObjects, objAttributes, attributeNames);
        this.data = new Object[numberOfRows][numberOfColumns];
        if (objAttributes != null) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.preferredTableWidth += 100;
            }
        }
        String[] canonicalNames = new String[graphObjectCount];
        for (int i = 0; i < graphObjectCount; ++i) {
            canonicalNames[i] = objAttributes.getCanonicalName(graphObjects[i]);
        }
        if (objAttributes != null) {
            int currentRowBase = 0;
            for (int graphObject = 0; graphObject < graphObjects.length; ++graphObject) {
                int maxRowsUsedThisObject = 1;
                String canonicalName = objAttributes.getCanonicalName(graphObjects[graphObject]);
                String commonName = objAttributes.getStringValue("commonName", canonicalName);
                if (commonName == null || commonName.length() == 0) {
                    commonName = canonicalName;
                }
                this.data[currentRowBase][0] = commonName;
                for (int i = 1; i < this.columnNames.length; ++i) {
                    if (this.columnNames[i].equals("canonicalName")) {
                        this.data[currentRowBase][i] = canonicalName;
                        continue;
                    }
                    Object[] attributeValuesThisObject = objAttributes.getArrayValues(this.columnNames[i], canonicalName);
                    int attributeCount = attributeValuesThisObject.length;
                    for (int a = 0; a < attributeCount; ++a) {
                        if (attributeValuesThisObject[a] == null) continue;
                        this.data[currentRowBase + a][i] = attributeValuesThisObject[a];
                    }
                    if (attributeCount <= maxRowsUsedThisObject) continue;
                    maxRowsUsedThisObject = attributeCount;
                }
                currentRowBase += maxRowsUsedThisObject;
            }
        }
    }

    protected int calculateMaxRowsNeeded(Object[] graphObjects, GraphObjAttributes objAttributes, String[] attributeNames) {
        int max = 0;
        for (int graphObject = 0; graphObject < graphObjects.length; ++graphObject) {
            int maxRowsUsedThisObject = 1;
            String canonicalName = objAttributes.getCanonicalName(graphObjects[graphObject]);
            for (int i = 0; i < attributeNames.length; ++i) {
                String attributeName = attributeNames[i];
                int attributeCount = objAttributes.getArrayValues(attributeName, canonicalName).length;
                if (attributeCount <= maxRowsUsedThisObject) continue;
                maxRowsUsedThisObject = attributeCount;
            }
            max += maxRowsUsedThisObject;
        }
        return max;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        Object cellData = this.data[row][col];
        if (cellData != null && cellData.getClass().isArray() && Array.getLength(cellData) > 0) {
            StringBuffer sb = new StringBuffer();
            Object element0 = Array.get(cellData, 0);
            int max = Array.getLength(cellData);
            for (int i = 0; i < max; ++i) {
                sb.append(Array.get(cellData, i).toString());
                if (i >= max - 1) continue;
                sb.append(" | ");
            }
            return sb.toString();
        }
        return this.data[row][col];
    }

    public int getPreferredColumnWidth(int col) {
        if (col >= this.columnWidths.length) {
            return 0;
        }
        return this.columnWidths[col];
    }

    public Class getColumnClass(int column) {
        Object cellValue = this.getValueAt(0, column);
        if (cellValue == null) {
            String s = new String();
            return s.getClass();
        }
        return this.getValueAt(0, column).getClass();
    }
}

