/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;

public class SaveAsInteractionsAction
extends CytoscapeAction {
    public SaveAsInteractionsAction() {
        super("Graph as Interactions...");
        this.setPreferredMenu("File.Save");
    }

    public void actionPerformed(ActionEvent e) {
        File currentDirectory = Cytoscape.getCytoscapeObj().getCurrentDirectory();
        JFileChooser chooser = new JFileChooser(currentDirectory);
        if (chooser.showSaveDialog(Cytoscape.getDesktop()) == 0) {
            String name = chooser.getSelectedFile().toString();
            currentDirectory = chooser.getCurrentDirectory();
            Cytoscape.getCytoscapeObj().setCurrentDirectory(currentDirectory);
            if (!name.endsWith(".sif")) {
                name = name + ".sif";
            }
            GraphObjAttributes nodeAttributes = Cytoscape.getNodeNetworkData();
            GraphObjAttributes edgeAttributes = Cytoscape.getEdgeNetworkData();
            try {
                FileWriter fileWriter = new FileWriter(name);
                String lineSep = System.getProperty("line.separator");
                CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
                List nodeList = networkView.getNetwork().nodesList();
                Node[] nodes = nodeList.toArray(new Node[0]);
                for (int i = 0; i < nodes.length; ++i) {
                    StringBuffer sb = new StringBuffer();
                    Node node = nodes[i];
                    String canonicalName = nodeAttributes.getCanonicalName(node);
                    List edges = networkView.getNetwork().getAdjacentEdgesList(node, true, true, true);
                    if (edges.size() == 0) {
                        sb.append(canonicalName + lineSep);
                    } else {
                        Iterator it = edges.iterator();
                        while (it.hasNext()) {
                            Edge edge = (Edge)it.next();
                            if (node != edge.getSource()) continue;
                            Node target = edge.getTarget();
                            String canonicalTargetName = nodeAttributes.getCanonicalName(target);
                            String edgeName = edgeAttributes.getCanonicalName(edge);
                            String interactionName = (String)edgeAttributes.getValue("interaction", edgeName);
                            if (interactionName == null) {
                                interactionName = "xx";
                            }
                            sb.append(canonicalName);
                            sb.append("\t");
                            sb.append(interactionName);
                            sb.append("\t");
                            sb.append(canonicalTargetName);
                            sb.append(lineSep);
                        }
                    }
                    fileWriter.write(sb.toString());
                }
                fileWriter.close();
            }
            catch (IOException ioe) {
                System.err.println("Error while writing " + name);
                ioe.printStackTrace();
            }
        }
    }
}

