/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CytoscapeObj;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.plugin.jar.JarLoader;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class LoadPluginListAction
extends AbstractAction {
    protected CytoscapeObj cyObj;

    public LoadPluginListAction(CytoscapeObj cyObj) {
        super("Load plugins from list of jar URLs");
        this.cyObj = cyObj;
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public void parsePluginList(String location) {
        try {
            TextHttpReader reader = new TextHttpReader(location);
            reader.read();
            String text = reader.getText();
            String lineSep = System.getProperty("line.separator");
            String[] allLines = text.split(lineSep);
            for (int i = 0; i < allLines.length; ++i) {
                String pluginLoc = allLines[i];
                try {
                    JarLoader.loadJar(pluginLoc);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error loading jar: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing plugin list: " + e.getMessage());
        }
    }
}

