/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.plugin.jar.JarLoader;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public class LoadPluginDirectoryAction
extends CytoscapeAction {
    protected File file;
    protected boolean ready = false;

    public LoadPluginDirectoryAction() {
        super("Load Plugins from Jar Directory");
        this.setPreferredMenu("Plugins");
        this.setAcceleratorCombo(74, 3);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.getDir()) {
            return;
        }
        this.ready = true;
        this.tryDirectory();
    }

    public void setDir(String newFile) {
        try {
            this.file = new File(newFile);
            if (this.file.isDirectory()) {
                this.ready = true;
            } else {
                String s = this.file.getParent();
                this.file = new File(s);
                this.ready = this.file.isDirectory();
            }
        }
        catch (Exception e) {
            System.err.println("Not file: " + newFile + "\n" + e.getMessage());
            this.ready = false;
        }
    }

    public void tryDirectory() {
        if (!this.ready) {
            return;
        }
        String[] fileList = this.file.list();
        String slashString = "";
        if (!this.file.getPath().endsWith("/")) {
            slashString = "/";
        }
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].endsWith(".jar")) continue;
            String jarString = this.file.getPath() + slashString + fileList[i];
            try {
                JarLoader.loadJar(jarString);
                continue;
            }
            catch (Exception e1) {
                System.err.println("Error loading jar: " + e1.getMessage());
            }
        }
    }

    private boolean getDir() {
        JFileChooser fChooser = new JFileChooser(Cytoscape.getCytoscapeObj().getCurrentDirectory());
        fChooser.setDialogTitle("Load Plugin from Jar Directory");
        fChooser.setFileSelectionMode(1);
        switch (fChooser.showOpenDialog(null)) {
            case 0: {
                this.file = fChooser.getSelectedFile();
                Cytoscape.getCytoscapeObj().setCurrentDirectory(this.file);
                return true;
            }
        }
        return false;
    }
}

