/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.plugin.jar.JarLoader;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class LoadPluginAction
extends CytoscapeAction {
    protected File file;

    public LoadPluginAction() {
        super("Load Plugins from Jar File");
        this.setPreferredMenu("Plugins");
        this.setAcceleratorCombo(74, 2);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.getFile()) {
            return;
        }
        String jarString = this.file.getPath();
        System.out.println("Chose: " + jarString);
        try {
            JarLoader.loadJar(jarString);
        }
        catch (Exception e1) {
            System.err.println("Error 1: " + e1.getMessage());
        }
    }

    private boolean getFile() {
        JFileChooser fChooser = new JFileChooser(Cytoscape.getCytoscapeObj().getCurrentDirectory());
        fChooser.setDialogTitle("Load Plugin from Jar");
        switch (fChooser.showOpenDialog(null)) {
            case 0: {
                this.file = fChooser.getSelectedFile();
                try {
                    FileReader fin = new FileReader(this.file);
                    fin.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.toString(), "Error Reading \"" + this.file.getName() + "\"", 0);
                    return false;
                }
                Cytoscape.getCytoscapeObj().setCurrentDirectory(this.file);
                return true;
            }
        }
        return false;
    }
}

