/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.Semantics;
import cytoscape.util.CyFileFilter;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyMenus;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class LoadGraphFileAction
extends CytoscapeAction {
    protected CyMenus windowMenu;

    public LoadGraphFileAction(CyMenus windowMenu) {
        super("Graph...");
        this.setPreferredMenu("File.Load");
        this.setAcceleratorCombo(76, 2);
        this.windowMenu = windowMenu;
    }

    public LoadGraphFileAction(CyMenus windowMenu, boolean label) {
        this.windowMenu = windowMenu;
    }

    public void actionPerformed(ActionEvent e) {
        File currentDirectory = Cytoscape.getCytoscapeObj().getCurrentDirectory();
        JFileChooser chooser = new JFileChooser(currentDirectory);
        boolean appendFlag = false;
        CyFileFilter intFilter = new CyFileFilter();
        CyFileFilter gmlFilter = new CyFileFilter();
        CyFileFilter graphFilter = new CyFileFilter();
        gmlFilter.addExtension("gml");
        gmlFilter.setDescription("GML files");
        intFilter.addExtension("sif");
        intFilter.setDescription("Interaction files");
        graphFilter.addExtension("sif");
        graphFilter.addExtension("gml");
        graphFilter.setDescription("All graph files");
        chooser.addChoosableFileFilter(graphFilter);
        chooser.addChoosableFileFilter(intFilter);
        chooser.addChoosableFileFilter(gmlFilter);
        chooser.setFileFilter(graphFilter);
        if (chooser.showOpenDialog(Cytoscape.getDesktop()) == 0) {
            String extension;
            currentDirectory = chooser.getCurrentDirectory();
            Cytoscape.getCytoscapeObj().setCurrentDirectory(currentDirectory);
            String name = chooser.getSelectedFile().toString();
            int fileType = Cytoscape.FILE_SIF;
            if (name.length() > 4 && (extension = name.substring(name.length() - 3)).equalsIgnoreCase("gml")) {
                fileType = Cytoscape.FILE_GML;
            }
            boolean canonicalize = Semantics.getCanonicalize(Cytoscape.getCytoscapeObj());
            String species = Semantics.getDefaultSpecies(Cytoscape.getCurrentNetwork(), Cytoscape.getCytoscapeObj());
            Cytoscape.setSpecies();
            int root_nodes = Cytoscape.getRootGraph().getNodeCount();
            int root_edges = Cytoscape.getRootGraph().getEdgeCount();
            CyNetwork newNetwork = Cytoscape.createNetwork(name, fileType, canonicalize, Cytoscape.getCytoscapeObj().getBioDataServer(), species);
            if (newNetwork != null) {
                int nn = Cytoscape.getRootGraph().getNodeCount() - root_nodes;
                int ne = Cytoscape.getRootGraph().getEdgeCount() - root_edges;
                StringBuffer sb = new StringBuffer();
                String lineSep = System.getProperty("line.separator");
                sb.append("Succesfully loaded graph from " + name + lineSep);
                sb.append("Graph contains " + newNetwork.getNodeCount());
                sb.append(" nodes and " + newNetwork.getEdgeCount());
                sb.append(" edges." + lineSep);
                sb.append("There were " + nn + " unique nodes, and " + ne + " unique edges." + lineSep + lineSep);
                if (newNetwork.getNodeCount() < Cytoscape.getCytoscapeObj().getViewThreshold()) {
                    sb.append("Your Network is Under " + Cytoscape.getCytoscapeObj().getViewThreshold() + " nodes, a View  will be automatically created.");
                } else {
                    sb.append("Your Network is Over nodes " + Cytoscape.getCytoscapeObj().getViewThreshold() + ", a View  will be not be created." + lineSep + "If you wish to view this Network use \"Create View\" from the \"Edit\" menu.");
                }
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), sb.toString(), "Load graph successful", 1);
            } else {
                String lineSep = System.getProperty("line.separator");
                StringBuffer sb = new StringBuffer();
                sb.append("Could not read graph from file " + name + lineSep);
                sb.append("This file may not be a valid GML or SIF file." + lineSep);
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), sb.toString(), "Error loading graph", 0);
            }
        }
        this.windowMenu.setNodesRequiredItemsEnabled();
    }
}

