/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.Semantics;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ListFromFileSelectionAction
extends CytoscapeAction {
    public ListFromFileSelectionAction() {
        super("From File...");
        this.setPreferredMenu("Select.Nodes");
    }

    public void actionPerformed(ActionEvent e) {
        boolean cancelSelectionAction = !this.selectFromFile();
    }

    private boolean selectFromFile() {
        File currentDirectory = Cytoscape.getCytoscapeObj().getCurrentDirectory();
        JFileChooser fChooser = new JFileChooser(currentDirectory);
        fChooser.setDialogTitle("Load Gene Selection File");
        switch (fChooser.showOpenDialog(Cytoscape.getDesktop())) {
            case 0: {
                File file = fChooser.getSelectedFile();
                currentDirectory = fChooser.getCurrentDirectory();
                Cytoscape.getCytoscapeObj().setCurrentDirectory(currentDirectory);
                CyNetwork network = Cytoscape.getCurrentNetworkView().getNetwork();
                try {
                    String s;
                    FileReader fin = new FileReader(file);
                    BufferedReader bin = new BufferedReader(fin);
                    ArrayList<String> fileNodes = new ArrayList<String>();
                    while ((s = bin.readLine()) != null) {
                        String trimName = s.trim();
                        if (trimName.length() <= 0) continue;
                        fileNodes.add(trimName);
                    }
                    fin.close();
                    List nodeList = network.nodesList();
                    Node[] nodes = nodeList.toArray(new Node[0]);
                    for (int i = 0; i < nodes.length; ++i) {
                        Node node = nodes[i];
                        boolean select = false;
                        String canonicalName = network.getNodeAttributes().getCanonicalName(node);
                        List synonyms = Semantics.getAllSynonyms(canonicalName, network, Cytoscape.getCytoscapeObj());
                        Iterator synI = synonyms.iterator();
                        while (synI.hasNext()) {
                            if (!fileNodes.contains((String)synI.next())) continue;
                            select = true;
                            break;
                        }
                        if (!select) continue;
                        CyNetworkView view = Cytoscape.getCurrentNetworkView();
                        NodeView nv = view.getNodeView(node.getRootGraphIndex());
                        nv.setSelected(true);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.toString(), "Error Reading \"" + file.getName() + "\"", 0);
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

