/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.HashSet;
import java.util.Iterator;

public class GinyUtils {
    public static void hideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getSelectedNodes().iterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            view.hideGraphObject(nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true, true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    view.hideGraphObject(view.getEdgeView(edges[j]));
                }
            }
        }
    }

    public static void unHideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getSelectedNodes().iterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            view.showGraphObject(nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true, true);
                for (int j = 0; j < edges.length; ++j) {
                    view.showGraphObject(view.getEdgeView(edges[j]));
                }
            }
        }
    }

    public static void unHideAll(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            view.showGraphObject(nview);
        }
        Iterator ei = view.getEdgeViewsList().iterator();
        while (ei.hasNext()) {
            EdgeView eview = (EdgeView)ei.next();
            view.showGraphObject(eview);
        }
    }

    public static void unHideNodesAndInterconnectingEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            Node n = nview.getNode();
            view.showGraphObject(nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    EdgeView ev = view.getEdgeView(edges[j]);
                    view.showGraphObject(ev);
                }
            }
        }
    }

    public static void hideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getSelectedEdges().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            view.hideGraphObject(eview);
        }
    }

    public static void unHideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getSelectedEdges().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            view.showGraphObject(eview);
        }
    }

    public static void invertSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview;
            nview.setSelected(!(nview = (NodeView)i.next()).isSelected());
        }
    }

    public static void invertSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview;
            eview.setSelected(!(eview = (EdgeView)i.next()).isSelected());
        }
    }

    public static void selectFirstNeighbors(GraphView view) {
        NodeView nview;
        if (view == null) {
            return;
        }
        GraphPerspective graphPerspective = view.getGraphPerspective();
        HashSet<NodeView> nodeViewsToSelect = new HashSet<NodeView>();
        Iterator i = view.getSelectedNodes().iterator();
        while (i.hasNext()) {
            nview = (NodeView)i.next();
            Node n = nview.getNode();
            Iterator ni = graphPerspective.neighborsList(n).iterator();
            while (ni.hasNext()) {
                Node neib = (Node)ni.next();
                NodeView neibview = view.getNodeView(neib);
                nodeViewsToSelect.add(neibview);
            }
        }
        Iterator si = nodeViewsToSelect.iterator();
        while (si.hasNext()) {
            nview = (NodeView)si.next();
            nview.setSelected(true);
        }
    }

    public static void selectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(true);
        }
    }

    public static void deselectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(false);
        }
    }

    public static void selectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            eview.setSelected(true);
        }
    }

    public static void deselectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            eview.setSelected(false);
        }
    }

    public static void hideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            view.hideGraphObject(eview);
        }
    }

    public static void unHideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview = (EdgeView)i.next();
            view.showGraphObject(eview);
        }
    }
}

