/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.data.GraphObjAttributes;
import cytoscape.dialogs.GinyEdgeControlDialog;
import cytoscape.view.NetworkView;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class EdgeManipulationAction
extends AbstractAction {
    NetworkView networkView;

    public EdgeManipulationAction(NetworkView networkView) {
        super("Edge select or hide by attributes...");
        this.networkView = networkView;
    }

    public void actionPerformed(ActionEvent e) {
        GraphObjAttributes edgeAttributes = this.networkView.getNetwork().getEdgeAttributes();
        String[] edgeAttributeNames = edgeAttributes.getAttributeNames();
        HashMap<String, String[]> attributesTree = new HashMap<String, String[]>();
        for (int i = 0; i < edgeAttributeNames.length; ++i) {
            String name = edgeAttributeNames[i];
            if (edgeAttributes.getClass(name) != "string".getClass()) continue;
            String[] uniqueNames = edgeAttributes.getUniqueStringValues(name);
            attributesTree.put(name, uniqueNames);
        }
        if (attributesTree.size() > 0) {
            GinyEdgeControlDialog dialog = new GinyEdgeControlDialog(this.networkView, attributesTree, "Edge Selection Control");
            dialog.pack();
            dialog.setLocationRelativeTo(this.networkView.getMainFrame());
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(null, "There are no String edge attributes suitable for controlling edge display");
        }
    }
}

