/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.browsers.TabbedBrowser;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.Misc;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DisplayBrowserAction
extends CytoscapeAction {
    Vector attributeCategoriesToIgnore;
    static final String invisibilityPropertyName = "nodeAttributeCategories.invisibleToBrowser";
    String webBrowserScript;

    public DisplayBrowserAction() {
        super("Display attribute browser");
        this.setPreferredMenu("Data");
        this.setAcceleratorCombo(116, 0);
        Properties configProps = Cytoscape.getCytoscapeObj().getConfiguration().getProperties();
        this.webBrowserScript = configProps.getProperty("webBrowserScript", "noScriptDefined");
        this.attributeCategoriesToIgnore = Misc.getPropertyValues(configProps, invisibilityPropertyName);
        for (int i = 0; i < this.attributeCategoriesToIgnore.size(); ++i) {
            System.out.println("  ignore type " + this.attributeCategoriesToIgnore.get(i));
        }
    }

    public void actionPerformed(ActionEvent ev) {
        List nvlist = Cytoscape.getCurrentNetworkView().getSelectedNodes();
        ArrayList<Node> nodeList = new ArrayList<Node>(nvlist.size());
        Iterator ni = nvlist.iterator();
        while (ni.hasNext()) {
            NodeView nview = (NodeView)ni.next();
            Node n = nview.getNode();
            nodeList.add(n);
        }
        Object[] selectedNodes = nodeList.toArray(new Node[0]);
        List evList = Cytoscape.getCurrentNetworkView().getSelectedEdges();
        ArrayList<Edge> edgeList = new ArrayList<Edge>(evList.size());
        Iterator ei = evList.iterator();
        while (ei.hasNext()) {
            EdgeView eview = (EdgeView)ei.next();
            Edge e = eview.getEdge();
            edgeList.add(e);
        }
        Object[] selectedEdges = edgeList.toArray(new Edge[0]);
        TabbedBrowser nodeBrowser = null;
        TabbedBrowser edgeBrowser = null;
        if (selectedNodes.length == 0 && selectedEdges.length == 0) {
            JOptionPane.showMessageDialog(null, "No selected nodes or edges", "Error", 0);
        }
        if (selectedNodes.length > 0) {
            nodeBrowser = new TabbedBrowser(selectedNodes, Cytoscape.getNodeNetworkData(), this.attributeCategoriesToIgnore, this.webBrowserScript, 1);
        }
        if (selectedEdges.length > 0) {
            edgeBrowser = new TabbedBrowser(selectedEdges, Cytoscape.getEdgeNetworkData(), this.attributeCategoriesToIgnore, this.webBrowserScript, 2);
        }
    }
}

