/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.SwingUtilities;

public class BackgroundColorAction
extends CytoscapeAction {
    public BackgroundColorAction() {
        super("Change Background Color");
        this.setPreferredMenu("Visualization");
        this.setAcceleratorCombo(66, 8);
    }

    public void actionPerformed(ActionEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JColorChooser color = new JColorChooser();
                Color newPaint = JColorChooser.showDialog(Cytoscape.getCurrentNetworkView().getComponent(), "Choose a Background Color", (Color)Cytoscape.getCurrentNetworkView().getBackgroundPaint());
                Cytoscape.getCurrentNetworkView().setBackgroundPaint(newPaint);
                BackgroundColorAction.this.synchronizeVisualStyle(newPaint);
            }
        });
    }

    private void synchronizeVisualStyle(Color newColor) {
        VisualMappingManager vmm = Cytoscape.getCurrentNetworkView().getVizMapManager();
        VisualStyle style = vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = style.getGlobalAppearanceCalculator();
        gCalc.setDefaultBackgroundColor(newColor);
    }
}

