/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.CyNetworkUtilities;
import cytoscape.util.CytoscapeAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AlphabeticalSelectionAction
extends CytoscapeAction
implements ActionListener {
    JDialog dialog;
    JButton search;
    JButton cancel;
    JTextField searchField;

    public AlphabeticalSelectionAction() {
        super("By Name...");
        this.setPreferredMenu("Select.Nodes");
        this.setAcceleratorCombo(70, 2);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.dialog.setVisible(false);
            return;
        }
        if (e.getSource() == this.searchField || e.getSource() == this.search) {
            String search_string = this.searchField.getText();
            CyNetworkUtilities.selectNodesStartingWith(Cytoscape.getCurrentNetwork(), search_string, Cytoscape.getCytoscapeObj(), Cytoscape.getCurrentNetworkView());
            return;
        }
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.setVisible(true);
    }

    private JDialog createDialog() {
        this.dialog = new JDialog(Cytoscape.getDesktop(), "Select Nodes By Name", false);
        JPanel main_panel = new JPanel();
        main_panel.setLayout(new BorderLayout());
        JLabel label = new JLabel("<HTML>Select nodes whose <B>name or synonym</B> is like <small>(use \"*\" and \"?\" for wildcards)</small></HTML>");
        main_panel.add((Component)label, "North");
        this.searchField = new JTextField(30);
        this.searchField.addActionListener(this);
        main_panel.add((Component)this.searchField, "Center");
        JPanel button_panel = new JPanel();
        this.search = new JButton("Search");
        this.cancel = new JButton("Cancel");
        this.search.addActionListener(this);
        this.cancel.addActionListener(this);
        button_panel.add(this.search);
        button_panel.add(this.cancel);
        main_panel.add((Component)button_panel, "South");
        this.dialog.setContentPane(main_panel);
        this.dialog.pack();
        return this.dialog;
    }
}

