/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyMain;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeConfig;
import cytoscape.data.servers.BioDataServer;
import cytoscape.plugin.JarLoaderCommandLineParser;
import cytoscape.plugin.PluginLoader;
import cytoscape.plugin.PluginRegistry;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorCatalogFactory;
import cytoscape.visual.CalculatorIO;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;

public class CytoscapeObj
implements PropertyChangeListener {
    protected CyMain parentApp;
    protected CytoscapeConfig config;
    protected Logger logger;
    protected BioDataServer bioDataServer;
    protected PluginRegistry pluginRegistry;
    protected static CalculatorCatalog calculatorCatalog;
    protected File currentDirectory;
    protected long lastPluginRegistryUpdate;
    protected int viewThreshold;
    protected String defaultVisualStyle;

    public CytoscapeObj(CytoscapeConfig config) {
        this(null, config, null, null);
    }

    public CytoscapeObj(CyMain parentApp, CytoscapeConfig config, Logger logger, BioDataServer bioDataServer) {
        this.parentApp = parentApp;
        this.config = config;
        this.logger = logger == null ? Logger.getLogger("global") : logger;
        this.bioDataServer = bioDataServer;
        if (config.getBioDataDirectory() != null && bioDataServer == null) {
            try {
                this.bioDataServer = new BioDataServer(config.getBioDataDirectory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pluginRegistry = new PluginRegistry();
        Cytoscape.setCytoscapeObj(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.registerCommandLinePlugins();
        this.loadCalculatorCatalog();
        this.currentDirectory = new File(System.getProperty("user.dir"));
    }

    public void registerCommandLinePlugins() {
        JarLoaderCommandLineParser parser = new JarLoaderCommandLineParser(this);
        parser.parseArgs(this.config.getArgs());
        this.logger.info(parser.getMessages());
        PluginLoader pluginLoader = new PluginLoader(this);
        pluginLoader.load(this.config.getProperties());
        this.logger.info(pluginLoader.getMessages());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.CYTOSCAPE_EXIT) {
            this.saveCalculatorCatalog();
        }
    }

    public int getViewThreshold() {
        return this.viewThreshold;
    }

    public void setViewThreshold(int v) {
        this.viewThreshold = v;
    }

    public String getDefaultVisualStyle() {
        return this.config.getDefaultVisualStyle();
    }

    public File getConfigDirectoy() {
        Object dir = null;
        try {
            File parent_dir = new File(System.getProperty("user.home"), ".cytoscape");
            if (parent_dir.mkdir()) {
                System.err.println("Parent_Dir: " + parent_dir + " created.");
            }
            return parent_dir;
        }
        catch (Exception e) {
            System.err.println("error getting config directory");
            return null;
        }
    }

    public File getConfigFile(String file_name) {
        try {
            File parent_dir = this.getConfigDirectoy();
            File file = new File(parent_dir, file_name);
            if (file.createNewFile()) {
                System.err.println("Config file: " + file + " created.");
            }
            return file;
        }
        catch (Exception e) {
            System.err.println("error getting config file:" + file_name);
            return null;
        }
    }

    public CyMain getParentApp() {
        return this.parentApp;
    }

    public CytoscapeConfig getConfiguration() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public BioDataServer getBioDataServer() {
        return this.bioDataServer;
    }

    public void setBioDataServer(BioDataServer newServer) {
        this.bioDataServer = newServer;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void loadCalculatorCatalog() {
        if (calculatorCatalog == null) {
            calculatorCatalog = CalculatorCatalogFactory.loadCalculatorCatalog(this.getConfiguration());
        }
    }

    public void saveCalculatorCatalog() {
        File userHomePropsFile = this.getConfigFile("vizmap.props");
        CalculatorIO.storeCatalog(calculatorCatalog, userHomePropsFile);
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return calculatorCatalog;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File newDirectory) {
        this.currentDirectory = newDirectory;
    }
}

