/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.Cytoscape;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.view.CytoscapeDesktop;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CytoscapeConfig
implements PropertyChangeListener {
    protected String argSpecificationString = "n:j:g:b:i:y:he:vWs:l:p:xc:t:;";
    protected String[] commandLineArguments;
    protected String[] argsCopy;
    protected boolean canonicalize = true;
    protected boolean helpRequested = false;
    protected boolean inputsError = false;
    protected boolean displayVersion = false;
    protected List geometryFilenames = null;
    protected String bioDataDirectory = null;
    protected String expressionFilename = null;
    protected String projectFilename = null;
    protected List interactionsFilenames = null;
    protected Vector nodeAttributeFilenames = new Vector();
    protected Vector edgeAttributeFilenames = new Vector();
    protected String defaultSpeciesName = null;
    protected String projectPropsFileName = null;
    protected String projectVizmapPropsFileName = null;
    protected File projectFileDirectoryAbsolute;
    protected boolean enableUndo = false;
    protected boolean copyExpToAttribs = true;
    protected boolean yfiles = true;
    protected String graphLibrary = null;
    protected String viewType = "tabbed";
    public String defaultVisualStyle = "default";
    protected String[] layoutStrategies = new String[]{"organic", "hierarchical", "embedded", "circular"};
    protected String defaultLayoutStrategy = this.layoutStrategies[0];
    protected StringBuffer errorMessages = new StringBuffer();
    protected Properties props;
    protected Integer viewThreshold;
    protected boolean loadUserClasspath = false;
    public static StringBuffer debugLog = new StringBuffer();

    public CytoscapeConfig(String[] args) {
        this.commandLineArguments = new String[args.length];
        System.arraycopy(args, 0, this.commandLineArguments, 0, args.length);
        this.argsCopy = new String[args.length];
        System.arraycopy(args, 0, this.argsCopy, 0, args.length);
        this.props = this.readProperties();
        this.loadProperties();
        this.parseArgs();
        this.getConfigurationsFromProperties();
        System.out.println("config properties:");
        System.out.println(this.props);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(Cytoscape.CYTOSCAPE_EXIT, this);
    }

    public String[] getArgs() {
        String[] returnVal = new String[this.argsCopy.length];
        System.arraycopy(this.argsCopy, 0, returnVal, 0, this.argsCopy.length);
        return returnVal;
    }

    public boolean getLoadUserClasspath() {
        return this.loadUserClasspath;
    }

    public String getDefaultVisualStyle() {
        return this.defaultVisualStyle;
    }

    public int getViewThreshold() {
        if (this.viewThreshold == null) {
            return 500;
        }
        return this.viewThreshold;
    }

    public int getViewType() {
        if (this.viewType.equals("tabbed")) {
            return CytoscapeDesktop.TABBED_VIEW;
        }
        if (this.viewType.equals("internal")) {
            return CytoscapeDesktop.INTERNAL_VIEW;
        }
        if (this.viewType.equals("external")) {
            return CytoscapeDesktop.EXTERNAL_VIEW;
        }
        return CytoscapeDesktop.TABBED_VIEW;
    }

    public List getGeometryFilenames() {
        if (this.geometryFilenames == null) {
            this.geometryFilenames = new ArrayList(0);
        }
        return this.geometryFilenames;
    }

    public List getInteractionsFilenames() {
        if (this.interactionsFilenames == null) {
            this.interactionsFilenames = new ArrayList(0);
        }
        return this.interactionsFilenames;
    }

    public String getExpressionFilename() {
        return this.expressionFilename;
    }

    public String getProjectFilename() {
        return this.projectFilename;
    }

    public String getProjectVizmapPropsFileName() {
        return this.projectVizmapPropsFileName;
    }

    public String getBioDataDirectory() {
        return this.bioDataDirectory;
    }

    public int getNumberOfNodeAttributeFiles() {
        return this.nodeAttributeFilenames.size();
    }

    public int getNumberOfEdgeAttributeFiles() {
        return this.edgeAttributeFilenames.size();
    }

    public String[] getNodeAttributeFilenames() {
        return this.nodeAttributeFilenames.toArray(new String[0]);
    }

    public String[] getEdgeAttributeFilenames() {
        return this.edgeAttributeFilenames.toArray(new String[0]);
    }

    public boolean getCanonicalize() {
        return this.canonicalize;
    }

    public boolean isYFiles() {
        return false;
    }

    public void addGeometryFilename(String filename) {
        if (this.geometryFilenames == null) {
            this.geometryFilenames = new ArrayList();
        }
        this.geometryFilenames.add(filename);
    }

    public void addInteractionsFilename(String filename) {
        if (this.interactionsFilenames == null) {
            this.interactionsFilenames = new ArrayList();
        }
        this.interactionsFilenames.add(filename);
    }

    public void addNodeAttributeFilename(String filename) {
        if (!this.nodeAttributeFilenames.contains(filename)) {
            this.nodeAttributeFilenames.add(filename);
        }
    }

    public void addEdgeAttributeFilename(String filename) {
        if (!this.edgeAttributeFilenames.contains(filename)) {
            this.edgeAttributeFilenames.add(filename);
        }
    }

    public String[] getAllDataFileNames() {
        Vector<String> allFileNames = new Vector<String>();
        String[] nodeAttributeFiles = this.getNodeAttributeFilenames();
        String[] edgeAttributeFiles = this.getEdgeAttributeFilenames();
        for (int n = 0; n < nodeAttributeFiles.length; ++n) {
            allFileNames.add(nodeAttributeFiles[n]);
        }
        for (int e = 0; e < edgeAttributeFiles.length; ++e) {
            allFileNames.add(edgeAttributeFiles[e]);
        }
        if (this.geometryFilenames != null) {
            allFileNames.addAll(this.geometryFilenames);
        }
        if (this.interactionsFilenames != null) {
            allFileNames.addAll(this.interactionsFilenames);
        }
        if (this.expressionFilename != null) {
            allFileNames.add(this.expressionFilename);
        }
        return allFileNames.toArray(new String[0]);
    }

    public String[] getAllDataFileExtensions() {
        String[] fullNames = this.getAllDataFileNames();
        Vector<String> allExtensions = new Vector<String>();
        for (int i = 0; i < fullNames.length; ++i) {
            String extension;
            String filename = fullNames[i];
            int positionOfLastDot = filename.lastIndexOf(".");
            if (positionOfLastDot <= 0 || allExtensions.contains(extension = filename.substring(positionOfLastDot + 1))) continue;
            allExtensions.add(extension);
        }
        return allExtensions.toArray(new String[0]);
    }

    public String getDefaultSpeciesName() {
        return this.defaultSpeciesName;
    }

    public String getDefaultLayoutStrategy() {
        return this.defaultLayoutStrategy;
    }

    public boolean helpRequested() {
        return this.helpRequested;
    }

    public boolean inputsError() {
        return this.inputsError;
    }

    public boolean displayVersion() {
        return this.displayVersion;
    }

    public boolean enableUndo() {
        return this.enableUndo;
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean getWhetherToCopyExpToAttribs() {
        return this.copyExpToAttribs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.CYTOSCAPE_EXIT) {
            this.saveProperties();
        }
    }

    protected void saveProperties() {
        if (this.defaultSpeciesName != null) {
            this.props.setProperty("defaultSpeciesName", this.defaultSpeciesName);
        }
        if (this.viewType != null) {
            this.props.setProperty("viewType", this.viewType);
        }
        if (this.viewThreshold != null) {
            this.props.setProperty("viewThreshold", this.viewThreshold.toString());
        }
        if (this.bioDataDirectory != null) {
            this.props.setProperty("bioDataDirectory", this.bioDataDirectory);
        }
        if (this.defaultVisualStyle != null) {
            this.props.setProperty("defaultVisualStyle", Cytoscape.getDesktop().getVizMapManager().getVisualStyle().getName());
        }
        try {
            File file = Cytoscape.getCytoscapeObj().getConfigFile("cytoscape.props");
            FileOutputStream output = new FileOutputStream(file);
            this.props.store(output, "Cytoscape Property File");
        }
        catch (Exception ex) {
            System.out.println("Cytoscape.Props Write error");
            ex.printStackTrace();
        }
    }

    protected void loadProperties() {
        this.viewThreshold = new Integer(this.props.getProperty("viewThreshold", "500"));
        this.viewType = this.props.getProperty("viewType", "tabbed");
        this.defaultSpeciesName = this.props.getProperty("defaultSpeciesName", "unknown");
        this.bioDataDirectory = this.props.getProperty("bioDataDirectory", "testData/annotation/manifest");
        this.defaultVisualStyle = this.props.getProperty("defaultVisualStyle", "default");
    }

    protected Properties readProperties() {
        File userSpecialPropsFile;
        Properties systemProps = null;
        Properties userSpecialProps = null;
        Object projectProps = null;
        Properties defaultProps = null;
        String propsFileName = "cytoscape.props";
        File defaultPropsFile = this.getConfigFile("cytoscape.props");
        try {
            defaultProps = new Properties();
            defaultProps.load(new FileInputStream(defaultPropsFile));
        }
        catch (Exception e) {
            // empty catch block
        }
        File propsFile = this.createFile(System.getProperty("CYTOSCAPE_HOME"), propsFileName);
        if (propsFile != null) {
            systemProps = this.readOnePropertyFile(defaultProps, propsFile);
        }
        if ((userSpecialPropsFile = this.createFile(System.getProperty("user.dir"), propsFileName)) != null) {
            userSpecialProps = this.readOnePropertyFile(systemProps, userSpecialPropsFile);
        }
        Properties fullProps = new Properties();
        if (defaultProps != null) {
            fullProps.putAll((Map<?, ?>)defaultProps);
        }
        if (systemProps != null) {
            fullProps.putAll((Map<?, ?>)systemProps);
        }
        if (userSpecialProps != null) {
            fullProps.putAll((Map<?, ?>)userSpecialProps);
        }
        return fullProps;
    }

    public File getConfigDirectoy() {
        Object dir = null;
        try {
            File parent_dir = new File(System.getProperty("user.home"), ".cytoscape");
            if (parent_dir.mkdir()) {
                System.err.println("Parent_Dir: " + parent_dir + " created.");
            }
            return parent_dir;
        }
        catch (Exception e) {
            System.err.println("error getting config directory");
            return null;
        }
    }

    public File getConfigFile(String file_name) {
        try {
            File parent_dir = this.getConfigDirectoy();
            File file = new File(parent_dir, file_name);
            if (file.createNewFile()) {
                System.err.println("Config file: " + file + " created.");
            }
            return file;
        }
        catch (Exception e) {
            System.err.println("error getting config file:" + file_name);
            return null;
        }
    }

    public Properties readPropertyFileAsText(String filename) {
        String rawText = "";
        debugLog.append("CC.readPropertyFileAsText, path: " + filename + "\n");
        try {
            if (filename.trim().startsWith("jar://")) {
                debugLog.append("CC.readPropertyFileAsText, starts with jar://\n");
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                rawText = reader.getText();
                debugLog.append("from jar, rawText:\n" + rawText + "\n");
            } else {
                debugLog.append("CC.readPropertyFileAsText, does not start with jar://\n");
                File projectPropsFile = new File(this.absolutizeFilename(this.projectFileDirectoryAbsolute, filename));
                TextFileReader reader = new TextFileReader(projectPropsFile.getPath());
                reader.read();
                rawText = reader.getText();
                debugLog.append("from file, rawText:\n" + rawText + "\n");
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading properties file " + filename);
            System.err.println(e0.getMessage());
        }
        byte[] byteText = rawText.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(byteText);
        Properties newProps = new Properties();
        try {
            newProps.load(is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return newProps;
    }

    private File createFile(String directory, String filename) {
        File result;
        if (directory != null && (result = new File(directory, filename)).canRead()) {
            return result;
        }
        return null;
    }

    private Properties readOnePropertyFile(Properties priorProps, File propsFile) {
        Properties newProps = new Properties();
        if (priorProps != null) {
            newProps = new Properties(priorProps);
        }
        try {
            FileInputStream in = new FileInputStream(propsFile);
            newProps.load(in);
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return newProps;
    }

    protected void parseArgs() {
        int c;
        this.helpRequested = false;
        boolean argsError = false;
        if (this.commandLineArguments == null || this.commandLineArguments.length == 0) {
            return;
        }
        LongOpt[] longopts = new LongOpt[]{new LongOpt("VT", 1, null, 0), new LongOpt("classpath", 1, null, 1), new LongOpt("VS", 1, null, 2)};
        Getopt g = new Getopt("cytoscape", this.commandLineArguments, this.argSpecificationString, longopts);
        g.setOpterr(false);
        block21: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: {
                    this.viewThreshold = new Integer(g.getOptarg());
                    continue block21;
                }
                case 1: {
                    this.loadUserClasspath = true;
                    continue block21;
                }
                case 2: {
                    this.defaultVisualStyle = g.getOptarg();
                    this.props.setProperty("defaultVisualStyle", this.defaultVisualStyle);
                    continue block21;
                }
                case 116: {
                    this.viewType = g.getOptarg();
                    continue block21;
                }
                case 110: {
                    this.nodeAttributeFilenames.add(g.getOptarg());
                    continue block21;
                }
                case 106: {
                    this.edgeAttributeFilenames.add(g.getOptarg());
                    continue block21;
                }
                case 103: {
                    this.addGeometryFilename(g.getOptarg());
                    continue block21;
                }
                case 98: {
                    this.bioDataDirectory = g.getOptarg();
                    continue block21;
                }
                case 105: {
                    this.addInteractionsFilename(g.getOptarg());
                    continue block21;
                }
                case 108: {
                    this.defaultLayoutStrategy = g.getOptarg();
                    continue block21;
                }
                case 101: {
                    this.expressionFilename = g.getOptarg();
                    continue block21;
                }
                case 104: {
                    this.helpRequested = true;
                    continue block21;
                }
                case 112: {
                    this.projectFilename = g.getOptarg();
                    this.readProjectFile();
                    continue block21;
                }
                case 115: {
                    this.defaultSpeciesName = g.getOptarg();
                    continue block21;
                }
                case 120: {
                    this.copyExpToAttribs = false;
                    continue block21;
                }
                case 118: {
                    this.displayVersion = true;
                    continue block21;
                }
                case 121: {
                    this.graphLibrary = g.getOptarg();
                    if (this.graphLibrary == "y-files") continue block21;
                    this.yfiles = false;
                    continue block21;
                }
                case 99: {
                    this.canonicalize = false;
                    continue block21;
                }
                case 63: {
                    int theOption = g.getOptopt();
                    if (theOption == 0) continue block21;
                    this.errorMessages.append("The option '" + (char)theOption + "' is not valid\n");
                    continue block21;
                }
            }
            this.errorMessages.append("unexpected argument: " + c + "\n");
            this.inputsError = true;
        }
        if (!this.inputsError) {
            this.inputsError = !this.legalArguments();
        }
    }

    protected void getConfigurationsFromProperties() {
        this.defaultLayoutStrategy = this.props.getProperty("defaultLayoutStrategy", this.defaultLayoutStrategy);
        String undoString = this.props.getProperty("enableUndo");
        if (undoString != null) {
            this.enableUndo = Boolean.valueOf(undoString);
        }
    }

    protected void readProjectFile() {
        int i;
        String rawText;
        if (this.projectFilename == null) {
            return;
        }
        boolean readingFromJar = false;
        try {
            if (this.projectFilename.trim().startsWith("jar://")) {
                readingFromJar = true;
                TextJarReader reader = new TextJarReader(this.projectFilename);
                reader.read();
                rawText = reader.getText();
            } else {
                File projectFile = new File(this.projectFilename);
                TextFileReader reader = new TextFileReader(projectFile.getPath());
                reader.read();
                rawText = reader.getText();
                this.projectFileDirectoryAbsolute = projectFile.getAbsoluteFile().getParentFile();
            }
        }
        catch (Exception e0) {
            throw new IllegalArgumentException("cannot read project file: " + this.projectFilename);
        }
        String[] lines = rawText.split("\n");
        String[] sifFiles = this.parseProjectFileText(lines, "sif");
        String[] gmlFiles = this.parseProjectFileText(lines, "gml");
        String[] noaFiles = this.parseProjectFileText(lines, "noa");
        String[] edaFiles = this.parseProjectFileText(lines, "eda");
        String[] exprFiles = this.parseProjectFileText(lines, "expr");
        String[] dataServers = this.parseProjectFileText(lines, "dataServer");
        String[] speciesEntries = this.parseProjectFileText(lines, "species");
        String[] defaultLayouts = this.parseProjectFileText(lines, "layout");
        String[] propsFiles = this.parseProjectFileText(lines, "props");
        String[] vizmapPropsFiles = this.parseProjectFileText(lines, "vprops");
        String[] canonicalization = this.parseProjectFileText(lines, "canonicalizeNames");
        String[] otherArgs = this.parseProjectFileText(lines, "arg");
        String[] graphMode = this.parseProjectFileText(lines, "graphMode");
        for (i = 0; i < sifFiles.length; ++i) {
            if (readingFromJar) {
                this.addInteractionsFilename(sifFiles[i]);
                continue;
            }
            this.addInteractionsFilename(this.absolutizeFilename(this.projectFileDirectoryAbsolute, sifFiles[i]));
        }
        for (i = 0; i < gmlFiles.length; ++i) {
            if (readingFromJar) {
                this.addGeometryFilename(gmlFiles[i]);
                continue;
            }
            this.addGeometryFilename(this.absolutizeFilename(this.projectFileDirectoryAbsolute, gmlFiles[i]));
        }
        if (exprFiles.length >= 1) {
            this.expressionFilename = readingFromJar ? exprFiles[0] : this.absolutizeFilename(this.projectFileDirectoryAbsolute, exprFiles[0]);
        }
        for (i = 0; i < noaFiles.length; ++i) {
            if (readingFromJar) {
                this.nodeAttributeFilenames.add(noaFiles[i]);
                continue;
            }
            this.nodeAttributeFilenames.add(this.absolutizeFilename(this.projectFileDirectoryAbsolute, noaFiles[i]));
        }
        for (i = 0; i < edaFiles.length; ++i) {
            if (readingFromJar) {
                this.edgeAttributeFilenames.add(edaFiles[i]);
                continue;
            }
            this.edgeAttributeFilenames.add(this.absolutizeFilename(this.projectFileDirectoryAbsolute, edaFiles[i]));
        }
        if (dataServers.length >= 1) {
            String tmp;
            String bioDir = tmp = dataServers[0];
            if (!(tmp.startsWith("rmi://") || tmp.startsWith("jar://") || tmp.startsWith("http://"))) {
                bioDir = this.absolutizeFilename(this.projectFileDirectoryAbsolute, tmp);
            }
            this.props.put("bioDataDirectory", bioDir);
        }
        if (speciesEntries.length > 0) {
            this.props.put("defaultSpeciesName", speciesEntries[0]);
        }
        if (defaultLayouts.length > 0) {
            this.defaultLayoutStrategy = defaultLayouts[0];
        }
        debugLog.append("config.readProjectFile, propsFile count: " + propsFiles.length + "\n");
        if (propsFiles.length >= 1) {
            this.projectPropsFileName = propsFiles[0];
            Properties projectProps = this.readPropertyFileAsText(this.projectPropsFileName);
            this.props.putAll((Map<?, ?>)projectProps);
            debugLog.append("config.readProjectFile, propsPropsFileName: " + this.projectPropsFileName + "\n");
        }
        debugLog.append("config.readProjectFile, vizmapPropsFile count: " + vizmapPropsFiles.length + "\n");
        if (vizmapPropsFiles.length >= 1) {
            this.projectVizmapPropsFileName = vizmapPropsFiles[0];
            debugLog.append("config.readProjectFile, vizmapPropsFileName: " + this.projectVizmapPropsFileName + "\n");
        }
        if (canonicalization.length > 0) {
            String canValue = canonicalization[0];
            if (canValue.equals("yes")) {
                this.canonicalize = true;
            } else if (canValue.equals("no")) {
                this.canonicalize = false;
            }
        }
        if (graphMode.length > 0) {
            String graph = graphMode[0];
            if (graph.equals("giny")) {
                this.yfiles = false;
            } else if (graph.equals("y-files")) {
                this.yfiles = true;
            }
        }
        if (otherArgs.length > 0) {
            int lenOld = this.argsCopy.length;
            int lenOther = otherArgs.length;
            int lenNew = lenOld + lenOther;
            String[] argsCopy2 = new String[lenOld];
            System.arraycopy(this.argsCopy, 0, argsCopy2, 0, lenOld);
            this.argsCopy = new String[lenNew];
            System.arraycopy(argsCopy2, 0, this.argsCopy, 0, lenOld);
            System.arraycopy(otherArgs, 0, this.argsCopy, lenOld, lenOther);
        }
    }

    protected String absolutizeFilename(File parentDirectory, String filename) {
        if (filename.trim().startsWith("/")) {
            return filename;
        }
        return new File(parentDirectory, filename).getPath();
    }

    protected String[] parseProjectFileText(String[] lines, String key) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(key)) continue;
            String fileToRead = line.substring(line.indexOf("=") + 1);
            list.add(fileToRead.trim());
        }
        return list.toArray(new String[0]);
    }

    protected boolean legalArguments() {
        boolean legal = true;
        boolean illegalLayoutSelected = true;
        for (int i = 0; i < this.layoutStrategies.length; ++i) {
            if (!this.defaultLayoutStrategy.equals(this.layoutStrategies[i])) continue;
            illegalLayoutSelected = false;
            break;
        }
        legal = legal && !illegalLayoutSelected;
        return legal;
    }

    public String getErrorMessages() {
        return this.errorMessages.toString();
    }

    public String getUsage() {
        StringBuffer sb = new StringBuffer();
        String programName = "cytoscape";
        sb.append("usage: ");
        sb.append(programName);
        sb.append(" [optional arguments]");
        sb.append("\n\n");
        sb.append("\n      optional arguments\n");
        sb.append("      ------------------\n\n");
        sb.append("--multiple parameters allowed--\n");
        sb.append(" -g  <graph file names>        :  \".gml\" or \".sif\")\n");
        sb.append(" -i  <interactions filenames>  :  will load any file as a \".sif\", i.e. a \".txt\"\n");
        sb.append(" -n  <nodeAttributes filename> :  of the \"name = value\" style\n");
        sb.append(" -j  <edgeAttributes filename> :  of the \"source ('type') target = value\" style\n");
        sb.append("\n--single parameter only--\n");
        sb.append(" -e  <expression filename>     : \".mrna\" or \".mtx\"\n");
        sb.append("                                 (this is the ouput of mergeConds\n");
        sb.append(" -x  : causes Cytoscape not to copy expression to attribs)\n");
        sb.append(" -c  : suppresses automatic canonicalization of node names in input graph files\n");
        sb.append("\n--single parameter only, stored on use--\n");
        sb.append(" -b  <bioData directory>       :   \"annotaion/manifest\"\n");
        sb.append(" -s  <default species name>    :   \"Saccharomyces cerevisiae\"\n");
        sb.append("\n");
        sb.append(" -h  (display usage)\n");
        sb.append(" -v  (display version)\n");
        return sb.toString();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("---------- requested options:\n");
        sb.append("            geometry files: " + this.geometryFilenames + "\n");
        sb.append("        interactions files: " + this.interactionsFilenames + "\n");
        sb.append("          expression file: " + this.expressionFilename + "\n");
        sb.append("         bioDataDirectory: " + this.bioDataDirectory + "\n");
        sb.append("       defaultSpeciesName: " + this.defaultSpeciesName + "\n");
        sb.append("    defaultLayoutStrategy: " + this.defaultLayoutStrategy + "\n");
        sb.append(" graphLibrary: " + this.graphLibrary + "\n");
        for (i = 0; i < this.nodeAttributeFilenames.size(); ++i) {
            sb.append("        nodeAttributeFile: " + (String)this.nodeAttributeFilenames.get(i) + "\n");
        }
        for (i = 0; i < this.edgeAttributeFilenames.size(); ++i) {
            sb.append("        edgeAttributeFile: " + (String)this.edgeAttributeFilenames.get(i) + "\n");
        }
        return sb.toString();
    }
}

