/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CyProject;
import cytoscape.CytoscapeConfig;
import cytoscape.CytoscapeObj;
import cytoscape.data.ExpressionData;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.Semantics;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.giny.PhoebeNetworkView;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import giny.model.Edge;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class Cytoscape {
    public static String NETWORK_CREATED = "NETWORK_CREATED";
    public static String ATTRIBUTES_ADDED = "ATTRIBUTES_ADDED";
    public static String NETWORK_DESTROYED = "NETWORK_DESTROYED";
    public static String CYTOSCAPE_EXIT = "CYTOSCAPE_EXIT";
    public static int FILE_BY_SUFFIX = 0;
    public static int FILE_GML = 1;
    public static int FILE_SIF = 2;
    public static int FILE_SBML = 3;
    private static BioDataServer bioDataServer;
    private static String species;
    protected static CytoscapeRootGraph cytoscapeRootGraph;
    protected static GraphObjAttributes nodeData;
    protected static GraphObjAttributes edgeData;
    protected static ExpressionData expressionData;
    protected static Object pcsO;
    protected static SwingPropertyChangeSupport pcs;
    protected static Map networkViewMap;
    protected static Map networkMap;
    protected static CytoscapeDesktop defaultDesktop;
    protected static String currentNetworkID;
    protected static String currentNetworkViewID;
    protected static CyNetwork nullNetwork;
    protected static CyNetworkView nullNetworkView;
    protected static CytoscapeObj cytoscapeobj;

    public static CytoscapeObj getCytoscapeObj() {
        if (cytoscapeobj == null) {
            cytoscapeobj = new CytoscapeObj(new CytoscapeConfig(new String[0]));
        }
        return cytoscapeobj;
    }

    public static void setCytoscapeObj(CytoscapeObj obj) {
        cytoscapeobj = obj;
    }

    public static void exit() {
        System.out.println("Cytoscape Exiting....");
        try {
            Cytoscape.firePropertyChange(CYTOSCAPE_EXIT, null, "now");
        }
        catch (Exception e) {
            System.out.println("Errors on close, closed anyways.");
        }
        if (Cytoscape.getCytoscapeObj().getParentApp() != null) {
            Cytoscape.getCytoscapeObj().getParentApp().exit(0);
        } else {
            System.exit(0);
        }
    }

    public static SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return pcs;
    }

    public static CytoscapeRootGraph getRootGraph() {
        if (cytoscapeRootGraph == null) {
            cytoscapeRootGraph = new CytoscapeRootGraph();
        }
        return cytoscapeRootGraph;
    }

    public static void ensureCapacity(int nodes, int edges) {
    }

    public static void clearCytoscape() {
        int[] edges = Cytoscape.getRootGraph().getEdgeIndicesArray();
        if (edges != null) {
            Cytoscape.getRootGraph().removeEdges(Cytoscape.getRootGraph().getEdgeIndicesArray());
        }
        Cytoscape.getRootGraph().removeNodes(Cytoscape.getRootGraph().getNodeIndicesArray());
        nodeData = new GraphObjAttributes();
        edgeData = new GraphObjAttributes();
    }

    public static List getCyNodesList() {
        return Cytoscape.getRootGraph().nodesList();
    }

    public static List getCyEdgesList() {
        return Cytoscape.getRootGraph().edgesList();
    }

    public static CyNode getCyNode(String alias) {
        return Cytoscape.getCyNode(alias, false);
    }

    public static CyNode getCyNode(String alias, boolean create) {
        String old_name = alias;
        alias = Cytoscape.canonicalizeName(alias);
        CyNode node = (CyNode)Cytoscape.getNodeNetworkData().getGraphObject(alias);
        if (node != null) {
            return node;
        }
        if (!create) {
            return null;
        }
        node = (CyNode)Cytoscape.getRootGraph().getNode(Cytoscape.getRootGraph().createNode());
        node.setIdentifier(alias);
        Cytoscape.getNodeNetworkData().addNameMapping(alias, node);
        Semantics.assignNodeAliases(node, null, null);
        return node;
    }

    public static CyEdge getCyEdge(Node node_1, Node node_2, String attribute, Object attribute_value, boolean create) {
        HashSet edges = new HashSet();
        if (Cytoscape.getRootGraph().getEdgeCount() != 0) {
            List l2;
            List l1 = Cytoscape.getRootGraph().edgesList(node_1, node_2);
            if (l1 != null) {
                edges.addAll(l1);
            }
            if ((l2 = Cytoscape.getRootGraph().edgesList(node_2, node_1)) != null) {
                edges.addAll(l2);
            }
            Iterator i = edges.iterator();
            while (i.hasNext()) {
                CyEdge edge = (CyEdge)i.next();
                if (Cytoscape.getEdgeAttributeValue(edge, attribute) != attribute_value) continue;
                return edge;
            }
        }
        if (!create) {
            return null;
        }
        if (attribute == "interaction") {
            CyEdge edge = (CyEdge)Cytoscape.getRootGraph().getEdge(Cytoscape.getRootGraph().createEdge(node_1, node_2));
            String edge_name = node_1.getIdentifier() + " (" + attribute_value + ") " + node_2.getIdentifier();
            Cytoscape.getEdgeNetworkData().add("interaction", edge_name, attribute_value);
            Cytoscape.getEdgeNetworkData().addNameMapping(edge_name, edge);
            return edge;
        }
        return null;
    }

    public static CyEdge getCyEdge(String source_alias, String edge_name, String target_alias, String interaction_type) {
        edge_name = Cytoscape.canonicalizeName(edge_name);
        CyEdge edge = (CyEdge)Cytoscape.getEdgeNetworkData().getGraphObject(edge_name);
        if (edge != null) {
            return edge;
        }
        CyNode source = Cytoscape.getCyNode(source_alias);
        CyNode target = Cytoscape.getCyNode(target_alias);
        edge = (CyEdge)Cytoscape.getRootGraph().getEdge(Cytoscape.getRootGraph().createEdge(source, target));
        Cytoscape.getEdgeNetworkData().add("interaction", edge_name, interaction_type);
        Cytoscape.getEdgeNetworkData().addNameMapping(edge_name, edge);
        return edge;
    }

    public static Object getNodeAttributeValue(Node node, String attribute) {
        return Cytoscape.getNodeNetworkData().get(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(node));
    }

    public static Object getEdgeAttributeValue(Edge edge, String attribute) {
        return Cytoscape.getEdgeNetworkData().get(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(edge));
    }

    public static String[] getNodeAttributesList() {
        return Cytoscape.getNodeNetworkData().getAttributeNames();
    }

    public static String[] getNodeAttributesList(Node[] nodes) {
        return Cytoscape.getNodeNetworkData().getAttributeNames();
    }

    public static String[] getEdgeAttributesList() {
        return Cytoscape.getEdgeNetworkData().getAttributeNames();
    }

    public static String[] getNodeAttributesList(Edge[] edges) {
        return Cytoscape.getEdgeNetworkData().getAttributeNames();
    }

    public static boolean setNodeAttributeValue(Node node, String attribute, Object value) {
        return Cytoscape.getNodeNetworkData().set(attribute, Cytoscape.getNodeNetworkData().getCanonicalName(node), value);
    }

    public static boolean setEdgeAttributeValue(Edge edge, String attribute, Object value) {
        return Cytoscape.getEdgeNetworkData().set(attribute, Cytoscape.getEdgeNetworkData().getCanonicalName(edge), value);
    }

    private static String canonicalizeName(String name) {
        String canonicalName = name;
        if (bioDataServer != null && (canonicalName = bioDataServer.getCanonicalName(species, name)) == null) {
            canonicalName = name;
        }
        return canonicalName;
    }

    public static void setSpecies() {
        species = Semantics.getDefaultSpecies(Cytoscape.getCurrentNetwork(), Cytoscape.getCytoscapeObj());
    }

    public static CyNetwork getCurrentNetwork() {
        if (currentNetworkID == null) {
            return nullNetwork;
        }
        CyNetwork network = (CyNetwork)Cytoscape.getNetworkMap().get(currentNetworkID);
        return network;
    }

    public static Set getNetworkSet() {
        return Cytoscape.getNetworkMap().keySet();
    }

    public static CyNetwork getNetwork(String id) {
        if (Cytoscape.getNetworkMap().containsKey(id)) {
            return (CyNetwork)Cytoscape.getNetworkMap().get(id);
        }
        return nullNetwork;
    }

    public static CyNetworkView getNetworkView(String network_id) {
        if (network_id == null) {
            return nullNetworkView;
        }
        CyNetworkView nview = (CyNetworkView)Cytoscape.getNetworkViewMap().get(network_id);
        return nview;
    }

    public static boolean viewExists(String network_id) {
        return Cytoscape.getNetworkViewMap().containsKey(network_id);
    }

    public static CyNetworkView getCurrentNetworkView() {
        if (currentNetworkViewID == null) {
            return nullNetworkView;
        }
        CyNetworkView nview = (CyNetworkView)Cytoscape.getNetworkViewMap().get(currentNetworkViewID);
        return nview;
    }

    public static CytoscapeDesktop getDesktop() {
        if (defaultDesktop == null) {
            defaultDesktop = new CytoscapeDesktop(Cytoscape.getCytoscapeObj().getConfiguration().getViewType());
        }
        return defaultDesktop;
    }

    public static void setCurrentNetwork(String id) {
        if (Cytoscape.getNetworkMap().containsKey(id)) {
            currentNetworkID = id;
        }
    }

    public static boolean setCurrentNetworkView(String id) {
        if (Cytoscape.getNetworkViewMap().containsKey(id)) {
            currentNetworkViewID = id;
            return true;
        }
        return false;
    }

    protected static Map getNetworkMap() {
        if (networkMap == null) {
            networkMap = new HashMap();
        }
        return networkMap;
    }

    protected static Map getNetworkViewMap() {
        if (networkViewMap == null) {
            networkViewMap = new HashMap();
        }
        return networkViewMap;
    }

    public static void destroyNetwork(String network_id) {
        Cytoscape.destroyNetwork((CyNetwork)Cytoscape.getNetworkMap().get(network_id));
    }

    public static void destroyNetwork(CyNetwork network) {
        Cytoscape.destroyNetwork(network, false);
    }

    public static void destroyNetwork(CyNetwork network, boolean destroy_unique) {
        Cytoscape.getNetworkMap().remove(network.getIdentifier());
        if (Cytoscape.viewExists(network.getIdentifier())) {
            Cytoscape.destroyNetworkView(network);
        }
        Cytoscape.firePropertyChange(NETWORK_DESTROYED, null, network.getIdentifier());
        if (destroy_unique) {
            Iterator n_i;
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Edge> edges = new ArrayList<Edge>();
            Set networks = networkMap.entrySet();
            Iterator nodes_i = network.nodesIterator();
            Iterator edges_i = network.edgesIterator();
            while (nodes_i.hasNext()) {
                n_i = networks.iterator();
                while (n_i.hasNext()) {
                    Node node = (Node)nodes_i.next();
                    if (((CyNetwork)((Object)n_i.next())).containsNode(node)) continue;
                    nodes.add(node);
                }
            }
            while (edges_i.hasNext()) {
                n_i = networks.iterator();
                while (n_i.hasNext()) {
                    Edge edge = (Edge)edges_i.next();
                    if (((CyNetwork)((Object)n_i.next())).containsEdge(edge)) continue;
                    edges.add(edge);
                }
            }
            Cytoscape.getRootGraph().removeNodes(nodes);
            Cytoscape.getRootGraph().removeEdges(edges);
        }
        network = null;
    }

    public static void destroyNetworkView(CyNetworkView view) {
        Cytoscape.getNetworkViewMap().remove(view.getIdentifier());
        Cytoscape.firePropertyChange(CytoscapeDesktop.NETWORK_VIEW_DESTROYED, null, view);
        view = null;
        System.gc();
    }

    public static void destroyNetworkView(String network_view_id) {
        Cytoscape.destroyNetworkView((CyNetworkView)Cytoscape.getNetworkViewMap().get(network_view_id));
    }

    public static void destroyNetworkView(CyNetwork network) {
        Cytoscape.destroyNetworkView((CyNetworkView)Cytoscape.getNetworkViewMap().get(network.getIdentifier()));
    }

    protected static void addNetwork(CyNetwork network) {
        Cytoscape.addNetwork(network, null, null);
    }

    protected static void addNetwork(CyNetwork network, String title) {
        Cytoscape.addNetwork(network, title, null);
    }

    protected static void addNetwork(CyNetwork network, String title, CyNetwork parent) {
        Cytoscape.getNetworkMap().put(network.getIdentifier(), network);
        network.setTitle(title);
        String p_id = null;
        if (parent != null) {
            p_id = parent.getIdentifier();
        }
        Cytoscape.firePropertyChange(NETWORK_CREATED, p_id, network.getIdentifier());
        System.out.println("GML data is: " + network.getClientData("GML"));
        if (network.getNodeCount() < Cytoscape.getCytoscapeObj().getViewThreshold()) {
            Cytoscape.createNetworkView(network);
        }
    }

    public static CyNetwork createNetwork(String title) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(new int[0], new int[0]);
        Cytoscape.addNetwork(network, title);
        return network;
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String title) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, title);
        return network;
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String title) {
        Node[] node_array = nodes.toArray(new Node[0]);
        Edge[] edge_array = edges.toArray(new Edge[0]);
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(node_array, edge_array);
        Cytoscape.addNetwork(network, title);
        return network;
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String child_title, CyNetwork parent) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, child_title, parent);
        return network;
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String child_title, CyNetwork parent) {
        Node[] node_array = nodes.toArray(new Node[0]);
        Edge[] edge_array = edges.toArray(new Edge[0]);
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(node_array, edge_array);
        Cytoscape.addNetwork(network, child_title, parent);
        return network;
    }

    public static CyNetwork createNetworkFromFile(String location) {
        return Cytoscape.createNetwork(location, FILE_BY_SUFFIX, false, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static CyNetwork createNetwork(String location, int file_type, boolean canonicalize, BioDataServer biodataserver, String species) {
        void var5_5;
        GraphReader reader;
        if (location == null) {
            return null;
        }
        if (file_type == FILE_SIF || file_type == FILE_BY_SUFFIX && location.endsWith("sif")) {
            reader = new InteractionsReader(biodataserver, species, location);
        } else if (file_type == FILE_GML || file_type == FILE_BY_SUFFIX && location.endsWith("gml")) {
            reader = new GMLReader(location);
        } else {
            System.err.println("File Type not Supported, sorry");
            return Cytoscape.createNetwork(null);
        }
        try {
            var5_5.read();
        }
        catch (Exception e) {
            System.err.println("Cytoscape: Error Reading Graph File: " + location + "\n--------------------\n");
            e.printStackTrace();
            return null;
        }
        int[] nodes = var5_5.getNodeIndicesArray();
        int[] edges = var5_5.getEdgeIndicesArray();
        if (nodes == null) {
            System.err.println("reader returned null nodes");
        }
        if (edges == null) {
            System.err.println("reader returned null edges");
        }
        String[] title = location.split("/");
        if (System.getProperty("os.name").startsWith("Win")) {
            title = location.split("//");
        }
        CyNetwork network = Cytoscape.createNetwork(nodes, edges, title[title.length - 1]);
        if (file_type == FILE_GML || file_type == FILE_BY_SUFFIX && location.endsWith("gml")) {
            System.out.println("GML file gettign reader: " + title[title.length - 1]);
            network.putClientData("GML", var5_5);
        }
        System.out.println("NV: " + Cytoscape.getNetworkView(network.getIdentifier()));
        if (Cytoscape.getNetworkView(network.getIdentifier()) != null) {
            var5_5.layout(Cytoscape.getNetworkView(network.getIdentifier()));
        }
        return network;
    }

    public static GraphObjAttributes getNodeNetworkData() {
        if (nodeData == null) {
            nodeData = new GraphObjAttributes();
        }
        return nodeData;
    }

    public static GraphObjAttributes getEdgeNetworkData() {
        if (edgeData == null) {
            edgeData = new GraphObjAttributes();
        }
        return edgeData;
    }

    public static ExpressionData getExpressionData() {
        return expressionData;
    }

    public static boolean loadExpressionData(String filename, boolean copy_atts) {
        try {
            expressionData = new ExpressionData(filename);
        }
        catch (Exception e) {
            System.err.println("Unable to Load Expression Data");
            String errString = "Unable to load expression data from " + filename;
            String title = "Load Expression Data";
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), errString, title, 0);
            return false;
        }
        if (copy_atts) {
            expressionData.copyToAttribs(Cytoscape.getNodeNetworkData());
        }
        String expDescript = expressionData.getDescription();
        String title = "Load Expression Data";
        JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript, title, -1);
        return true;
    }

    public static void loadAttributes(String[] nodeAttrLocations, String[] edgeAttrLocations, boolean canonicalize, BioDataServer bioDataServer, String species) {
        if (nodeAttrLocations != null) {
            for (int i = 0; i < nodeAttrLocations.length; ++i) {
                try {
                    nodeData.readAttributesFromFile(bioDataServer, species, nodeAttrLocations[i], canonicalize);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error loading attributes into NodeData");
                }
            }
        }
        if (edgeAttrLocations != null) {
            for (int j = 0; j < edgeAttrLocations.length; ++j) {
                try {
                    edgeData.readAttributesFromFile(edgeAttrLocations[j]);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error loading attributes into EdgeData");
                }
            }
        }
        Cytoscape.firePropertyChange(ATTRIBUTES_ADDED, null, null);
    }

    public static void loadAttributes(String[] nodeAttrLocations, String[] edgeAttrLocations) {
        Cytoscape.loadAttributes(nodeAttrLocations, edgeAttrLocations, false, null, null);
    }

    public static CyNetwork createNetworkFromProject(CyProject project, BioDataServer bioDataServer) {
        String filename;
        if (project == null) {
            return null;
        }
        boolean canonicalize = project.getCanonicalize();
        String species = project.getDefaultSpeciesName();
        CyNetwork network = null;
        if (project.getInteractionsFilename() != null) {
            filename = project.getInteractionsFilename();
            network = Cytoscape.createNetwork(filename, FILE_SIF, canonicalize, bioDataServer, species);
        } else if (project.getGeometryFilename() != null) {
            filename = project.getGeometryFilename();
            network = Cytoscape.createNetwork(filename, FILE_GML, false, null, null);
        }
        if (network == null) {
            network = Cytoscape.createNetwork(null);
        }
        String[] nodeAttributeFilenames = project.getNodeAttributeFilenames();
        String[] edgeAttributeFilenames = project.getEdgeAttributeFilenames();
        Cytoscape.loadAttributes(nodeAttributeFilenames, edgeAttributeFilenames, canonicalize, bioDataServer, species);
        Cytoscape.loadExpressionData(project.getExpressionFilename(), true);
        return network;
    }

    public static BioDataServer loadBioDataServer(String location) {
        System.out.println("laod BDS: " + location);
        try {
            bioDataServer = new BioDataServer(location);
            Cytoscape.getCytoscapeObj().setBioDataServer(bioDataServer);
        }
        catch (Exception e) {
            String es = "cannot create new biodata server at " + location;
            Cytoscape.getCytoscapeObj().getLogger().warning(es);
            return null;
        }
        return bioDataServer;
    }

    public static CyNetworkView createNetworkView(CyNetwork network) {
        return Cytoscape.createNetworkView(network, network.getTitle());
    }

    public static CyNetworkView createNetworkView(CyNetwork network, String title) {
        if (network == nullNetwork) {
            return nullNetworkView;
        }
        System.out.println("Creating View from: " + network.getIdentifier() + " : " + network.getIdentifier());
        if (Cytoscape.viewExists(network.getIdentifier())) {
            return Cytoscape.getNetworkView(network.getIdentifier());
        }
        System.out.println("Nodes: " + network.getNodeCount() + " | Edges: " + network.getEdgeCount());
        PhoebeNetworkView view = new PhoebeNetworkView(network, title);
        view.setIdentifier(network.getIdentifier());
        Cytoscape.getNetworkViewMap().put(network.getIdentifier(), view);
        view.setTitle(network.getTitle());
        if (network.getClientData("GML") != null) {
            ((GraphReader)network.getClientData("GML")).layout(view);
            System.out.println("GML data found for: " + network.getTitle() + " " + network.getClientData("GML"));
        }
        Cytoscape.firePropertyChange(CytoscapeDesktop.NETWORK_VIEW_CREATED, null, view);
        view.fitContent();
        view.redrawGraph(false, false);
        return view;
    }

    protected static void firePropertyChange(String property_type, Object old_value, Object new_value) {
        PropertyChangeEvent e = new PropertyChangeEvent(pcsO, property_type, old_value, new_value);
        Cytoscape.getSwingPropertyChangeSupport().firePropertyChange(e);
    }

    static {
        pcsO = new Object();
        pcs = new SwingPropertyChangeSupport(pcsO);
        nullNetwork = Cytoscape.getRootGraph().createNetwork(new int[0], new int[0]);
        nullNetworkView = new PhoebeNetworkView(nullNetwork, "null");
    }
}

