/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class CyProject {
    protected String projectFilename = null;
    protected String interactionsFilename = null;
    protected String geometryFilename = null;
    protected String expressionFilename = null;
    protected List nodeAttributeFilenames = new Vector();
    protected List edgeAttributeFilenames = new Vector();
    protected String bioDataDirectory = null;
    protected String defaultSpeciesName = null;
    protected String[] layoutStrategies = new String[]{"organic", "hierarchical", "embedded", "circular"};
    protected String defaultLayoutStrategy = this.layoutStrategies[0];
    protected String projectPropsFileName = null;
    protected String projectVizmapPropsFileName = null;
    protected boolean canonicalize = true;
    protected String[] otherArgs;

    public CyProject(String fileLocation) {
        this.readProjectFile(fileLocation);
    }

    public String getProjectFilename() {
        return this.projectFilename;
    }

    public String getInteractionsFilename() {
        return this.interactionsFilename;
    }

    public String getGeometryFilename() {
        return this.geometryFilename;
    }

    public String getExpressionFilename() {
        return this.expressionFilename;
    }

    public int getNumberOfNodeAttributeFiles() {
        return this.nodeAttributeFilenames.size();
    }

    public int getNumberOfEdgeAttributeFiles() {
        return this.edgeAttributeFilenames.size();
    }

    public String[] getNodeAttributeFilenames() {
        return this.nodeAttributeFilenames.toArray(new String[0]);
    }

    public String[] getEdgeAttributeFilenames() {
        return this.edgeAttributeFilenames.toArray(new String[0]);
    }

    public String getBioDataDirectory() {
        return this.bioDataDirectory;
    }

    public String getDefaultSpeciesName() {
        return this.defaultSpeciesName;
    }

    public String getDefaultLayoutStrategy() {
        return this.defaultLayoutStrategy;
    }

    public String getProjectPropsFileName() {
        return this.projectPropsFileName;
    }

    public String getProjectVizmapPropsFileName() {
        return this.projectVizmapPropsFileName;
    }

    public boolean getCanonicalize() {
        return this.canonicalize;
    }

    public String[] getOtherArgs() {
        return this.otherArgs;
    }

    protected void readProjectFile(String fileLocation) {
        int i;
        String rawText;
        boolean readingFromJar = false;
        File projectFileDirectoryAbsolute = null;
        try {
            if (fileLocation.trim().startsWith("jar://")) {
                readingFromJar = true;
                TextJarReader reader = new TextJarReader(this.projectFilename);
                reader.read();
                rawText = reader.getText();
            } else {
                File projectFile = new File(fileLocation);
                TextFileReader reader = new TextFileReader(projectFile.getPath());
                reader.read();
                rawText = reader.getText();
                projectFileDirectoryAbsolute = projectFile.getAbsoluteFile().getParentFile();
            }
        }
        catch (Exception e0) {
            throw new IllegalArgumentException("cannot read project file: " + this.projectFilename);
        }
        this.projectFilename = fileLocation;
        String[] lines = rawText.split("\n");
        String[] sifFiles = this.parseProjectFileText(lines, "sif");
        String[] gmlFiles = this.parseProjectFileText(lines, "gml");
        String[] noaFiles = this.parseProjectFileText(lines, "noa");
        String[] edaFiles = this.parseProjectFileText(lines, "eda");
        String[] exprFiles = this.parseProjectFileText(lines, "expr");
        String[] dataServers = this.parseProjectFileText(lines, "dataServer");
        String[] speciesEntries = this.parseProjectFileText(lines, "species");
        String[] defaultLayouts = this.parseProjectFileText(lines, "layout");
        String[] propsFiles = this.parseProjectFileText(lines, "props");
        String[] vizmapPropsFiles = this.parseProjectFileText(lines, "vprops");
        String[] canonicalization = this.parseProjectFileText(lines, "canonicalizeNames");
        String[] otherArgs = this.parseProjectFileText(lines, "arg");
        if (sifFiles.length >= 1) {
            this.interactionsFilename = readingFromJar ? sifFiles[0] : this.absolutizeFilename(projectFileDirectoryAbsolute, sifFiles[0]);
        }
        if (gmlFiles.length >= 1) {
            this.geometryFilename = readingFromJar ? gmlFiles[0] : this.absolutizeFilename(projectFileDirectoryAbsolute, gmlFiles[0]);
        }
        if (exprFiles.length >= 1) {
            this.expressionFilename = readingFromJar ? exprFiles[0] : this.absolutizeFilename(projectFileDirectoryAbsolute, exprFiles[0]);
        }
        for (i = 0; i < noaFiles.length; ++i) {
            if (readingFromJar) {
                this.nodeAttributeFilenames.add(noaFiles[i]);
                continue;
            }
            this.nodeAttributeFilenames.add(this.absolutizeFilename(projectFileDirectoryAbsolute, noaFiles[i]));
        }
        for (i = 0; i < edaFiles.length; ++i) {
            if (readingFromJar) {
                this.edgeAttributeFilenames.add(edaFiles[i]);
                continue;
            }
            this.edgeAttributeFilenames.add(this.absolutizeFilename(projectFileDirectoryAbsolute, edaFiles[i]));
        }
        if (dataServers.length >= 1) {
            String tmp = dataServers[0];
            this.bioDataDirectory = !tmp.startsWith("rmi://") && !tmp.startsWith("jar://") ? this.absolutizeFilename(projectFileDirectoryAbsolute, tmp) : tmp;
        }
        if (speciesEntries.length > 0) {
            this.defaultSpeciesName = speciesEntries[0];
        }
        if (defaultLayouts.length > 0) {
            this.defaultLayoutStrategy = defaultLayouts[0];
        }
        if (propsFiles.length >= 1) {
            this.projectPropsFileName = propsFiles[0];
        }
        if (vizmapPropsFiles.length >= 1) {
            this.projectVizmapPropsFileName = vizmapPropsFiles[0];
        }
        if (canonicalization.length > 0) {
            String canValue = canonicalization[0];
            if (canValue.equals("yes")) {
                this.canonicalize = true;
            } else if (canValue.equals("no")) {
                this.canonicalize = false;
            }
        }
        this.otherArgs = otherArgs;
    }

    protected String absolutizeFilename(File parentDirectory, String filename) {
        if (filename.trim().startsWith("/")) {
            return filename;
        }
        return new File(parentDirectory, filename).getPath();
    }

    protected String[] parseProjectFileText(String[] lines, String key) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(key)) continue;
            String fileToRead = line.substring(line.indexOf("=") + 1);
            list.add(fileToRead.trim());
        }
        return list.toArray(new String[0]);
    }
}

