/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.Options;
import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;
import com.jgoodies.plaf.plastic.theme.ExperienceBlue;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeConfig;
import cytoscape.CytoscapeObj;
import cytoscape.CytoscapeVersion;
import cytoscape.data.Semantics;
import cytoscape.data.servers.BioDataServer;
import cytoscape.util.shadegrown.WindowUtilities;
import cytoscape.view.CyWindow;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class CyMain
implements WindowListener {
    protected Vector windows = new Vector();
    protected CyWindow cyWindow;
    protected CytoscapeVersion version = new CytoscapeVersion();
    protected Logger logger;

    public CyMain(String[] args) throws Exception {
        CyNetwork network;
        ImageIcon image = new ImageIcon(this.getClass().getResource("/cytoscape/images/CytoscapeSplashScreen.png"));
        WindowUtilities.showSplash(image, 8000);
        CytoscapeConfig config = new CytoscapeConfig(args);
        if (config.helpRequested()) {
            this.displayHelp(config);
        } else if (config.inputsError()) {
            this.inputError(config);
        } else if (config.displayVersion()) {
            this.displayHelp(config);
        }
        this.setupLogger(config);
        this.logger.info(config.toString());
        CytoscapeObj cytoscapeObj = new CytoscapeObj(this, config, this.logger, null);
        Cytoscape.setCytoscapeObj(cytoscapeObj);
        BioDataServer bioDataServer = Cytoscape.getCytoscapeObj().getBioDataServer();
        cytoscapeObj.setViewThreshold(config.getViewThreshold());
        boolean canonicalize = Semantics.getCanonicalize(cytoscapeObj);
        String defaultSpecies = Semantics.getDefaultSpecies(null, cytoscapeObj);
        Cytoscape.getDesktop();
        Cytoscape.getDesktop().setupPlugins();
        Iterator gi = config.getGeometryFilenames().iterator();
        Iterator ii = config.getInteractionsFilenames().iterator();
        while (gi.hasNext()) {
            network = Cytoscape.createNetwork((String)gi.next(), Cytoscape.FILE_BY_SUFFIX, false, null, null);
            if (network.getNodeCount() >= cytoscapeObj.getViewThreshold()) continue;
            Cytoscape.createNetworkView(network);
        }
        while (ii.hasNext()) {
            network = Cytoscape.createNetwork((String)ii.next(), Cytoscape.FILE_SIF, canonicalize, bioDataServer, defaultSpecies);
            if (network.getNodeCount() >= cytoscapeObj.getViewThreshold()) continue;
            Cytoscape.createNetworkView(network);
        }
        this.logger.info("reading attribute files");
        Cytoscape.loadAttributes(config.getNodeAttributeFilenames(), config.getEdgeAttributeFilenames(), canonicalize, bioDataServer, defaultSpecies);
        this.logger.info(" done");
        String expDataFilename = config.getExpressionFilename();
        if (expDataFilename != null) {
            this.logger.info("reading " + expDataFilename + "...");
            try {
                Cytoscape.loadExpressionData(expDataFilename, config.getWhetherToCopyExpToAttribs());
            }
            catch (Exception e) {
                this.logger.severe("Exception reading expression data file '" + expDataFilename + "'");
                this.logger.severe(e.getMessage());
                e.printStackTrace();
            }
            this.logger.info("  done");
        }
        WindowUtilities.hideSplash();
    }

    protected void displayHelp(CytoscapeConfig config) {
        System.out.println(this.version);
        System.out.println(config.getUsage());
        this.exit(0);
    }

    protected void inputError(CytoscapeConfig config) {
        System.out.println(this.version);
        System.out.println("------------- Inputs Error");
        System.out.println(config.getUsage());
        System.out.println(config);
        this.exit(1);
    }

    protected void setupLogger(CytoscapeConfig config) {
        this.logger = Logger.getLogger("global");
        Properties properties = config.getProperties();
        String level = properties.getProperty("logging", "SEVERE");
        if (level.equalsIgnoreCase("severe")) {
            this.logger.setLevel(Level.SEVERE);
        } else if (level.equalsIgnoreCase("warning")) {
            this.logger.setLevel(Level.WARNING);
        } else if (level.equalsIgnoreCase("info")) {
            this.logger.setLevel(Level.INFO);
        } else if (level.equalsIgnoreCase("config")) {
            this.logger.setLevel(Level.CONFIG);
        } else if (level.equalsIgnoreCase("all")) {
            this.logger.setLevel(Level.ALL);
        } else if (level.equalsIgnoreCase("none")) {
            this.logger.setLevel(Level.OFF);
        } else if (level.equalsIgnoreCase("off")) {
            this.logger.setLevel(Level.OFF);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.windowClosed(e);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        this.windows.add(e.getWindow());
    }

    public void windowClosed(WindowEvent e) {
        Window window = e.getWindow();
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        }
        if (this.windows.size() == 0) {
            this.logger.info("all windows closed, exiting...");
            this.exit(0);
        }
    }

    public CyWindow getMainWindow() {
        return this.cyWindow;
    }

    public void exit(int exitCode) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window w = (Window)this.windows.elementAt(i);
            w.dispose();
        }
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setGlobalFontSizeHints(FontSizeHints.MIXED);
        Options.setDefaultIconSize(new Dimension(18, 18));
        try {
            if (LookUtils.isWindowsXP()) {
                UIManager.setLookAndFeel(Options.getSystemLookAndFeelClassName());
            } else if (!System.getProperty("os.name").startsWith("Mac")) {
                Plastic3DLookAndFeel laf = new Plastic3DLookAndFeel();
                Plastic3DLookAndFeel.setTabStyle("metal");
                Plastic3DLookAndFeel.setHighContrastFocusColorsEnabled(true);
                Plastic3DLookAndFeel.setMyCurrentTheme(new ExperienceBlue());
                UIManager.setLookAndFeel(laf);
            }
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
        CyMain app = new CyMain(args);
    }
}

