/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.CompositionFactory;
import com.sun.glf.util.CompositionFrame;
import com.sun.glf.util.GridBagConstants;
import com.sun.glf.util.GridBagPanel;
import com.sun.glf.util.SerializedBeanFileFilter;
import com.sun.glf.util.TextBeanFileFilter;
import com.sun.glf.util.TextBeans;
import com.sun.glf.util.Toolbox;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class CompositionShow
extends JFrame
implements GridBagConstants {
    static final String COMPOSITION_BROWSER = "Composition Browser";
    static final String NEXT = "\u25b6";
    static final String PREV = "\u25c0";
    static final String LOAD = "Load...";
    static final String COMPOSITION_SHOW = "Composition Browser";
    static final String ERROR_CANNOT_LOAD_BEAN = "Error. Cannot load bean : ";
    static final String ERROR_NOT_A_COMPOSITION_BUILDER = "Error: not a CompositionBuilder bean";
    Font SYMBOL_FONT = new Font("Lucida Sans Unicode", 0, 12);
    JComboBox cmpList;
    static JFileChooser fileChooser;
    CompositionFrame viewFrame;
    private JButton nextButton;
    private JButton prevButton;
    private JButton loadButton;
    DefaultComboBoxModel cmpListModel = new DefaultComboBoxModel();

    public CompositionShow() {
        super("Composition Browser");
        this.prevButton = new JButton(PREV);
        this.nextButton = new JButton(NEXT);
        this.loadButton = new JButton(LOAD);
        this.prevButton.setFont(this.SYMBOL_FONT);
        this.nextButton.setFont(this.SYMBOL_FONT);
        this.prevButton.setRolloverEnabled(true);
        this.nextButton.setRolloverEnabled(true);
        this.prevButton.setBorderPainted(false);
        this.nextButton.setBorderPainted(false);
        this.cmpList = new JComboBox(this.cmpListModel);
        Dimension dimension = this.cmpList.getMinimumSize();
        this.cmpList.setMinimumSize(new Dimension(this.nextButton.getPreferredSize().width * 4, dimension.height));
        this.prevButton.setPreferredSize(new Dimension(this.prevButton.getPreferredSize().width, this.cmpList.getPreferredSize().height));
        this.nextButton.setPreferredSize(new Dimension(this.nextButton.getPreferredSize().width, this.cmpList.getPreferredSize().height));
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.add(this.prevButton, 0, 0, 1, 1, 10, 0, 0.0, 0.0);
        gridBagPanel.add(this.cmpList, 1, 0, 1, 1, 10, 2, 1.0, 0.0);
        gridBagPanel.add(this.nextButton, 2, 0, 1, 1, 10, 0, 0.0, 0.0);
        gridBagPanel.add(this.loadButton, 3, 0, 1, 1, 10, 0, 0.0, 0.0);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompositionShow.this.onFileLoad();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompositionShow.this.onNext();
            }
        });
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompositionShow.this.onPrev();
            }
        });
        this.cmpList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CompositionShow.this.onNewSelection();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CompositionShow.this.setVisible(false);
                CompositionShow.this.dispose();
                System.exit(0);
            }
        });
        this.getContentPane().add(gridBagPanel);
        this.setComponentStates();
        this.pack();
    }

    private void onFileLoad() {
        int n;
        Object object;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setDialogType(0);
            SerializedBeanFileFilter serializedBeanFileFilter = new SerializedBeanFileFilter();
            object = new TextBeanFileFilter();
            fileChooser.addChoosableFileFilter(serializedBeanFileFilter);
            fileChooser.addChoosableFileFilter((FileFilter)object);
            fileChooser.setFileSelectionMode(2);
        }
        if ((n = fileChooser.showDialog(null, null)) == 0) {
            object = fileChooser.getSelectedFile();
            File[] fileArray = null;
            fileArray = ((File)object).isDirectory() ? ((File)object).listFiles() : new File[]{object};
            this.loadBeanFiles(fileArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadBeanFiles(File[] fileArray) {
        int n;
        Vector<CompositionDescriptor> vector = new Vector<CompositionDescriptor>();
        int n2 = fileArray != null ? fileArray.length : 0;
        for (n = 0; n < n2; ++n) {
            CompositionFactory compositionFactory = null;
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            String string = null;
            File file = fileArray[n];
            string = file.getName();
            fileInputStream = new FileInputStream(file);
            if (file.getAbsolutePath().toLowerCase().endsWith(".ser.txt")) {
                compositionFactory = (CompositionFactory)TextBeans.read(fileInputStream);
            } else {
                objectInputStream = new ObjectInputStream(fileInputStream);
                compositionFactory = (CompositionFactory)objectInputStream.readObject();
            }
            vector.addElement(new CompositionDescriptor(string, compositionFactory));
            Object var11_14 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (objectInputStream == null) continue;
                objectInputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            {
                catch (ClassCastException classCastException) {
                    JOptionPane.showMessageDialog(null, string + " : " + ERROR_NOT_A_COMPOSITION_BUILDER);
                    var11_14 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (objectInputStream == null) continue;
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, string + " : " + ERROR_CANNOT_LOAD_BEAN + exception.getMessage());
                    var11_14 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (objectInputStream == null) continue;
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_14 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        n = this.cmpList.getSelectedIndex();
        ++n;
        int n3 = vector.size();
        if (n3 > 0) {
            if (n < this.cmpListModel.getSize()) {
                this.cmpListModel.insertElementAt(vector.elementAt(n3 - 1), n);
            } else {
                this.cmpListModel.addElement(vector.elementAt(n3 - 1));
            }
            for (int i = n3 - 2; i >= 0; --i) {
                this.cmpListModel.insertElementAt(vector.elementAt(i), n);
            }
        }
        this.setComponentStates();
    }

    private void setComponentStates() {
        boolean bl = this.cmpListModel.getSize() > 0;
        int n = this.cmpList.getSelectedIndex();
        this.prevButton.setEnabled(bl && n > 0);
        this.nextButton.setEnabled(bl && n < this.cmpListModel.getSize() - 1);
        this.cmpList.setEnabled(bl);
        this.repaint();
    }

    private void onDelete() {
        int n = this.cmpList.getSelectedIndex();
        if (n != -1) {
            this.cmpListModel.removeElementAt(n);
        }
    }

    private void onNext() {
        int n = this.cmpList.getSelectedIndex();
        int n2 = n + 1;
        if (n2 < this.cmpListModel.getSize()) {
            this.cmpList.setSelectedIndex(n2);
        }
    }

    private void onPrev() {
        int n = this.cmpList.getSelectedIndex();
        int n2 = n - 1;
        if (n2 > 0 && n2 < this.cmpListModel.getSize()) {
            this.cmpList.setSelectedIndex(n2);
        }
    }

    private void onNewSelection() {
        int n = this.cmpList.getSelectedIndex();
        CompositionFactory compositionFactory = ((CompositionDescriptor)this.cmpListModel.getElementAt((int)n)).factory;
        if (this.viewFrame == null) {
            this.viewFrame = new CompositionFrame("");
        }
        this.setComponentStates();
        this.viewFrame.load(compositionFactory);
    }

    public static void main(String[] stringArray) {
        Toolbox.swingDefaultsInit();
        Toolbox.initFonts();
        new CompositionShow().setVisible(true);
    }

    static class CompositionDescriptor {
        CompositionFactory factory;
        String desc;

        public CompositionDescriptor(String string, CompositionFactory compositionFactory) {
            this.desc = string;
            this.factory = compositionFactory;
        }

        public String toString() {
            return this.desc;
        }
    }
}

