/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.snippets;

import com.sun.glf.Composition;
import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.ShapeLayer;
import com.sun.glf.TextLayer;
import com.sun.glf.goodies.RadialGradientPaint;
import com.sun.glf.util.CompositionFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class HelloLayers
implements CompositionFactory {
    String text = "Hello Layers";
    Font textFont = new Font("serif", 2, 90);
    Color textColor = Color.white;
    Color shadowColor = new Color(0, 0, 0, 128);
    Dimension size = new Dimension(400, 400);
    Color backgroundColorCenter = new Color(255, 234, 50);
    Color backgroundColorOutside = new Color(153, 50, 0);
    int shadowOffsetX = 7;
    int shadowOffsetY = 5;

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public void setShadowOffsetX(int n) {
        this.shadowOffsetX = n;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public void setShadowOffsetY(int n) {
        this.shadowOffsetY = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public Color getBackgroundColorCenter() {
        return this.backgroundColorCenter;
    }

    public void setBackgroundColorCenter(Color color) {
        this.backgroundColorCenter = color;
    }

    public Color getBackgroundColorOutside() {
        return this.backgroundColorOutside;
    }

    public void setBackgroundColorOutside(Color color) {
        this.backgroundColorOutside = color;
    }

    public Composition build() {
        LayerComposition layerComposition = new LayerComposition(this.size);
        Rectangle rectangle = new Rectangle(0, 0, this.size.width, this.size.height);
        Rectangle rectangle2 = new Rectangle(-rectangle.width, -rectangle.height, 2 * rectangle.width, 2 * rectangle.height);
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(rectangle2, this.backgroundColorCenter, this.backgroundColorOutside);
        FillRenderer fillRenderer = new FillRenderer(radialGradientPaint);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, rectangle, fillRenderer);
        TextLayer textLayer = new TextLayer(layerComposition, this.text, this.textFont, new FillRenderer(this.textColor));
        Shape shape = textLayer.createTransformedShape();
        FillRenderer fillRenderer2 = new FillRenderer(this.shadowColor);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, shape, fillRenderer2);
        shapeLayer2.setTransform(AffineTransform.getTranslateInstance(this.shadowOffsetX, this.shadowOffsetY));
        layerComposition.setLayers(new Layer[]{shapeLayer, shapeLayer2, textLayer});
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return layerComposition;
    }
}

