/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Anchor;
import com.sun.glf.Composition;
import com.sun.glf.FillRenderer;
import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.PaintProgressListener;
import com.sun.glf.Position;
import com.sun.glf.ShapeLayer;
import com.sun.glf.goodies.GaussianKernel;
import com.sun.glf.util.CompositionComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DirectColorModel;
import java.awt.image.LookupOp;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;

public class LayerComposition
implements Composition {
    Layer[] layers;
    private RenderingHints renderingHints;
    private Dimension dim;
    private AffineTransform IDENTITY = new AffineTransform();
    private Paint backgroundPaint;
    private Vector leasedBuffers = new Vector();
    private Vector paintProgressListeners = new Vector();

    public LayerComposition(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.dim = dimension;
    }

    protected LayerComposition() {
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.dim.width, this.dim.height);
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void addPaintProgressListener(PaintProgressListener paintProgressListener) {
        this.paintProgressListeners.addElement(paintProgressListener);
    }

    public void removePaintProgressListener(PaintProgressListener paintProgressListener) {
        this.paintProgressListeners.removeElement(paintProgressListener);
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public int getLayerCount() {
        return this.layers != null ? this.layers.length : 0;
    }

    public Layer getLayer(int n) {
        return this.layers[n];
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = null;
        if (this.renderingHints != null) {
            renderingHints = (RenderingHints)this.renderingHints.clone();
        }
        return renderingHints;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.renderingHints == null) {
            this.renderingHints = new RenderingHints(key, object);
        } else {
            this.renderingHints.put(key, object);
        }
    }

    public void setLayers(Layer[] layerArray) {
        if (layerArray == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < layerArray.length; ++i) {
            if (layerArray[i] != null) continue;
            throw new IllegalArgumentException("Layer at index " + i + " is null");
        }
        this.layers = layerArray;
    }

    public Dimension getSize() {
        return this.dim;
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.dim = (Dimension)dimension.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        this.notifyPaintStart();
        this.leasedBuffers = new Vector();
        try {
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            if (this.renderingHints != null) {
                renderingHints.putAll((Map<?, ?>)this.renderingHints);
            }
            Composite composite = graphics2D.getComposite();
            Shape shape = graphics2D.getClip();
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.backgroundPaint != null) {
                graphics2D.setPaint(this.backgroundPaint);
                graphics2D.fillRect(0, 0, this.dim.width, this.dim.height);
            }
            int n = this.layers.length;
            Composite composite2 = null;
            RenderingHints renderingHints2 = null;
            Shape shape2 = null;
            AffineTransform affineTransform2 = null;
            BufferedImage bufferedImage = null;
            Graphics2D graphics2D2 = null;
            for (int i = 0; i < n; ++i) {
                Layer layer = this.layers[i];
                this.notifyLayerPaintStart(layer);
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
                composite2 = layer.getComposite();
                renderingHints2 = layer.getRenderingHints();
                shape2 = layer.getClip();
                affineTransform2 = layer.getTransform();
                if (composite2 == null) {
                    composite2 = composite;
                }
                if (shape2 == null) {
                    shape2 = shape;
                }
                if (renderingHints2 == null) {
                    renderingHints2 = renderingHints;
                }
                if (affineTransform2 == null) {
                    affineTransform2 = this.IDENTITY;
                }
                BufferedImage bufferedImage2 = layer.getLayerMask();
                Layer.LayerFilter layerFilter = layer.getFilter();
                if (bufferedImage2 == null && layerFilter == null) {
                    graphics2D.clip(shape2);
                    graphics2D.transform(affineTransform2);
                    graphics2D.setRenderingHints(renderingHints2);
                    graphics2D.setComposite(composite2);
                    layer.paint(graphics2D);
                    continue;
                }
                Rectangle rectangle = this.getBounds();
                Rectangle rectangle2 = layer.getLayerMaskRect();
                Rectangle2D rectangle2D = layer.getBounds();
                Object object = affineTransform2.createTransformedShape(rectangle2D).getBounds();
                object = ((Rectangle)object).intersection(rectangle);
                if (rectangle2 != null) {
                    object = ((Rectangle)object).intersection(rectangle2);
                }
                if (((Rectangle)object).width > 0 && ((Rectangle)object).height > 0) {
                    Object object2;
                    Object object3;
                    if (layerFilter != null) {
                        object3 = layerFilter.getFilterMargins();
                        ((Rectangle)object).x -= ((Dimension)object3).width;
                        ((Rectangle)object).y -= ((Dimension)object3).height;
                        ((Rectangle)object).width += ((Dimension)object3).width * 2;
                        ((Rectangle)object).height += ((Dimension)object3).height * 2;
                    }
                    if (bufferedImage == null || bufferedImage.getWidth() < ((Rectangle)object).width || bufferedImage.getHeight() < ((Rectangle)object).height || !this.isOffscreenCompatible(bufferedImage, layer)) {
                        bufferedImage = this.createLayerCompatibleImage(layer, ((Rectangle)object).width, ((Rectangle)object).height);
                    }
                    object3 = bufferedImage.getSubimage(0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
                    graphics2D2 = ((BufferedImage)object3).createGraphics();
                    graphics2D2.setComposite(AlphaComposite.Clear);
                    graphics2D2.fillRect(0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
                    graphics2D2.setComposite(AlphaComposite.SrcOver);
                    graphics2D2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.setRenderingHints(renderingHints2);
                    layer.paint(graphics2D2);
                    if (layerFilter != null) {
                        if (layerFilter.isRasterFilter()) {
                            object2 = layerFilter.getRasterFilter();
                            WritableRaster writableRaster = ((BufferedImage)object3).getRaster();
                            writableRaster = writableRaster.createWritableTranslatedChild(((Rectangle)object).x, ((Rectangle)object).y);
                            WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight());
                            object2.filter(writableRaster, writableRaster2);
                            object3 = new BufferedImage(((BufferedImage)object3).getColorModel(), writableRaster2, ((BufferedImage)object3).isAlphaPremultiplied(), null);
                        } else {
                            object2 = layerFilter.getImageFilter();
                            object3 = object2.filter((BufferedImage)object3, null);
                        }
                        graphics2D2 = ((BufferedImage)object3).createGraphics();
                    } else {
                        graphics2D2.setTransform(this.IDENTITY);
                    }
                    graphics2D2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
                    if (bufferedImage2 != null) {
                        graphics2D2.setComposite(AlphaComposite.DstIn);
                        graphics2D2.drawImage(bufferedImage2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                        object2 = ((Rectangle)object).intersection(rectangle2);
                        object3 = ((BufferedImage)object3).getSubimage(Math.max(0, rectangle2.x - ((Rectangle)object).x), Math.max(0, rectangle2.y - ((Rectangle)object).y), ((Rectangle)object2).width, ((Rectangle)object2).height);
                        object = object2;
                    }
                    graphics2D.clip(shape2);
                    graphics2D.setComposite(composite2);
                    graphics2D.drawImage((Image)object3, ((Rectangle)object).x, ((Rectangle)object).y, null);
                    continue;
                }
                System.out.println("Layer has not active area");
            }
        }
        finally {
            this.leasedBuffers = null;
            this.notifyPaintFinished();
        }
    }

    private boolean isOffscreenCompatible(BufferedImage bufferedImage, Layer layer) {
        boolean bl = true;
        if (!(layer instanceof ImageLayer)) {
            bl = bufferedImage.getType() == 2;
        } else {
            Image image = ((ImageLayer)layer).getImage();
            if (!(image instanceof BufferedImage)) {
                bl = bufferedImage.getType() == 2;
            } else {
                BufferedImage bufferedImage2 = (BufferedImage)image;
                bl = bufferedImage2.getColorModel().equals(bufferedImage.getColorModel());
            }
        }
        return bl;
    }

    private BufferedImage createLayerCompatibleImage(Layer layer, int n, int n2) {
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        BufferedImage bufferedImage = null;
        if (!(layer instanceof ImageLayer)) {
            bufferedImage = new BufferedImage(directColorModel, ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2), true, null);
        } else {
            Image image = ((ImageLayer)layer).getImage();
            if (!(image instanceof BufferedImage)) {
                bufferedImage = new BufferedImage(directColorModel, ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2), true, null);
            } else {
                BufferedImage bufferedImage2 = (BufferedImage)image;
                bufferedImage = new BufferedImage(bufferedImage2.getColorModel(), bufferedImage2.getRaster().createCompatibleWritableRaster(n, n2), bufferedImage2.isAlphaPremultiplied(), null);
            }
        }
        return bufferedImage;
    }

    private void notifyPaintStart() {
        int n = this.paintProgressListeners.size();
        for (int i = 0; i < n; ++i) {
            PaintProgressListener paintProgressListener = (PaintProgressListener)this.paintProgressListeners.elementAt(i);
            paintProgressListener.paintStarted(this, this.layers.length);
        }
    }

    private void notifyLayerPaintStart(Layer layer) {
        String string = layer.getClass().getName();
        int n = this.paintProgressListeners.size();
        for (int i = 0; i < n; ++i) {
            PaintProgressListener paintProgressListener = (PaintProgressListener)this.paintProgressListeners.elementAt(i);
            paintProgressListener.paintStepStarted(this, string);
        }
    }

    private void notifyPaintFinished() {
        int n = this.paintProgressListeners.size();
        for (int i = 0; i < n; ++i) {
            PaintProgressListener paintProgressListener = (PaintProgressListener)this.paintProgressListeners.elementAt(i);
            paintProgressListener.paintFinished(this);
        }
    }

    public BufferedImage leaseBuffer(int n, int n2, int n3) {
        BufferedImage bufferedImage = null;
        if (this.leasedBuffers != null) {
            int n4 = this.leasedBuffers.size();
            for (int i = 0; i < n4; ++i) {
                BufferedImage bufferedImage2 = (BufferedImage)this.leasedBuffers.elementAt(i);
                if (bufferedImage2.getType() != n3 || bufferedImage2.getWidth() < n || bufferedImage2.getHeight() <= n2) continue;
                bufferedImage = bufferedImage2.getSubimage(0, 0, n, n2);
                this.leasedBuffers.remove(bufferedImage2);
                break;
            }
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(n, n2, n3);
            }
        } else {
            bufferedImage = new BufferedImage(n, n2, n3);
        }
        return bufferedImage;
    }

    public void releaseBuffer(BufferedImage bufferedImage) {
        if (this.leasedBuffers != null) {
            this.leasedBuffers.addElement(bufferedImage);
            if (this.leasedBuffers.size() > 2) {
                this.leasedBuffers.remove(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("LayerComposition unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new GridLayout(0, 2));
        CompositionComponent compositionComponent = null;
        Dimension dimension = new Dimension(120, 120);
        LayerComposition layerComposition = new LayerComposition(dimension);
        class SimpleLayer
        extends Layer {
            Color paint = new Color(174, 174, 232);

            public SimpleLayer(LayerComposition layerComposition) {
                super(layerComposition);
            }

            public void paint(Graphics2D graphics2D) {
                int n = this.parent.getSize().width;
                int n2 = this.parent.getSize().height;
                graphics2D.setPaint(this.paint);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setPaint(Color.black);
                graphics2D.drawLine(0, 0, n, n2);
                graphics2D.drawLine(0, n2, n, 0);
            }

            public Rectangle2D getBounds() {
                return new Rectangle(0, 0, this.parent.getSize().width, this.parent.getSize().height);
            }
        }
        layerComposition.setLayers(new Layer[]{new SimpleLayer(layerComposition)});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, no attributes");
        jFrame.getContentPane().add(compositionComponent);
        final RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(new Layer[]{new SimpleLayer(layerComposition){
            {
                super(layerComposition);
                this.setRenderingHints(renderingHints);
            }
        }});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, Antialias on hint.");
        jFrame.getContentPane().add(compositionComponent);
        final AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(new Layer[]{new SimpleLayer(layerComposition){
            {
                super(layerComposition);
                this.setComposite(alphaComposite);
            }
        }});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, Composite (AlphaComposite.5 SrcOver).");
        jFrame.getContentPane().add(compositionComponent);
        final Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, dimension.width, dimension.height);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(new Layer[]{new SimpleLayer(layerComposition){
            {
                super(layerComposition);
                this.setClip(double_);
            }
        }});
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, clip set to Ellipse Shape. Composition hint set.");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        Layer layer = new SimpleLayer(layerComposition);
        layer.setTransform(AffineTransform.getRotateInstance(0.7853981633974483, dimension.width / 2, dimension.height / 2));
        layerComposition.setLayers(new Layer[]{layer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, transform set to rotation");
        jFrame.getContentPane().add(compositionComponent);
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(255 - i);
        }
        ByteLookupTable byteLookupTable = new ByteLookupTable(0, byArray);
        LookupOp lookupOp = new LookupOp(byteLookupTable, null);
        Rectangle rectangle = new Rectangle(-10000, -10000, dimension.width / 2, dimension.height / 3);
        GaussianKernel gaussianKernel = new GaussianKernel(10);
        ConvolveOp convolveOp = new ConvolveOp(gaussianKernel);
        layerComposition = new LayerComposition(dimension);
        layer = new SimpleLayer(layerComposition);
        layer.setImageFilter(convolveOp, new Dimension(20, 20));
        layerComposition.setLayers(new Layer[]{layer});
        layerComposition.setBackgroundPaint(Color.black);
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. Filter set to blur, with filter margins");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        layer = new ShapeLayer(layerComposition, rectangle, new FillRenderer(Color.orange), new Position(Anchor.RIGHT, 20.0f, 20.0f));
        layer.setRasterFilter(convolveOp, new Dimension(20, 20));
        layerComposition.setLayers(new Layer[]{layer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. Filter set to blur, using ShapeLayer");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        layer = new ShapeLayer(layerComposition, rectangle, new FillRenderer(Color.orange), new Position(Anchor.RIGHT, 20.0f, 20.0f));
        layerComposition.setLayers(new Layer[]{layer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. For comparison with blurred version");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        rectangle = new Rectangle(-10000, -10000, dimension.width / 2, dimension.height / 3);
        layer = new ShapeLayer(layerComposition, rectangle, new FillRenderer(Color.black), new Position(Anchor.RIGHT, 20.0f, 20.0f));
        rectangle = ((ShapeLayer)layer).createTransformedShape().getBounds();
        layer.setLayerMask(new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        layer.setRasterFilter(convolveOp, new Dimension(20, 20));
        layerComposition.setLayers(new Layer[]{layer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. Filter set to blur, using ShapeLayer");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        rectangle = new Rectangle(-10000, -10000, dimension.width / 2, dimension.height / 3);
        layer = new ShapeLayer(layerComposition, rectangle, new FillRenderer(Color.black), new Position(Anchor.RIGHT, 20.0f, 20.0f));
        rectangle = ((ShapeLayer)layer).createTransformedShape().getBounds();
        layer.setClip(new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        layer.setRasterFilter(convolveOp, new Dimension(20, 20));
        layerComposition.setLayers(new Layer[]{layer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. Filter set to blur, using ShapeLayer. Clip set");
        jFrame.getContentPane().add(compositionComponent);
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, dimension.width, dimension.height));
        layerComposition = new LayerComposition(dimension);
        SimpleLayer simpleLayer = new SimpleLayer(layerComposition);
        simpleLayer.setLayerMask(bufferedImage);
        simpleLayer.setImageFilter(lookupOp);
        layerComposition.setLayers(new Layer[]{simpleLayer});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. One single layer, mask set to Ellipse2D Shape");
        jFrame.getContentPane().add(compositionComponent);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(new Layer[]{new SimpleLayer(layerComposition){
            {
                super(layerComposition);
                this.setComposite(alphaComposite);
            }
        }, new SimpleLayer(layerComposition){
            {
                super(layerComposition);
                this.setClip(double_);
            }
        }});
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("LayerComposition. Multiple layers, a transparent one in backround and a clipped one in foreground");
        jFrame.getContentPane().add(compositionComponent);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

