/*
 * Decompiled with CFR 0.152.
 */
package coltginy.test;

import coltginy.ColtRootGraph;
import giny.model.Edge;
import giny.model.Node;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ColtRootGraphTest
extends TestCase {
    ColtRootGraph root_graph_0;
    int NUM_NODES = 3;
    static /* synthetic */ Class class$coltginy$test$ColtRootGraphTest;

    public ColtRootGraphTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.root_graph_0 = new ColtRootGraph(){

            public Edge createEdge(int edge_index) {
                return null;
            }

            public Node createNode(int node_index) {
                return null;
            }
        };
    }

    public void tearDown() throws Exception {
    }

    public void testCreateNodes() throws Exception {
        int num_nodes;
        System.out.println("\nTesting Create Nodes---");
        long time = System.currentTimeMillis();
        int[] node_indices = this.root_graph_0.createNodes(this.NUM_NODES);
        System.out.println("--took: " + (System.currentTimeMillis() - time) + " ms.\n\n");
        System.out.println("Testing If Nodes Are Created---");
        time = System.currentTimeMillis();
        int root_nodes = this.root_graph_0.getNodeCount();
        for (num_nodes = 0; num_nodes < root_nodes; ++num_nodes) {
            ColtRootGraphTest.assertTrue(this.root_graph_0.getDegree(node_indices[num_nodes]) == 0);
        }
        ColtRootGraphTest.assertTrue(num_nodes == this.NUM_NODES);
        System.out.println("--took: " + (System.currentTimeMillis() - time) + " ms.\n\n");
        System.out.println("Testing Edge Creation--");
        time = System.currentTimeMillis();
        int directed_edge_count = this.NUM_NODES * (this.NUM_NODES - 1);
        int[] from_nodes = new int[directed_edge_count];
        int[] to_nodes = new int[directed_edge_count];
        int edge_i = 0;
        for (int from_node_i = 0; from_node_i < this.NUM_NODES; ++from_node_i) {
            for (int to_node_i = 0; to_node_i < this.NUM_NODES; ++to_node_i) {
                if (from_node_i == to_node_i) continue;
                from_nodes[edge_i] = node_indices[from_node_i];
                to_nodes[edge_i] = node_indices[to_node_i];
                ++edge_i;
            }
        }
        int[] directed_edge_indices = this.root_graph_0.createEdges(from_nodes, to_nodes, true);
        int[] undirected_edge_indices = this.root_graph_0.createEdges(node_indices, node_indices, false);
        System.out.println("--took: " + (System.currentTimeMillis() - time) + " ms.\n\n");
        System.out.println("Testing that Edges are Created--");
        time = System.currentTimeMillis();
        for (num_nodes = 0; num_nodes < root_nodes; ++num_nodes) {
            System.out.println("Test degree of node: " + node_indices[num_nodes] + " Degree: " + this.root_graph_0.getDegree(node_indices[num_nodes]));
            ColtRootGraphTest.assertTrue(this.root_graph_0.getDegree(node_indices[num_nodes]) == 2 * this.NUM_NODES - 1);
        }
        System.out.println("--took: " + (System.currentTimeMillis() - time) + " ms.\n\n");
        System.out.println("Testing Removal--");
        time = System.currentTimeMillis();
        ColtRootGraphTest.assertTrue(this.root_graph_0.isNeighbor(-1, -2));
        int[] edges_between = this.root_graph_0.getEdgeIndicesArray(-1, -2, true);
        ColtRootGraphTest.assertTrue(edges_between.length == 1);
        this.root_graph_0.removeEdge(edges_between[0]);
        edges_between = this.root_graph_0.getEdgeIndicesArray(-2, -1, true);
        ColtRootGraphTest.assertTrue(edges_between.length == 1);
        this.root_graph_0.removeEdge(edges_between[0]);
        ColtRootGraphTest.assertTrue(!this.root_graph_0.isNeighbor(-1, -2));
        ColtRootGraphTest.assertTrue(!this.root_graph_0.isNeighbor(-2, -1));
        System.out.println("--took: " + (System.currentTimeMillis() - time) + " ms.\n\n");
        int result = this.root_graph_0.createEdge(-1, -2);
        System.out.println("Result was: " + result + " Source: " + this.root_graph_0.getEdgeSourceIndex(result) + " Target: " + this.root_graph_0.getEdgeTargetIndex(result) + " ?? " + this.root_graph_0.isNeighbor(-1, -2));
        ColtRootGraphTest.assertTrue(this.root_graph_0.isNeighbor(-1, -2));
        edges_between = this.root_graph_0.getEdgeIndicesArray(-1, -2, true);
        ColtRootGraphTest.assertTrue(edges_between.length == 1);
        this.root_graph_0.removeEdge(edges_between[0]);
        edges_between = this.root_graph_0.getEdgeIndicesArray(-2, -1, true);
        ColtRootGraphTest.assertTrue(edges_between.length == 1);
        this.root_graph_0.removeEdge(edges_between[0]);
        ColtRootGraphTest.assertTrue(!this.root_graph_0.isNeighbor(-1, -2));
        ColtRootGraphTest.assertTrue(!this.root_graph_0.isNeighbor(-2, -1));
    }

    public void atestColtRootGraph() throws Exception {
        int node_index_0 = this.root_graph_0.createNode();
        ColtRootGraphTest.assertTrue(node_index_0 < 0);
        int node_index_1 = this.root_graph_0.createNode();
        ColtRootGraphTest.assertTrue(node_index_1 < 0);
        ColtRootGraphTest.assertTrue(node_index_1 != node_index_0);
        int edge_index_0 = this.root_graph_0.createEdge(node_index_0, node_index_1, false);
        ColtRootGraphTest.assertTrue(edge_index_0 < 0);
        int node_count = this.root_graph_0.getNodeCount();
        ColtRootGraphTest.assertTrue(node_count == 2);
        int edge_count = this.root_graph_0.getEdgeCount();
        ColtRootGraphTest.assertTrue(edge_count == 1);
        edge_count = this.root_graph_0.getEdgeCount(node_index_0, node_index_1, true);
        ColtRootGraphTest.assertTrue(edge_count == 1);
        int edge_index_1 = this.root_graph_0.createEdge(node_index_0, node_index_1, true);
        ColtRootGraphTest.assertTrue(edge_index_1 < 0);
        ColtRootGraphTest.assertTrue(edge_index_1 != edge_index_0);
        edge_count = this.root_graph_0.getEdgeCount(node_index_0, node_index_1, false);
        ColtRootGraphTest.assertTrue(edge_count == 1);
        edge_count = this.root_graph_0.getEdgeCount(node_index_1, node_index_0, false);
        ColtRootGraphTest.assertTrue(edge_count == 0);
        edge_count = this.root_graph_0.getEdgeCount(node_index_0, node_index_1, true);
        ColtRootGraphTest.assertTrue(edge_count == 2);
        edge_count = this.root_graph_0.getEdgeCount(node_index_1, node_index_0, true);
        ColtRootGraphTest.assertTrue(edge_count == 1);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(class$coltginy$test$ColtRootGraphTest == null ? (class$coltginy$test$ColtRootGraphTest = ColtRootGraphTest.class$("coltginy.test.ColtRootGraphTest")) : class$coltginy$test$ColtRootGraphTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

